/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.chart;

import java.util.List;
import net.sourceforge.plantuml.chart.ChartAxis;
import net.sourceforge.plantuml.chart.ChartSeries;
import net.sourceforge.plantuml.klimt.UTranslate;
import net.sourceforge.plantuml.klimt.color.HColor;
import net.sourceforge.plantuml.klimt.creole.Display;
import net.sourceforge.plantuml.klimt.drawing.UGraphic;
import net.sourceforge.plantuml.klimt.font.FontConfiguration;
import net.sourceforge.plantuml.klimt.font.StringBounder;
import net.sourceforge.plantuml.klimt.font.UFont;
import net.sourceforge.plantuml.klimt.font.UFontFactory;
import net.sourceforge.plantuml.klimt.geom.HorizontalAlignment;
import net.sourceforge.plantuml.klimt.geom.XDimension2D;
import net.sourceforge.plantuml.klimt.shape.TextBlock;
import net.sourceforge.plantuml.klimt.shape.UEllipse;
import net.sourceforge.plantuml.klimt.shape.UPolygon;
import net.sourceforge.plantuml.klimt.shape.URectangle;
import net.sourceforge.plantuml.style.ISkinParam;
import net.sourceforge.plantuml.style.PName;
import net.sourceforge.plantuml.style.SName;
import net.sourceforge.plantuml.style.Style;
import net.sourceforge.plantuml.style.StyleSignatureBasic;

public class ScatterRenderer {
    private final ISkinParam skinParam;
    private final double plotWidth;
    private final double plotHeight;
    private final int categoryCount;
    private final ChartAxis axis;
    private final ChartAxis xAxis;

    public ScatterRenderer(ISkinParam skinParam, double plotWidth, double plotHeight, int categoryCount, ChartAxis axis, ChartAxis xAxis) {
        this.skinParam = skinParam;
        this.plotWidth = plotWidth;
        this.plotHeight = plotHeight;
        this.categoryCount = categoryCount;
        this.axis = axis;
        this.xAxis = xAxis;
    }

    private StyleSignatureBasic getScatterStyleSignature() {
        return StyleSignatureBasic.of(SName.root, SName.element, SName.chartDiagram, SName.scatter);
    }

    private Style getScatterStyle(ChartSeries series) {
        StyleSignatureBasic signature = this.getScatterStyleSignature();
        if (series != null && series.getStereotype() != null) {
            return signature.withTOBECHANGED(series.getStereotype()).getMergedStyle(this.skinParam.getCurrentStyleBuilder());
        }
        return signature.getMergedStyle(this.skinParam.getCurrentStyleBuilder());
    }

    public void draw(UGraphic ug, ChartSeries series, HColor color) {
        if (this.categoryCount == 0 && !series.hasExplicitXValues()) {
            return;
        }
        List<Double> values = series.getValues();
        StringBounder stringBounder = ug.getStringBounder();
        Style scatterStyle = this.getScatterStyle(series);
        HColor markerColor = color;
        HColor styleMarkerColor = scatterStyle.value(PName.MarkerColor).asColor(this.skinParam.getIHtmlColorSet());
        if (styleMarkerColor != null) {
            markerColor = styleMarkerColor;
        } else {
            HColor styleLineColor = scatterStyle.value(PName.LineColor).asColor(this.skinParam.getIHtmlColorSet());
            if (styleLineColor != null && color == null) {
                markerColor = styleLineColor;
            }
        }
        double markerSize = 8.0;
        try {
            Double styleMarkerSize = scatterStyle.value(PName.MarkerSize).asDouble();
            if (styleMarkerSize != null && styleMarkerSize > 0.0) {
                markerSize = styleMarkerSize;
            }
        }
        catch (Exception styleMarkerSize) {
            // empty catch block
        }
        ChartSeries.MarkerShape markerShape = series.getMarkerShape();
        try {
            String styleMarkerShape = scatterStyle.value(PName.MarkerShape).asString();
            if (styleMarkerShape != null && !styleMarkerShape.isEmpty()) {
                switch (styleMarkerShape.toLowerCase()) {
                    case "circle": {
                        markerShape = ChartSeries.MarkerShape.CIRCLE;
                        break;
                    }
                    case "square": {
                        markerShape = ChartSeries.MarkerShape.SQUARE;
                        break;
                    }
                    case "triangle": {
                        markerShape = ChartSeries.MarkerShape.TRIANGLE;
                    }
                }
            }
        }
        catch (Exception styleMarkerShape) {
            // empty catch block
        }
        if (series.hasExplicitXValues()) {
            List<Double> xValues = series.getXValues();
            for (int i = 0; i < values.size(); ++i) {
                double xVal = xValues.get(i);
                double yVal = values.get(i);
                double x = this.xAxis.valueToPixel(xVal, 0.0, this.plotWidth);
                double y = this.plotHeight - (yVal - this.axis.getMin()) / (this.axis.getMax() - this.axis.getMin()) * this.plotHeight;
                this.drawMarker(ug, markerColor, x, y, markerSize, markerShape);
                if (!series.isShowLabels()) continue;
                this.drawLabel(ug, yVal, x, y - markerSize / 2.0 - 8.0, stringBounder);
            }
        } else {
            double categoryWidth = this.plotWidth / (double)this.categoryCount;
            for (int i = 0; i < Math.min(values.size(), this.categoryCount); ++i) {
                double value = values.get(i);
                double x = ((double)i + 0.5) * categoryWidth;
                double y = this.plotHeight - (value - this.axis.getMin()) / (this.axis.getMax() - this.axis.getMin()) * this.plotHeight;
                this.drawMarker(ug, markerColor, x, y, markerSize, markerShape);
                if (!series.isShowLabels()) continue;
                this.drawLabel(ug, value, x, y - markerSize / 2.0 - 8.0, stringBounder);
            }
        }
    }

    private void drawMarker(UGraphic ug, HColor color, double x, double y, double size, ChartSeries.MarkerShape shape) {
        switch (shape) {
            case CIRCLE: {
                this.drawCircleMarker(ug, color, x, y, size);
                break;
            }
            case SQUARE: {
                this.drawSquareMarker(ug, color, x, y, size);
                break;
            }
            case TRIANGLE: {
                this.drawTriangleMarker(ug, color, x, y, size);
                break;
            }
            default: {
                this.drawCircleMarker(ug, color, x, y, size);
            }
        }
    }

    private void drawCircleMarker(UGraphic ug, HColor color, double x, double y, double size) {
        UEllipse marker = UEllipse.build(size, size);
        ug.apply(color).apply(color.bg()).apply(UTranslate.dx(x - size / 2.0).compose(UTranslate.dy(y - size / 2.0))).draw(marker);
    }

    private void drawSquareMarker(UGraphic ug, HColor color, double x, double y, double size) {
        URectangle marker = URectangle.build(size, size);
        ug.apply(color).apply(color.bg()).apply(UTranslate.dx(x - size / 2.0).compose(UTranslate.dy(y - size / 2.0))).draw(marker);
    }

    private void drawTriangleMarker(UGraphic ug, HColor color, double x, double y, double size) {
        UPolygon triangle = new UPolygon();
        triangle.addPoint(0.0, -size / 2.0);
        triangle.addPoint(-size / 2.0, size / 2.0);
        triangle.addPoint(size / 2.0, size / 2.0);
        ug.apply(color).apply(color.bg()).apply(UTranslate.dx(x).compose(UTranslate.dy(y))).draw(triangle);
    }

    private void drawLabel(UGraphic ug, double value, double x, double y, StringBounder stringBounder) {
        try {
            String label = this.formatValue(value);
            UFont font = UFontFactory.sansSerif(10).bold();
            HColor labelColor = this.skinParam.getIHtmlColorSet().getColor("#000000");
            FontConfiguration fontConfig = FontConfiguration.create(font, labelColor, labelColor, null);
            TextBlock textBlock = Display.getWithNewlines(this.skinParam.getPragma(), label).create(fontConfig, HorizontalAlignment.CENTER, this.skinParam);
            XDimension2D textDim = textBlock.calculateDimension(stringBounder);
            double labelX = x - textDim.getWidth() / 2.0;
            double labelY = y - textDim.getHeight() - 2.0;
            textBlock.drawU(ug.apply(UTranslate.dx(labelX).compose(UTranslate.dy(labelY))));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private String formatValue(double value) {
        if (Math.abs(value) < 0.01 && value != 0.0) {
            return String.format("%.2e", value);
        }
        if (value == (double)((long)value)) {
            return String.format("%d", (long)value);
        }
        return String.format("%.2f", value);
    }
}

