/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.chronology;

import java.time.DayOfWeek;
import java.time.LocalDate;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import net.sourceforge.plantuml.klimt.UStroke;
import net.sourceforge.plantuml.klimt.color.HColor;
import net.sourceforge.plantuml.klimt.color.HColorSet;
import net.sourceforge.plantuml.klimt.drawing.UGraphic;
import net.sourceforge.plantuml.project.GanttStyle;
import net.sourceforge.plantuml.project.OpenClose;
import net.sourceforge.plantuml.project.ngm.math.PiecewiseConstant;
import net.sourceforge.plantuml.project.time.TimePoint;
import net.sourceforge.plantuml.style.PName;
import net.sourceforge.plantuml.style.SName;
import net.sourceforge.plantuml.style.Style;

public class TimeHeaderParameters2
implements GanttStyle {
    final Map<TimePoint, HColor> colorDays;
    final double scale;
    final LocalDate minDay;
    final LocalDate maxDay;
    final HColorSet colorSet;
    final GanttStyle ganttStyle;
    final Locale locale;
    final OpenClose openClose;
    final Map<DayOfWeek, HColor> colorDaysOfWeek;
    final Set<TimePoint> verticalSeparatorBefore;
    final boolean hideClosed;

    public TimeHeaderParameters2(Map<TimePoint, HColor> colorDays, double scale, LocalDate minDay, LocalDate maxDay, HColorSet colorSet, Locale locale, OpenClose openClose, Map<DayOfWeek, HColor> colorDaysOfWeek, Set<TimePoint> verticalSeparatorBefore, GanttStyle ganttStyle, boolean hideClosed) {
        this.colorDays = colorDays;
        this.scale = scale;
        this.minDay = minDay;
        this.maxDay = maxDay;
        this.colorSet = Objects.requireNonNull(colorSet);
        this.ganttStyle = ganttStyle;
        this.locale = locale;
        this.openClose = openClose;
        this.colorDaysOfWeek = colorDaysOfWeek;
        this.verticalSeparatorBefore = verticalSeparatorBefore;
        this.hideClosed = hideClosed;
    }

    public HColor getColor(TimePoint wink) {
        return this.colorDays.get(wink);
    }

    public HColor getColor(DayOfWeek dayOfWeek) {
        return this.colorDaysOfWeek.get(dayOfWeek);
    }

    public final double getScale() {
        return this.scale;
    }

    public final LocalDate getMinDay() {
        return this.minDay;
    }

    public final LocalDate getMaxDay() {
        return this.maxDay;
    }

    public final HColorSet getColorSet() {
        return this.colorSet;
    }

    public final Style getTimelineStyle() {
        return this.getStyle(SName.timeline);
    }

    public final Style getClosedStyle() {
        return this.getStyle(SName.closed);
    }

    public final Locale getLocale() {
        return this.locale;
    }

    public final PiecewiseConstant getLoadPlanable() {
        return this.openClose.asPiecewiseConstant();
    }

    public final Set<TimePoint> getVerticalSeparatorBefore() {
        return this.verticalSeparatorBefore;
    }

    public final UGraphic forVerticalSeparator(UGraphic ug) {
        Style style = this.getStyle(SName.verticalSeparator);
        HColor color = style.value(PName.LineColor).asColor(this.getColorSet());
        UStroke stroke = style.getStroke();
        return ug.apply(color).apply(stroke);
    }

    @Override
    public final Style getStyle(SName param1, SName param2) {
        return this.ganttStyle.getStyle(param1, param2);
    }

    @Override
    public Style getStyle(SName param) {
        return this.ganttStyle.getStyle(param);
    }

    public final double getCellWidth() {
        double w = this.getStyle(SName.timeline, SName.day).value(PName.FontSize).asDouble();
        return w * 1.6;
    }

    public boolean isHideClosed() {
        return this.hideClosed;
    }

    public OpenClose getOpenClose() {
        return this.openClose;
    }
}

