/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.command;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import net.sourceforge.plantuml.AbstractPSystem;
import net.sourceforge.plantuml.EmbeddedDiagram;
import net.sourceforge.plantuml.ErrorUml;
import net.sourceforge.plantuml.ErrorUmlType;
import net.sourceforge.plantuml.Previous;
import net.sourceforge.plantuml.command.Command;
import net.sourceforge.plantuml.command.CommandControl;
import net.sourceforge.plantuml.command.CommandDecoratorMultine;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.PSystemAbstractFactory;
import net.sourceforge.plantuml.command.ParserPass;
import net.sourceforge.plantuml.core.Diagram;
import net.sourceforge.plantuml.core.DiagramType;
import net.sourceforge.plantuml.core.UmlSource;
import net.sourceforge.plantuml.error.PSystemError;
import net.sourceforge.plantuml.error.PSystemErrorUtils;
import net.sourceforge.plantuml.nio.PathSystem;
import net.sourceforge.plantuml.preproc.PreprocessingArtifact;
import net.sourceforge.plantuml.teavm.browser.BrowserLog;
import net.sourceforge.plantuml.text.StringLocated;
import net.sourceforge.plantuml.utils.BlocLines;
import net.sourceforge.plantuml.utils.LineLocation;
import net.sourceforge.plantuml.utils.StartUtils;
import net.sourceforge.plantuml.version.IteratorCounter2;

public abstract class PSystemCommandFactory
extends PSystemAbstractFactory {
    private final List<Command> cmds = new ArrayList<Command>();

    protected abstract void initCommandsList(List<Command> var1);

    public abstract AbstractPSystem createEmptyDiagram(PathSystem var1, UmlSource var2, Previous var3, PreprocessingArtifact var4);

    protected PSystemCommandFactory() {
        this(DiagramType.UML);
    }

    protected PSystemCommandFactory(DiagramType type) {
        super(type);
    }

    @Override
    public final Diagram createSystem(PathSystem pathSystem, UmlSource source, Previous previous, PreprocessingArtifact preprocessing) {
        BrowserLog.consoleLog(this.getClass(), "createSystem");
        IteratorCounter2 it = source.iterator2();
        StringLocated startLine = (StringLocated)it.next();
        if (!StartUtils.isArobaseStartDiagram(startLine.getString())) {
            throw new UnsupportedOperationException();
        }
        if (source.isEmpty()) {
            if (it.hasNext()) {
                it.next();
            }
            return this.buildEmptyError(source, startLine.getLocation(), it.getTrace(), preprocessing);
        }
        AbstractPSystem sys = this.createEmptyDiagram(pathSystem, source, previous, preprocessing);
        Set<ParserPass> requiredPass = sys.getRequiredPass();
        block0: for (ParserPass pass : requiredPass) {
            sys.startingPass(pass);
            while (it.hasNext()) {
                if (StartUtils.isArobaseEndDiagram(it.peek().getString())) {
                    it = source.iterator2();
                    it.next();
                    continue block0;
                }
                if (!((sys = this.executeFewLines(sys, source, it, pass, preprocessing)) instanceof PSystemError)) continue;
                return sys;
            }
        }
        return this.finalizeDiagram(sys, source, it, preprocessing);
    }

    private Diagram finalizeDiagram(AbstractPSystem sys, UmlSource source, IteratorCounter2 it, PreprocessingArtifact preprocessing) {
        if (sys == null) {
            return null;
        }
        String err = sys.checkFinalError();
        if (err != null) {
            LineLocation location = ((StringLocated)it.next()).getLocation();
            return this.buildExecutionError(source, err, location, it.getTrace(), preprocessing);
        }
        if (source.getTotalLineCount() == 2) {
            LineLocation location = ((StringLocated)it.next()).getLocation();
            return this.buildEmptyError(source, location, it.getTrace(), preprocessing);
        }
        sys.makeDiagramReady();
        if (!sys.isOk()) {
            return null;
        }
        return sys;
    }

    private AbstractPSystem executeFewLines(AbstractPSystem sys, UmlSource source, IteratorCounter2 it, ParserPass currentPass, PreprocessingArtifact preprocessing) {
        Step step = this.getCandidate(it);
        if (step == null) {
            ErrorUml err = new ErrorUml(ErrorUmlType.SYNTAX_ERROR, "Syntax Error?", 0, it.peek().getLocation(), this.getUmlDiagramType());
            it.next();
            return PSystemErrorUtils.buildV2(source, err, null, it.getTrace(), preprocessing);
        }
        if (!step.command.isEligibleFor(currentPass)) {
            return sys;
        }
        CommandExecutionResult result = sys.executeCommand(step.command, step.blocLines, currentPass);
        if (!result.isOk()) {
            LineLocation location = step.blocLines.getFirst().getLocation();
            ErrorUml err = new ErrorUml(ErrorUmlType.EXECUTION_ERROR, result.getError(), result.getScore(), location, this.getUmlDiagramType());
            sys = PSystemErrorUtils.buildV2(source, err, result.getDebugLines(), it.getTrace(), preprocessing);
        }
        if (result.getNewDiagram() != null) {
            sys = result.getNewDiagram();
        }
        return sys;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Step getCandidate(IteratorCounter2 it) {
        BlocLines single = BlocLines.single(it.peek());
        List<Command> list = this.cmds;
        synchronized (list) {
            if (this.cmds.size() == 0) {
                this.initCommandsList(this.cmds);
            }
        }
        for (Command cmd : this.cmds) {
            IteratorCounter2 cloned;
            BlocLines lines;
            CommandControl result = cmd.isValid(single);
            if (result == CommandControl.OK) {
                it.next();
                return new Step(cmd, single);
            }
            if (result != CommandControl.OK_PARTIAL || (lines = this.isMultilineCommandOk(cloned = it.cloneMe(), cmd)) == null) continue;
            it.copyStateFrom(cloned);
            return new Step(cmd, lines);
        }
        return null;
    }

    private BlocLines isMultilineCommandOk(IteratorCounter2 it, Command cmd) {
        BlocLines lines = BlocLines.create();
        int nb = 0;
        while (it.hasNext()) {
            CommandControl result = cmd.isValid(lines = PSystemCommandFactory.addOneSingleLineManageEmbedded2(it, lines));
            if (result == CommandControl.NOT_OK) {
                return null;
            }
            if (result == CommandControl.OK) {
                return lines;
            }
            if (!(cmd instanceof CommandDecoratorMultine) || ++nb <= ((CommandDecoratorMultine)cmd).getNbMaxLines()) continue;
            return null;
        }
        return null;
    }

    private static BlocLines addOneSingleLineManageEmbedded2(IteratorCounter2 it, BlocLines lines) {
        StringLocated linetoBeAdded = (StringLocated)it.next();
        lines = lines.add(linetoBeAdded);
        if (EmbeddedDiagram.getEmbeddedType(linetoBeAdded.getTrimmed().getString()) != null) {
            int nested = 1;
            while (it.hasNext()) {
                StringLocated s = (StringLocated)it.next();
                lines = lines.add(s);
                if (EmbeddedDiagram.getEmbeddedType(s.getTrimmed().getString()) != null) {
                    ++nested;
                    continue;
                }
                if (!s.getTrimmed().getString().equals("}}") || --nested != 0) continue;
                return lines;
            }
        }
        return lines;
    }

    static class Step {
        final Command command;
        final BlocLines blocLines;

        Step(Command command, BlocLines blocLines) {
            this.command = command;
            this.blocLines = blocLines;
        }
    }
}

