/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.crash;

import net.atmp.PixelImage;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.crash.ReportLog;
import net.sourceforge.plantuml.flashcode.FlashCodeFactory;
import net.sourceforge.plantuml.flashcode.FlashCodeUtils;
import net.sourceforge.plantuml.fun.IconLoader;
import net.sourceforge.plantuml.klimt.AffineTransformType;
import net.sourceforge.plantuml.klimt.UTranslate;
import net.sourceforge.plantuml.klimt.awt.PortableImage;
import net.sourceforge.plantuml.klimt.awt.XColor;
import net.sourceforge.plantuml.klimt.drawing.UGraphic;
import net.sourceforge.plantuml.klimt.geom.GraphicPosition;
import net.sourceforge.plantuml.klimt.shape.GraphicStrings;
import net.sourceforge.plantuml.klimt.shape.TextBlock;
import net.sourceforge.plantuml.klimt.shape.UDrawable;
import net.sourceforge.plantuml.klimt.shape.UImage;
import net.sourceforge.plantuml.teavm.TeaVM;
import net.sourceforge.plantuml.utils.Log;

public class CrashImage
implements UDrawable {
    private final PortableImage flashcodeImage;
    private final TextBlock graphicStrings;

    public CrashImage(Throwable exception, String flash, ReportLog strings) {
        if (exception != null) {
            strings.addAll(CommandExecutionResult.getStackTrace(exception));
        }
        this.flashcodeImage = flash == null ? null : this.generateFlashcodeImage(flash, strings);
        this.graphicStrings = GraphicStrings.createBlackOnWhite(strings.asList(), IconLoader.getRandom(), GraphicPosition.BACKGROUND_CORNER_TOP_RIGHT);
    }

    @Override
    public void drawU(UGraphic ug) {
        this.graphicStrings.drawU(ug);
        if (this.flashcodeImage == null) {
            return;
        }
        double height = this.graphicStrings.calculateDimension(ug.getStringBounder()).getHeight();
        ug = ug.apply(UTranslate.dy(height));
        ug.draw(new UImage(new PixelImage(this.flashcodeImage, AffineTransformType.TYPE_NEAREST_NEIGHBOR)).scale(3.0));
    }

    private PortableImage generateFlashcodeImage(String flash, ReportLog strings) {
        assert (flash != null);
        if (!TeaVM.isTeaVM()) {
            FlashCodeUtils utils = FlashCodeFactory.getFlashCodeUtils();
            try {
                PortableImage flashcodeImage = utils.exportFlashcode(flash, XColor.BLACK, XColor.WHITE);
                if (flashcodeImage != null) {
                    strings.addDecodeHint();
                }
                return flashcodeImage;
            }
            catch (Throwable e) {
                Log.error("Issue in flashcode generation " + String.valueOf(e));
            }
        }
        return null;
    }
}

