/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.elk;

import java.util.HashMap;
import java.util.Map;
import net.atmp.CucaDiagram;
import net.sourceforge.plantuml.abel.CucaNote;
import net.sourceforge.plantuml.abel.Entity;
import net.sourceforge.plantuml.abel.Link;
import net.sourceforge.plantuml.decoration.symbol.USymbolFolder;
import net.sourceforge.plantuml.elk.CucaDiagramFileMakerElk;
import net.sourceforge.plantuml.elk.MyElkCluster;
import net.sourceforge.plantuml.elk.MyElkEdge;
import net.sourceforge.plantuml.elk.proxy.graph.ElkEdge;
import net.sourceforge.plantuml.elk.proxy.graph.ElkNode;
import net.sourceforge.plantuml.klimt.UTranslate;
import net.sourceforge.plantuml.klimt.color.HColor;
import net.sourceforge.plantuml.klimt.creole.CreoleMode;
import net.sourceforge.plantuml.klimt.creole.Display;
import net.sourceforge.plantuml.klimt.drawing.UGraphic;
import net.sourceforge.plantuml.klimt.font.FontConfiguration;
import net.sourceforge.plantuml.klimt.font.FontParam;
import net.sourceforge.plantuml.klimt.font.StringBounder;
import net.sourceforge.plantuml.klimt.geom.HorizontalAlignment;
import net.sourceforge.plantuml.klimt.geom.MinMax;
import net.sourceforge.plantuml.klimt.geom.VerticalAlignment;
import net.sourceforge.plantuml.klimt.geom.XDimension2D;
import net.sourceforge.plantuml.klimt.geom.XPoint2D;
import net.sourceforge.plantuml.klimt.shape.AbstractTextBlock;
import net.sourceforge.plantuml.klimt.shape.TextBlock;
import net.sourceforge.plantuml.klimt.shape.TextBlockUtils;
import net.sourceforge.plantuml.skin.AlignmentParam;
import net.sourceforge.plantuml.skin.UmlDiagramType;
import net.sourceforge.plantuml.skin.VisibilityModifier;
import net.sourceforge.plantuml.skin.rose.Rose;
import net.sourceforge.plantuml.stereo.Stereotype;
import net.sourceforge.plantuml.style.ISkinParam;
import net.sourceforge.plantuml.style.SName;
import net.sourceforge.plantuml.style.Style;
import net.sourceforge.plantuml.style.StyleSignature;
import net.sourceforge.plantuml.style.StyleSignatureBasic;
import net.sourceforge.plantuml.svek.Bibliotekon;
import net.sourceforge.plantuml.svek.ClusterManager;
import net.sourceforge.plantuml.svek.GeneralImageBuilder;
import net.sourceforge.plantuml.svek.IEntityImage;
import net.sourceforge.plantuml.svek.IEntityImageUtils;
import net.sourceforge.plantuml.svek.SvekNode;
import net.sourceforge.plantuml.svek.image.EntityImageNoteLink;
import net.sourceforge.plantuml.utils.Position;

class MyElkDrawing
extends AbstractTextBlock {
    private final MinMax minMax;
    private final CucaDiagram diagram;
    private final Map<Entity, ElkNode> clusters;
    private final Map<Link, ElkEdge> edges;
    private final Map<Entity, ElkNode> nodes;
    private final ClusterManager clusterManager;

    public MyElkDrawing(ClusterManager clusterManager, CucaDiagram diagram, MinMax minMax, Map<Entity, ElkNode> clusters, Map<Link, ElkEdge> edges, Map<Entity, ElkNode> nodes) {
        this.clusterManager = clusterManager;
        this.minMax = minMax;
        this.diagram = diagram;
        this.clusters = clusters;
        this.edges = edges;
        this.nodes = nodes;
    }

    @Override
    public void drawU(UGraphic ug) {
        Map<Entity, MyElkCluster> clusters = this.drawAllClusters(ug);
        Map<Entity, IEntityImage> nodes = this.drawAllNodes(ug);
        this.drawAllEdges(ug, clusters, nodes);
    }

    private Map<Entity, MyElkCluster> drawAllClusters(UGraphic ug) {
        HashMap<Entity, MyElkCluster> elkClusters = new HashMap<Entity, MyElkCluster>();
        for (Map.Entry<Entity, ElkNode> ent : this.clusters.entrySet()) {
            Entity entity = ent.getKey();
            MyElkCluster elkCluster = new MyElkCluster(this.diagram, entity, ent.getValue());
            elkCluster.drawSingleCluster(ug);
            elkClusters.put(entity, elkCluster);
        }
        return elkClusters;
    }

    private Map<Entity, IEntityImage> drawAllNodes(UGraphic ug) {
        HashMap<Entity, IEntityImage> elkNodes = new HashMap<Entity, IEntityImage>();
        for (Map.Entry<Entity, ElkNode> ent : this.nodes.entrySet()) {
            Entity entity = ent.getKey();
            XPoint2D corner = CucaDiagramFileMakerElk.getPosition(ent.getValue());
            SvekNode svekNode = this.clusterManager.getBibliotekon().getNode(entity);
            svekNode.resetMove();
            svekNode.moveDelta(corner.x, corner.y);
            IEntityImage image = IEntityImageUtils.translate(this.printEntityInternal(entity), UTranslate.point(corner));
            image.drawU(ug);
            elkNodes.put(entity, image);
        }
        return elkNodes;
    }

    private void drawAllEdges(UGraphic ug, Map<Entity, MyElkCluster> elkClusters, Map<Entity, IEntityImage> nodeImages) {
        for (Map.Entry<Link, ElkEdge> ent : this.edges.entrySet()) {
            Link link = ent.getKey();
            if (link.isInvis()) continue;
            this.drawSingleEdge(ug, link, ent.getValue(), elkClusters, nodeImages);
        }
    }

    private IEntityImage printEntityInternal(Entity ent) {
        if (ent.isRemoved()) {
            throw new IllegalStateException();
        }
        if (ent.getSvekImage() == null) {
            ISkinParam skinParam = this.diagram.getSkinParam();
            if (skinParam.sameClassWidth()) {
                System.err.println("NOT YET IMPLEMENED");
            }
            return GeneralImageBuilder.createEntityImageBlock(ent, this.diagram.isHideEmptyDescriptionForState(), this.diagram, this.getBibliotekon(), null, this.diagram.getLinks());
        }
        return ent.getSvekImage();
    }

    private Bibliotekon getBibliotekon() {
        return this.clusterManager.getBibliotekon();
    }

    private void drawSingleEdge(UGraphic ug, Link link, ElkEdge edge, Map<Entity, MyElkCluster> elkClusters, Map<Entity, IEntityImage> nodeImages) {
        XPoint2D translate = CucaDiagramFileMakerElk.getPosition(edge.getContainingNode());
        double magicY2 = 0.0;
        Entity dest = link.getEntity2();
        if (dest.getUSymbol() instanceof USymbolFolder) {
            // empty if block
        }
        TextBlock label = this.getLabel(ug.getStringBounder(), link);
        TextBlock quantifier1 = this.getQuantifier(ug.getStringBounder(), link, 1);
        TextBlock quantifier2 = this.getQuantifier(ug.getStringBounder(), link, 2);
        TextBlock role1 = this.getRoleLabel(ug.getStringBounder(), link, 1);
        TextBlock role2 = this.getRoleLabel(ug.getStringBounder(), link, 2);
        TextBlock tailLabel = quantifier1 != null ? quantifier1 : role1;
        TextBlock headLabel = quantifier2 != null ? quantifier2 : role2;
        TextBlock tailRole = quantifier1 != null ? role1 : null;
        TextBlock headRole = quantifier2 != null ? role2 : null;
        MyElkEdge elkPath = new MyElkEdge(this.diagram, SName.classDiagram, link, edge, label, tailLabel, headLabel, tailRole, headRole, 0.0, elkClusters, UTranslate.point(translate), nodeImages);
        elkPath.drawU(ug);
    }

    private FontConfiguration getFontForLink(Link link, ISkinParam skinParam) {
        SName styleName = skinParam.getUmlDiagramType().getStyleName();
        Style style = this.getDefaultStyleDefinitionArrow(link.getStereotype(), styleName).getMergedStyle(link.getStyleBuilder());
        return style.getFontConfiguration(skinParam.getIHtmlColorSet());
    }

    public final StyleSignature getDefaultStyleDefinitionArrow(Stereotype stereotype, SName styleName) {
        StyleSignature result = StyleSignatureBasic.of(SName.root, SName.element, styleName, SName.arrow);
        if (stereotype != null) {
            result = result.withTOBECHANGED(stereotype);
        }
        return result;
    }

    private HorizontalAlignment getMessageTextAlignment(UmlDiagramType umlDiagramType, ISkinParam skinParam) {
        if (umlDiagramType == UmlDiagramType.STATE) {
            return skinParam.getHorizontalAlignment(AlignmentParam.stateMessageAlignment, null, false, null);
        }
        return skinParam.getDefaultTextAlignment(HorizontalAlignment.CENTER);
    }

    private TextBlock addVisibilityModifier(TextBlock block, Link link, ISkinParam skinParam) {
        VisibilityModifier visibilityModifier = link.getVisibilityModifier();
        if (visibilityModifier != null) {
            Rose rose = new Rose();
            HColor fore = rose.getHtmlColor(skinParam, visibilityModifier.getForeground());
            TextBlock visibility = visibilityModifier.getUBlock(skinParam.classAttributeIconSize(), fore, null, false);
            visibility = TextBlockUtils.withMargin(visibility, 0.0, 1.0, 2.0, 0.0);
            block = TextBlockUtils.mergeLR(visibility, block, VerticalAlignment.CENTER);
        }
        double marginLabel = 1.0;
        return TextBlockUtils.withMargin(block, 1.0, 1.0);
    }

    private TextBlock getLabel(StringBounder stringBounder, Link link) {
        TextBlock labelOnly;
        ISkinParam skinParam = this.diagram.getSkinParam();
        double marginLabel = 1.0;
        UmlDiagramType type = skinParam.getUmlDiagramType();
        FontConfiguration font = this.getFontForLink(link, skinParam);
        if (Display.isNull(link.getLabel())) {
            labelOnly = TextBlockUtils.EMPTY_TEXT_BLOCK;
        } else {
            HorizontalAlignment alignment = this.getMessageTextAlignment(type, skinParam);
            boolean hasSeveralGuideLines = link.getLabel().hasSeveralGuideLines();
            TextBlock block = link.getLabel().create0(font, alignment, skinParam, skinParam.maxMessageSize(), CreoleMode.SIMPLE_LINE, null, null);
            labelOnly = this.addVisibilityModifier(block, link, skinParam);
        }
        CucaNote note = link.getNote();
        if (note == null) {
            if (!TextBlockUtils.isEmpty(labelOnly, stringBounder)) {
                labelOnly = TextBlockUtils.withMargin(labelOnly, 1.0, 1.0);
            }
            return labelOnly;
        }
        EntityImageNoteLink noteOnly = new EntityImageNoteLink(note.getDisplay(), note.getColors(), skinParam, link.getStyleBuilder());
        if (note.getPosition() == Position.LEFT) {
            return TextBlockUtils.mergeLR(noteOnly, labelOnly, VerticalAlignment.CENTER);
        }
        if (note.getPosition() == Position.RIGHT) {
            return TextBlockUtils.mergeLR(labelOnly, noteOnly, VerticalAlignment.CENTER);
        }
        if (note.getPosition() == Position.TOP) {
            return TextBlockUtils.mergeTB((TextBlock)noteOnly, labelOnly, HorizontalAlignment.CENTER);
        }
        return TextBlockUtils.mergeTB(labelOnly, noteOnly, HorizontalAlignment.CENTER);
    }

    private TextBlock getQuantifier(StringBounder stringBounder, Link link, int n) {
        String tmp;
        String string = tmp = n == 1 ? link.getQuantifier1() : link.getQuantifier2();
        if (tmp == null) {
            return null;
        }
        ISkinParam skinParam = this.diagram.getSkinParam();
        FontConfiguration labelFont = FontConfiguration.create(skinParam, FontParam.ARROW, null);
        TextBlock label = Display.getWithNewlines(this.diagram.getPragma(), tmp).create(labelFont, skinParam.getDefaultTextAlignment(HorizontalAlignment.CENTER), skinParam);
        if (TextBlockUtils.isEmpty(label, stringBounder)) {
            return null;
        }
        return label;
    }

    private TextBlock getRoleLabel(StringBounder stringBounder, Link link, int n) {
        String role;
        String string = role = n == 1 ? link.getRole1() : link.getRole2();
        if (role == null) {
            return null;
        }
        ISkinParam skinParam = this.diagram.getSkinParam();
        FontConfiguration labelFont = FontConfiguration.create(skinParam, FontParam.ARROW, null);
        TextBlock label = Display.getWithNewlines(this.diagram.getPragma(), role).create(labelFont, skinParam.getDefaultTextAlignment(HorizontalAlignment.CENTER), skinParam);
        if (TextBlockUtils.isEmpty(label, stringBounder)) {
            return null;
        }
        return label;
    }

    @Override
    public XDimension2D calculateDimension(StringBounder stringBounder) {
        if (this.minMax == null) {
            throw new UnsupportedOperationException();
        }
        return this.minMax.getDimension();
    }

    @Override
    public HColor getBackcolor() {
        return null;
    }
}

