/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.file;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.sourceforge.plantuml.cli.CliOptions;
import net.sourceforge.plantuml.cli.GlobalConfig;
import net.sourceforge.plantuml.cli.GlobalConfigKey;
import net.sourceforge.plantuml.regex.Matcher2;
import net.sourceforge.plantuml.regex.Pattern2;

public class FileGroup {
    private final List<File> result = new ArrayList<File>();
    private final String pattern;
    private final List<String> excluded;
    private static final Pattern2 predirPath = Pattern2.cmpile("^([^*?]*[/\\\\])?(.*)$");
    private static final Pattern2 noStarInDirectory = Pattern2.cmpile("^(?:([^*?]*)[/\\\\])?([^/\\\\]*)$");

    public FileGroup(String pattern, List<String> excluded) {
        this.pattern = pattern;
        this.excluded = excluded;
        if (pattern.indexOf("*") == -1 && pattern.indexOf("?") == -1) {
            this.initNoStar();
        } else if (pattern.indexOf("**") != -1) {
            this.recurse();
        } else {
            this.initWithSimpleStar();
        }
        Collections.sort(this.result);
    }

    private void recurse() {
        Matcher2 m = predirPath.matcher(this.pattern);
        boolean ok = m.find();
        if (!ok) {
            throw new IllegalArgumentException();
        }
        File parent = m.group(1) == null ? new File(".") : new File(m.group(1));
        this.initWithDoubleStar(parent);
    }

    private void initNoStar() {
        File f = new File(this.pattern);
        if (f.isDirectory()) {
            this.addSimpleDirectory(f);
        } else if (f.isFile()) {
            this.addResultFile(f);
        }
    }

    private void addResultFile(File f) {
        String path = FileGroup.getNormalizedPath(f);
        for (String x : this.excluded) {
            if (!path.matches(FileGroup.toRegexp(x))) continue;
            return;
        }
        this.result.add(f);
    }

    private void addSimpleDirectory(File dir) {
        if (GlobalConfig.getInstance().boolValue(GlobalConfigKey.WORD)) {
            this.addSimpleDirectory(dir, "(?i)^.*_extr\\d+\\.txt$");
        } else {
            this.addSimpleDirectory(dir, CliOptions.getPattern());
        }
    }

    private void addSimpleDirectory(File dir, String pattern) {
        if (!dir.isDirectory()) {
            throw new IllegalArgumentException("dir=" + String.valueOf(dir));
        }
        if (dir.listFiles() != null) {
            for (File f : dir.listFiles()) {
                if (!f.getName().matches(pattern)) continue;
                this.addResultFile(f);
            }
        }
    }

    private static String getNormalizedPath(File f) {
        return f.getPath().replace('\\', '/');
    }

    private void initWithSimpleStar() {
        assert (this.pattern.indexOf("**") == -1);
        Matcher2 m = noStarInDirectory.matcher(this.pattern);
        if (m.find()) {
            File dir = new File(".");
            if (m.group(1) != null) {
                String dirPart = m.group(1);
                dir = new File(dirPart);
            }
            String filesPart = m.group(2);
            this.addSimpleDirectory(dir, FileGroup.toRegexp(filesPart));
        } else {
            this.recurse();
        }
    }

    private void initWithDoubleStar(File currentDir) {
        if (currentDir.listFiles() != null) {
            for (File f : currentDir.listFiles()) {
                String path;
                if (f.isDirectory()) {
                    this.initWithDoubleStar(f);
                    continue;
                }
                if (!f.isFile() || !(path = FileGroup.getNormalizedPath(f)).matches(FileGroup.toRegexp(this.pattern))) continue;
                this.addResultFile(f);
            }
        }
    }

    public List<File> getFiles() {
        return Collections.unmodifiableList(this.result);
    }

    public static String toRegexp(String pattern) {
        pattern = ((String)pattern).replace("\\", "/");
        pattern = ((String)pattern).replace(".", "\\.");
        pattern = ((String)pattern).replace("?", "[^/]");
        pattern = ((String)pattern).replace("/**/", "(/|/.{0,}/)");
        pattern = ((String)pattern).replace("**", ".{0,}");
        pattern = ((String)pattern).replace("*", "[^/]{0,}");
        pattern = "(?i)^(\\./)?" + (String)pattern + "$";
        return pattern;
    }
}

