/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.golem;

import java.util.Collections;
import java.util.EnumMap;
import java.util.Map;
import net.sourceforge.plantuml.golem.TileArea;
import net.sourceforge.plantuml.golem.TileGeometry;
import net.sourceforge.plantuml.klimt.UTranslate;
import net.sourceforge.plantuml.klimt.color.HColors;
import net.sourceforge.plantuml.klimt.creole.Display;
import net.sourceforge.plantuml.klimt.drawing.UGraphic;
import net.sourceforge.plantuml.klimt.font.FontConfiguration;
import net.sourceforge.plantuml.klimt.font.StringBounder;
import net.sourceforge.plantuml.klimt.font.UFont;
import net.sourceforge.plantuml.klimt.font.UFontFactory;
import net.sourceforge.plantuml.klimt.geom.HorizontalAlignment;
import net.sourceforge.plantuml.klimt.geom.XDimension2D;
import net.sourceforge.plantuml.klimt.shape.AbstractTextBlock;
import net.sourceforge.plantuml.klimt.shape.TextBlock;
import net.sourceforge.plantuml.klimt.shape.UEllipse;
import net.sourceforge.plantuml.klimt.shape.URectangle;
import net.sourceforge.plantuml.klimt.sprite.SpriteContainerEmpty;

public class Tile
extends AbstractTextBlock
implements TextBlock {
    private static double SIZE = 40.0;
    private final int num;
    private final UFont numberFont = UFontFactory.monospaced(11);
    private final FontConfiguration fc = FontConfiguration.blackBlueTrue(this.numberFont);
    private final Map<TileGeometry, TileArea> geometries;

    Tile(int num) {
        this.num = num;
        EnumMap<TileGeometry, TileArea> tmp = new EnumMap<TileGeometry, TileArea>(TileGeometry.class);
        for (TileGeometry g : TileGeometry.values()) {
            tmp.put(g, new TileArea(this, g));
        }
        this.geometries = Collections.unmodifiableMap(tmp);
    }

    public TileArea getArea(TileGeometry geometry) {
        return this.geometries.get((Object)geometry);
    }

    @Override
    public void drawU(UGraphic ug) {
        ug = ug.apply(HColors.BLACK);
        TextBlock n = Display.create("" + this.num).create(this.fc, HorizontalAlignment.LEFT, new SpriteContainerEmpty());
        XDimension2D dimNum = n.calculateDimension(ug.getStringBounder());
        XDimension2D dimTotal = this.calculateDimension(ug.getStringBounder());
        double diffx = dimTotal.getWidth() - dimNum.getWidth();
        double diffy = dimTotal.getHeight() - dimNum.getHeight();
        double radius = Math.max(dimNum.getWidth(), dimNum.getHeight());
        double diffx2 = dimTotal.getWidth() - radius;
        double diffy2 = dimTotal.getHeight() - radius;
        n.drawU(ug.apply(new UTranslate(diffx / 2.0, diffy / 2.0)));
        ug.draw(URectangle.build(SIZE, SIZE));
        ug.apply(new UTranslate(diffx2 / 2.0, diffy2 / 2.0)).draw(UEllipse.build(radius, radius));
    }

    @Override
    public XDimension2D calculateDimension(StringBounder stringBounder) {
        return new XDimension2D(SIZE, SIZE);
    }
}

