/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.klimt.awt;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Base64;
import javax.imageio.ImageIO;
import net.sourceforge.plantuml.klimt.awt.PortableImage;

class PortableImageAwt
implements PortableImage {
    private final BufferedImage image;

    public PortableImageAwt(int width, int height, int imageType) {
        this.image = new BufferedImage(width, height, imageType);
    }

    public PortableImageAwt(BufferedImage image) {
        this.image = image;
    }

    @Override
    public int getWidth() {
        return this.image.getWidth();
    }

    @Override
    public int getHeight() {
        return this.image.getHeight();
    }

    @Override
    public int getRGB(int x, int y) {
        return this.image.getRGB(x, y);
    }

    @Override
    public void setRGB(int x, int y, int rgb) {
        this.image.setRGB(x, y, rgb);
    }

    public int getType() {
        return this.image.getType();
    }

    @Override
    public BufferedImage getBufferedImage() {
        return this.image;
    }

    @Override
    public PortableImageAwt getSubimage(int x, int y, int width, int height) {
        return new PortableImageAwt(this.image.getSubimage(x, y, width, height));
    }

    @Override
    public Graphics2D createGraphics() {
        return this.image.createGraphics();
    }

    @Override
    public Graphics getGraphics() {
        return this.image.getGraphics();
    }

    @Override
    public int getTransparency() {
        return this.image.getTransparency();
    }

    @Override
    public String toPngDataUrl() {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)this.image, "PNG", baos);
            byte[] bytes = baos.toByteArray();
            String base64 = Base64.getEncoder().encodeToString(bytes);
            return "data:image/png;base64," + base64;
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to encode image as PNG", e);
        }
    }

    public int[] getPixels() {
        int w = this.image.getWidth();
        int h = this.image.getHeight();
        return this.image.getRGB(0, 0, w, h, null, 0, w);
    }

    @Override
    public PortableImageAwt scale(double scaleFactor, int interpolationType) {
        int w = (int)Math.round((double)this.image.getWidth() * scaleFactor);
        int h = (int)Math.round((double)this.image.getHeight() * scaleFactor);
        BufferedImage scaled = new BufferedImage(w, h, this.image.getType());
        AffineTransform at = new AffineTransform();
        at.scale(scaleFactor, scaleFactor);
        AffineTransformOp scaleOp = new AffineTransformOp(at, interpolationType);
        return new PortableImageAwt(scaleOp.filter(this.image, scaled));
    }
}

