/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.klimt.color;

import java.util.Collection;
import java.util.Collections;
import net.sourceforge.plantuml.klimt.awt.XColor;
import net.sourceforge.plantuml.klimt.color.ColorTrieNode;
import net.sourceforge.plantuml.klimt.color.HColor;
import net.sourceforge.plantuml.klimt.color.HColorAutomagic;
import net.sourceforge.plantuml.klimt.color.HColorScheme;
import net.sourceforge.plantuml.klimt.color.HColors;
import net.sourceforge.plantuml.klimt.color.NoSuchColorException;

public class HColorSet {
    private static final HColorSet singleton = new HColorSet();

    public static HColorSet instance() {
        return singleton;
    }

    public Collection<String> names() {
        return Collections.unmodifiableCollection(ColorTrieNode.NAMES);
    }

    private HColorSet() {
    }

    public HColor getColorOrWhite(String s) {
        HColor result = this.parseColor(s);
        if (result == null) {
            return HColors.WHITE;
        }
        return result;
    }

    public HColor getColor(String s) throws NoSuchColorException {
        HColor result = this.parseColor(s);
        if (result == null) {
            throw new NoSuchColorException();
        }
        return result;
    }

    private HColor parseColor(String s) {
        String[] colors;
        if (s.startsWith("#")) {
            s = s.substring(1);
        }
        if (s.equalsIgnoreCase("transparent") || s.equalsIgnoreCase("background")) {
            return HColors.none();
        }
        if (s.equalsIgnoreCase("automatic")) {
            return new HColorAutomagic();
        }
        if (s.equalsIgnoreCase("transparent")) {
            return HColors.simple(new XColor(0, 0, 0, 0));
        }
        XColor result = this.parseSimpleColor(s);
        if (result != null) {
            return HColors.simple(result);
        }
        if (s.startsWith("?") && ((colors = s.substring(1).split(":")).length == 2 || colors.length == 3)) {
            XColor col0 = this.parseSimpleColor(colors[0]);
            XColor col1 = this.parseSimpleColor(colors[1]);
            if (colors.length == 2 && col0 != null && col1 != null) {
                return new HColorScheme(HColors.simple(col0), HColors.simple(col1), null);
            }
            XColor col2 = this.parseSimpleColor(colors[2]);
            if (col2 != null) {
                return new HColorScheme(HColors.simple(col0), HColors.simple(col1), HColors.simple(col2));
            }
        }
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c != '-' && c != '\\' && c != '|' && c != '/') continue;
            XColor col0 = this.parseSimpleColor(s.substring(0, i));
            XColor col1 = this.parseSimpleColor(s.substring(i + 1));
            if (col0 == null || col1 == null) continue;
            return HColors.gradient(HColors.simple(col0), HColors.simple(col1), c);
        }
        return null;
    }

    private XColor parseSimpleColor(String s) {
        int len;
        if (s.startsWith("#")) {
            s = s.substring(1);
        }
        if ((len = s.length()) == 1) {
            int d = HColorSet.hexNibble(s.charAt(0));
            if (d >= 0) {
                int v = d << 4 | d;
                int rgb = v << 16 | v << 8 | v;
                return XColor.from(rgb);
            }
        } else if (len == 3) {
            int r = HColorSet.hexNibble(s.charAt(0));
            int g = HColorSet.hexNibble(s.charAt(1));
            int b = HColorSet.hexNibble(s.charAt(2));
            if (r >= 0 && g >= 0 && b >= 0) {
                int rr = r << 4 | r;
                int gg = g << 4 | g;
                int bb = b << 4 | b;
                return new XColor(rr, gg, bb);
            }
        } else if (len == 6) {
            int rgb = HColorSet.parseHex24(s, 0);
            if (rgb >= 0) {
                return XColor.from(0xFF000000 | rgb);
            }
        } else if (len == 8) {
            int r = HColorSet.parseHexByte(s, 0);
            int g = HColorSet.parseHexByte(s, 2);
            int b = HColorSet.parseHexByte(s, 4);
            int a = HColorSet.parseHexByte(s, 6);
            if (r >= 0 && g >= 0 && b >= 0 && a >= 0) {
                return new XColor(r, g, b, a);
            }
        }
        return ColorTrieNode.INSTANCE.getColor(s);
    }

    private static int hexNibble(char c) {
        if (c >= '0' && c <= '9') {
            return c - 48;
        }
        if (c >= 'a' && c <= 'f') {
            return c - 97 + 10;
        }
        if (c >= 'A' && c <= 'F') {
            return c - 65 + 10;
        }
        return -1;
    }

    private static int parseHexByte(CharSequence s, int off) {
        int lo;
        int hi = HColorSet.hexNibble(s.charAt(off));
        return (hi | (lo = HColorSet.hexNibble(s.charAt(off + 1)))) < 0 ? -1 : hi << 4 | lo;
    }

    private static int parseHex24(CharSequence s, int off) {
        int b;
        int g;
        int r = HColorSet.parseHexByte(s, off);
        return (r | (g = HColorSet.parseHexByte(s, off + 2)) | (b = HColorSet.parseHexByte(s, off + 4))) < 0 ? -1 : r << 16 | g << 8 | b;
    }
}

