/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.klimt.drawing.svg;

import java.util.ArrayList;
import java.util.List;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.klimt.ClipContainer;
import net.sourceforge.plantuml.klimt.UClip;
import net.sourceforge.plantuml.klimt.UParam;
import net.sourceforge.plantuml.klimt.color.ColorMapper;
import net.sourceforge.plantuml.klimt.color.HColor;
import net.sourceforge.plantuml.klimt.color.HColorGradient;
import net.sourceforge.plantuml.klimt.drawing.UDriver;
import net.sourceforge.plantuml.klimt.drawing.svg.SvgGraphics;
import net.sourceforge.plantuml.klimt.font.FontConfiguration;
import net.sourceforge.plantuml.klimt.font.FontStyle;
import net.sourceforge.plantuml.klimt.font.StringBounder;
import net.sourceforge.plantuml.klimt.font.UFont;
import net.sourceforge.plantuml.klimt.font.UFontContext;
import net.sourceforge.plantuml.klimt.geom.XDimension2D;
import net.sourceforge.plantuml.klimt.shape.UText;

public class DriverTextSvg
implements UDriver<UText, SvgGraphics> {
    private final StringBounder stringBounder;
    private final ClipContainer clipContainer;

    public DriverTextSvg(StringBounder stringBounder, ClipContainer clipContainer) {
        if (stringBounder == null) {
            System.err.println("stringBounder=" + String.valueOf(stringBounder));
        }
        this.stringBounder = stringBounder;
        this.clipContainer = clipContainer;
    }

    @Override
    public void draw(UText shape, double x, double y, ColorMapper mapper, UParam param, SvgGraphics svg) {
        String text;
        UClip clip = this.clipContainer.getClip();
        if (clip != null && !clip.isInside(x, y)) {
            return;
        }
        FontConfiguration fontConfiguration = shape.getFontConfiguration();
        if (fontConfiguration.getColor().isTransparent()) {
            return;
        }
        UFont font = fontConfiguration.getFont();
        String fontWeight = null;
        if (fontConfiguration.containsStyle(FontStyle.BOLD) || font.isBold()) {
            fontWeight = "bold";
        }
        String fontStyle = null;
        if (fontConfiguration.containsStyle(FontStyle.ITALIC) || font.isItalic()) {
            fontStyle = "italic";
        }
        if ((text = shape.getText()).matches("^\\s*$")) {
            text = text.replace(' ', '\u00a0');
        }
        if (text.startsWith(" ")) {
            double space = this.stringBounder.calculateDimension(font, " ").getWidth();
            while (text.startsWith(" ")) {
                x += space;
                text = text.substring(1);
            }
        }
        text = StringUtils.trin(text);
        XDimension2D dim = this.stringBounder.calculateDimension(font, text);
        double width = dim.getWidth();
        double height = dim.getHeight();
        ExtraLines extraLines = new ExtraLines();
        StringBuilder decorations = new StringBuilder();
        if (fontConfiguration.containsStyle(FontStyle.UNDERLINE) && fontConfiguration.getUnderlineStroke().getThickness() > 0.0) {
            if (fontConfiguration.getExtendedColor() == null) {
                decorations.append("underline ");
            } else {
                extraLines.add(fontConfiguration.getExtendedColor(), font.getSize2D() / 14.0);
            }
        }
        if (fontConfiguration.containsStyle(FontStyle.STRIKE)) {
            if (fontConfiguration.getExtendedColor() == null) {
                decorations.append("line-through ");
            } else {
                extraLines.add(fontConfiguration.getExtendedColor(), -font.getSize2D() / 4.0);
            }
        }
        if (fontConfiguration.containsStyle(FontStyle.WAVE)) {
            decorations.append("wavy underline ");
        }
        String textDecoration = decorations.length() > 0 ? decorations.toString().trim() : null;
        String backColor = null;
        if (fontConfiguration.containsStyle(FontStyle.BACKCOLOR)) {
            HColor back = fontConfiguration.getExtendedColor();
            if (back instanceof HColorGradient) {
                HColorGradient gr = (HColorGradient)back;
                String id = svg.createSvgGradient(gr.getColor1().toRGB(mapper), gr.getColor2().toRGB(mapper), gr.getPolicy());
                svg.setFillColor("url(#" + id + ")");
                svg.setStrokeColor(null);
                double deltaPatch = 2.0;
                svg.svgRectangle(x, y - height + 2.0, width, height, 0.0, 0.0, 0.0);
            } else {
                backColor = back.toRGB(mapper);
            }
        }
        HColor textColor = fontConfiguration.getColor();
        svg.setFillColor(textColor.toSvg(mapper));
        svg.text(text, x, y, font.getFamily(text, UFontContext.SVG), font.getSize(), fontWeight, fontStyle, textDecoration, width, fontConfiguration.getAttributes(), backColor, shape.getOrientation());
        extraLines.drawAll(x, y, width, font, mapper, svg);
    }

    static class ExtraLines {
        private final List<HColor> colors = new ArrayList<HColor>();
        private final List<Double> deltaYs = new ArrayList<Double>();

        ExtraLines() {
        }

        void add(HColor color, double deltaY) {
            this.colors.add(color);
            this.deltaYs.add(deltaY);
        }

        void drawAll(double x, double y, double width, UFont font, ColorMapper mapper, SvgGraphics svg) {
            for (int i = 0; i < this.colors.size(); ++i) {
                svg.setStrokeColor(this.colors.get(i).toSvg(mapper));
                svg.setStrokeWidth(font.getSize2D() / 28.0, null);
                svg.svgLine(x, y + this.deltaYs.get(i), x + width, y + this.deltaYs.get(i), 0.0);
            }
        }
    }
}

