/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.klimt.shape;

import java.util.List;
import net.atmp.PixelImage;
import net.sourceforge.plantuml.klimt.AffineTransformType;
import net.sourceforge.plantuml.klimt.UStroke;
import net.sourceforge.plantuml.klimt.UTranslate;
import net.sourceforge.plantuml.klimt.awt.PortableImage;
import net.sourceforge.plantuml.klimt.color.HColor;
import net.sourceforge.plantuml.klimt.color.HColors;
import net.sourceforge.plantuml.klimt.creole.CreoleMode;
import net.sourceforge.plantuml.klimt.creole.Display;
import net.sourceforge.plantuml.klimt.drawing.UGraphic;
import net.sourceforge.plantuml.klimt.font.FontConfiguration;
import net.sourceforge.plantuml.klimt.font.StringBounder;
import net.sourceforge.plantuml.klimt.font.UFontFactory;
import net.sourceforge.plantuml.klimt.geom.GraphicPosition;
import net.sourceforge.plantuml.klimt.geom.HorizontalAlignment;
import net.sourceforge.plantuml.klimt.geom.XDimension2D;
import net.sourceforge.plantuml.klimt.shape.AbstractTextBlock;
import net.sourceforge.plantuml.klimt.shape.TextBlock;
import net.sourceforge.plantuml.klimt.shape.TextBlockRaw;
import net.sourceforge.plantuml.klimt.shape.UImage;
import net.sourceforge.plantuml.klimt.sprite.SpriteContainerEmpty;
import net.sourceforge.plantuml.svek.IEntityImage;
import net.sourceforge.plantuml.svek.Margins;
import net.sourceforge.plantuml.svek.ShapeType;

public class GraphicStrings
extends AbstractTextBlock
implements IEntityImage {
    private final double margin = 5.0;
    private final HColor background;
    private static final HColor hyperlinkColor = HColors.BLUE;
    private static final HColor TEXTCOLOR = HColors.BLACK.withDark(HColors.WHITE);
    private static final UStroke useUnderlineForHyperlink = UStroke.simple();
    private final List<String> strings;
    private final PortableImage image;
    private final double imagePadding = 30.0;
    private final GraphicPosition position;
    private final FontConfiguration fontConfiguration;
    private final CreoleMode mode;
    private final boolean isCrash;

    public static IEntityImage createForError(List<String> strings, boolean useRed) {
        return new GraphicStrings(strings, GraphicStrings.sansSerif14(GraphicStrings.getForeColor(useRed)).bold(), GraphicStrings.getBackColor(useRed), null, null, CreoleMode.NO_CREOLE, true);
    }

    private static HColor getForeColor(boolean useRed) {
        if (useRed) {
            return HColors.BLACK;
        }
        return HColors.MY_GREEN;
    }

    private static HColor getBackColor(boolean useRed) {
        if (useRed) {
            return HColors.RED_LIGHT;
        }
        return HColors.BLACK;
    }

    public static TextBlock createGreenOnBlackMonospaced(List<String> strings) {
        return new GraphicStrings(strings, GraphicStrings.monospaced14(HColors.GREEN), HColors.BLACK, null, null, CreoleMode.SIMPLE_LINE, false);
    }

    public static TextBlock createBlackOnWhite(List<String> strings) {
        return new GraphicStrings(strings, GraphicStrings.sansSerif12(TEXTCOLOR), HColors.WHITE, null, null, CreoleMode.FULL, false);
    }

    public static TextBlock createBlackOnWhiteMonospaced(List<String> strings) {
        return new GraphicStrings(strings, GraphicStrings.monospaced14(TEXTCOLOR), HColors.WHITE, null, null, CreoleMode.FULL, false);
    }

    public static TextBlock createBlackOnWhite(List<String> strings, PortableImage image, GraphicPosition position) {
        return new GraphicStrings(strings, GraphicStrings.sansSerif12(TEXTCOLOR), HColors.WHITE, image, position, CreoleMode.FULL_BUT_UNDERSCORE, false);
    }

    public static FontConfiguration sansSerif12(HColor color) {
        return FontConfiguration.create(UFontFactory.sansSerif(12), color, hyperlinkColor, useUnderlineForHyperlink);
    }

    public static FontConfiguration sansSerif14(HColor color) {
        return FontConfiguration.create(UFontFactory.sansSerif(14), color, hyperlinkColor, useUnderlineForHyperlink);
    }

    private static FontConfiguration monospaced14(HColor color) {
        return FontConfiguration.create(UFontFactory.monospaced(14), color, hyperlinkColor, useUnderlineForHyperlink);
    }

    private GraphicStrings(List<String> strings, FontConfiguration fontConfiguration, HColor background, PortableImage image, GraphicPosition position, CreoleMode mode, boolean isCrash) {
        this.strings = strings;
        this.background = background;
        this.image = image;
        this.position = position;
        this.mode = mode;
        this.fontConfiguration = fontConfiguration;
        this.isCrash = isCrash;
    }

    private TextBlock getTextBlock() {
        Display display = Display.create(this.strings);
        if (this.mode == CreoleMode.NO_CREOLE) {
            return new TextBlockRaw(this.strings, this.fontConfiguration);
        }
        return display.create7(this.fontConfiguration, HorizontalAlignment.LEFT, new SpriteContainerEmpty(), this.mode);
    }

    @Override
    public void drawU(UGraphic ug) {
        ug = ug.apply(new UTranslate(5.0, 5.0));
        XDimension2D size = this.calculateDimensionInternal(ug.getStringBounder());
        this.getTextBlock().drawU(ug.apply(this.fontConfiguration.getColor()));
        if (this.image != null) {
            if (this.position == GraphicPosition.BOTTOM) {
                ug.apply(new UTranslate((size.getWidth() - (double)this.image.getWidth()) / 2.0, size.getHeight() - (double)this.image.getHeight())).draw(new UImage(new PixelImage(this.image, AffineTransformType.TYPE_BILINEAR)));
            } else if (this.position == GraphicPosition.BACKGROUND_CORNER_BOTTOM_RIGHT) {
                ug.apply(new UTranslate(size.getWidth() - (double)this.image.getWidth(), size.getHeight() - (double)this.image.getHeight())).draw(new UImage(new PixelImage(this.image, AffineTransformType.TYPE_BILINEAR)));
            } else if (this.position == GraphicPosition.BACKGROUND_CORNER_TOP_RIGHT) {
                ug.apply(new UTranslate(size.getWidth() - (double)this.image.getWidth() - 1.0, 1.0)).draw(new UImage(new PixelImage(this.image, AffineTransformType.TYPE_BILINEAR)));
            }
        }
    }

    @Override
    public XDimension2D calculateDimension(StringBounder stringBounder) {
        return this.calculateDimensionInternal(stringBounder).delta(10.0);
    }

    private XDimension2D calculateDimensionInternal(StringBounder stringBounder) {
        XDimension2D dim = this.getTextBlock().calculateDimension(stringBounder);
        if (this.image != null) {
            if (this.position == GraphicPosition.BOTTOM) {
                dim = new XDimension2D(dim.getWidth(), dim.getHeight() + (double)this.image.getHeight());
            } else if (this.position == GraphicPosition.BACKGROUND_CORNER_BOTTOM_RIGHT) {
                dim = new XDimension2D(dim.getWidth() + 30.0 + (double)this.image.getWidth(), dim.getHeight());
            } else if (this.position == GraphicPosition.BACKGROUND_CORNER_TOP_RIGHT) {
                dim = new XDimension2D(dim.getWidth() + 30.0 + (double)this.image.getWidth(), dim.getHeight());
            }
        }
        return dim;
    }

    @Override
    public ShapeType getShapeType() {
        return ShapeType.RECTANGLE;
    }

    @Override
    public HColor getBackcolor() {
        return this.background;
    }

    @Override
    public Margins getShield(StringBounder stringBounder) {
        return Margins.NONE;
    }

    @Override
    public boolean isHidden() {
        return false;
    }

    @Override
    public double getOverscanX(StringBounder stringBounder) {
        return 0.0;
    }

    @Override
    public boolean isCrash() {
        return this.isCrash;
    }
}

