/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.klimt.sprite;

import java.util.Objects;
import net.sourceforge.plantuml.klimt.awt.XColor;
import net.sourceforge.plantuml.klimt.color.HColorSimple;
import net.sourceforge.plantuml.klimt.color.HColors;

public class ColorPalette4096 {
    private static final String colorValue = ".,$%&*+-:;<=>?@^_~GHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz";

    public String getStringFor(XColor dest) {
        return this.getStringFor((HColorSimple)HColors.simple(dest));
    }

    private String getStringFor(HColorSimple dest) {
        int result = 0;
        int resultDist = Integer.MAX_VALUE;
        for (int i = 0; i < 4096; ++i) {
            int dist = dest.distanceTo(this.getHtmlColorSimpleFor(i));
            if (dist >= resultDist) continue;
            result = i;
            resultDist = dist;
        }
        return this.encodeInt(result);
    }

    protected String encodeInt(int result) {
        int v2 = result % 64;
        int v1 = result / 64;
        assert (v1 >= 0 && v1 <= 63 && v2 >= 0 && v2 <= 63);
        return "" + colorValue.charAt(v1) + colorValue.charAt(v2);
    }

    private HColorSimple getHtmlColorSimpleFor(int s) {
        XColor color = Objects.requireNonNull(this.getColorFor(s));
        return (HColorSimple)HColors.simple(color);
    }

    protected XColor getColorFor(String s) {
        s = s.replace('!', '.');
        if ((s = s.replace('#', ',')).length() != 2) {
            throw new IllegalArgumentException();
        }
        int v1 = colorValue.indexOf(s.charAt(0));
        if (v1 == -1) {
            return null;
        }
        int v2 = colorValue.indexOf(s.charAt(1));
        if (v2 == -1) {
            return null;
        }
        int code = v1 * 64 + v2;
        return this.getColorFor(code);
    }

    protected XColor getColorFor(int code) {
        int blue = code % 16;
        int green = code / 16 % 16;
        int red = code / 256 % 16;
        return new XColor(this.dup(red), this.dup(green), this.dup(blue));
    }

    private int dup(int v) {
        assert (v >= 0 && v <= 15);
        return v * 16 + v;
    }
}

