/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.math;

import java.io.IOException;
import java.io.OutputStream;
import net.sourceforge.plantuml.AbstractPSystem;
import net.sourceforge.plantuml.FileFormatOption;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.core.DiagramDescription;
import net.sourceforge.plantuml.core.ImageData;
import net.sourceforge.plantuml.core.UmlSource;
import net.sourceforge.plantuml.klimt.awt.XColor;
import net.sourceforge.plantuml.klimt.color.ColorMapper;
import net.sourceforge.plantuml.klimt.color.HColor;
import net.sourceforge.plantuml.klimt.color.HColorSet;
import net.sourceforge.plantuml.log.Logme;
import net.sourceforge.plantuml.math.ScientificEquationSafe;
import net.sourceforge.plantuml.preproc.PreprocessingArtifact;

public class PSystemLatex
extends AbstractPSystem {
    private String latex = "";
    private float scale = 1.0f;
    private XColor color = XColor.BLACK;
    private XColor backColor = XColor.WHITE;

    public PSystemLatex(UmlSource source, PreprocessingArtifact preprocessing) {
        super(source, preprocessing);
    }

    @Override
    public DiagramDescription getDescription() {
        return new DiagramDescription("(Latex)");
    }

    @Override
    protected final ImageData exportDiagramNow(OutputStream os, int num, FileFormatOption fileFormat) throws IOException {
        ScientificEquationSafe asciiMath = ScientificEquationSafe.fromLatex(this.latex);
        return asciiMath.export(os, fileFormat, this.scale, this.color, this.backColor);
    }

    public void doCommandLine(String line) {
        String lineLower = StringUtils.trin(StringUtils.goLowerCase(line));
        String colorParam = "color ";
        String backParam = "backgroundcolor ";
        if (lineLower.startsWith("color ")) {
            XColor col3 = this.getColor(line.substring("color ".length()));
            if (col3 != null) {
                this.color = col3;
            }
        } else if (lineLower.startsWith("backgroundcolor ")) {
            XColor col3 = this.getColor(line.substring("backgroundcolor ".length()));
            if (col3 != null) {
                this.backColor = col3;
            }
        } else if (lineLower.startsWith("scale ")) {
            String value = line.substring("scale ".length());
            try {
                float scale1 = Float.parseFloat(value);
                if (scale1 > 0.0f) {
                    this.scale = scale1;
                }
            }
            catch (Exception e) {
                Logme.error(e);
            }
        } else if (lineLower.startsWith("dpi ")) {
            String value = line.substring("dpi ".length());
            try {
                float dpi1 = Float.parseFloat(value);
                if (dpi1 > 0.0f) {
                    this.scale = dpi1 / 96.0f;
                }
            }
            catch (Exception e) {
                Logme.error(e);
            }
        } else {
            this.latex = line;
        }
    }

    private XColor getColor(String col) {
        HColor col2 = col == null ? null : HColorSet.instance().getColorOrWhite(col);
        XColor col3 = col2.toColor(ColorMapper.IDENTITY);
        return col3;
    }
}

