/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.packetdiag;

import java.util.Map;
import java.util.Optional;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.ParserPass;
import net.sourceforge.plantuml.command.SingleLineCommand2;
import net.sourceforge.plantuml.klimt.color.NoSuchColorException;
import net.sourceforge.plantuml.nwdiag.NwDiagram;
import net.sourceforge.plantuml.packetdiag.PacketDiagram;
import net.sourceforge.plantuml.regex.IRegex;
import net.sourceforge.plantuml.regex.RegexConcat;
import net.sourceforge.plantuml.regex.RegexLeaf;
import net.sourceforge.plantuml.regex.RegexOr;
import net.sourceforge.plantuml.regex.RegexResult;
import net.sourceforge.plantuml.utils.LineLocation;

public class CommandNumRange
extends SingleLineCommand2<PacketDiagram> {
    public CommandNumRange() {
        super(CommandNumRange.getRegexConcat());
    }

    static IRegex getRegexConcat() {
        return RegexConcat.build(CommandNumRange.class.getName(), RegexLeaf.start(), RegexLeaf.spaceZeroOrMore(), new RegexOr(new RegexLeaf(1, "RANGE_UNIT", "(\\d{1,7})(?::)?"), new RegexLeaf(2, "RANGE", "(\\d{1,7})(?:-(\\d{1,7}))(?::)?"), new RegexLeaf("\\*")), new RegexLeaf(1, "DESC", "\\s+(.*?)"), new RegexLeaf(1, "ATTRIBUTE", "(?:\\s*\\[(.*?)\\])?"), RegexLeaf.spaceZeroOrMore(), RegexLeaf.end());
    }

    private static Integer getIntAttribute(String name, Map<String, String> attr, Integer defaultValue) {
        return Optional.ofNullable(attr.get(name)).map(v -> {
            try {
                return Integer.parseInt(v);
            }
            catch (NumberFormatException ignore) {
                return defaultValue;
            }
        }).orElse(defaultValue);
    }

    private static int getLengthAttribute(Map<String, String> attr) {
        return CommandNumRange.getIntAttribute("len", attr, 1);
    }

    private static int getRotationAttribute(Map<String, String> attr) {
        return CommandNumRange.getIntAttribute("rotate", attr, 0);
    }

    private static int getHeightAttribute(Map<String, String> attr) {
        return CommandNumRange.getIntAttribute("height", attr, 1);
    }

    @Override
    protected CommandExecutionResult executeArg(PacketDiagram system, LineLocation location, RegexResult arg, ParserPass currentPass) throws NoSuchColorException {
        int end;
        int start;
        String r1 = arg.get("RANGE_UNIT", 0);
        String r2 = arg.get("RANGE", 0);
        String r3 = arg.get("RANGE", 1);
        String desc = arg.get("DESC", 0);
        Map<String, String> attr = NwDiagram.toSet(arg.get("ATTRIBUTE", 0));
        if (r1 != null) {
            try {
                start = Integer.parseInt(r1);
                end = start + CommandNumRange.getLengthAttribute(attr) - 1;
            }
            catch (NumberFormatException e) {
                return CommandExecutionResult.error("Invalid bit start " + r1, e);
            }
        } else if (r2 != null && r3 != null) {
            try {
                start = Integer.parseInt(r2);
                end = Integer.parseInt(r3);
            }
            catch (NumberFormatException e) {
                return CommandExecutionResult.error("Invalid bit range " + r2 + " and " + r3, e);
            }
        } else {
            start = system.getLastPacketEnd().map(v -> v + 1).orElse(0);
            end = start + CommandNumRange.getLengthAttribute(attr) - 1;
        }
        int height = CommandNumRange.getHeightAttribute(attr);
        PacketDiagram.PacketItem packetItem = PacketDiagram.PacketItem.ofRange(start, end, height, desc);
        packetItem.textRotation = CommandNumRange.getRotationAttribute(attr);
        system.addPacketItem(packetItem);
        return CommandExecutionResult.ok();
    }
}

