/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.png;

import java.awt.image.BufferedImage;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import net.sourceforge.plantuml.klimt.awt.PortableImage;
import net.sourceforge.plantuml.klimt.awt.PortableImageFactory;
import net.sourceforge.plantuml.klimt.color.ColorMapper;
import net.sourceforge.plantuml.png.PngIOMetadata;
import net.sourceforge.plantuml.png.quant.QuantUtils;
import net.sourceforge.plantuml.png.quant.Quantify555;
import net.sourceforge.plantuml.png.quant.QuantifyPacked28;
import net.sourceforge.plantuml.security.SFile;
import net.sourceforge.plantuml.security.SImageIO;
import net.sourceforge.plantuml.utils.Log;

public class PngIO {
    private static final String copyleft = "Generated by https://plantuml.com";

    public static void write(PortableImage image, ColorMapper mapper, SFile file, String metadata, int dpi) throws IOException {
        try (BufferedOutputStream os = file.createBufferedOutputStream();){
            PngIO.write(image, mapper, os, metadata, dpi);
        }
        Log.debug(() -> "File is " + String.valueOf(file));
        Log.debug(() -> "File size " + file.length());
        if (file.length() == 0L) {
            Log.error("File size is zero: " + String.valueOf(file));
            SImageIO.write(image, "png", file);
        }
    }

    public static void write(PortableImage image, ColorMapper mapper, OutputStream os, String metadata, int dpi) throws IOException {
        BufferedImage bufferedImage = QuantUtils.toBufferedARGBorRGB(image.getBufferedImage());
        if (bufferedImage != null) {
            int type = bufferedImage.getType();
            assert (type == 2 || type == 1 || type == 5 || type == 6);
            boolean hasAlpha = type == 2 || type == 6;
            Log.info(() -> "Trying to pack image. hasAlpha=" + hasAlpha);
            BufferedImage tmp = null;
            if (!hasAlpha) {
                long memBefore555 = PngIO.getUsedMemoryMB();
                long start555 = System.currentTimeMillis();
                tmp = Quantify555.packMeIfPossible(bufferedImage);
                long duration555 = System.currentTimeMillis() - start555;
                long memAfter555 = PngIO.getUsedMemoryMB();
                boolean success555 = tmp != null;
                Log.info(() -> "Quantify555: " + (success555 ? "SUCCESS" : "FAILED") + " in " + duration555 + " ms, memory " + memBefore555 + " -> " + memAfter555 + " MB (delta: " + (memAfter555 - memBefore555) + " MB)");
            }
            if (tmp == null) {
                long memBefore28 = PngIO.getUsedMemoryMB();
                long start28 = System.currentTimeMillis();
                tmp = QuantifyPacked28.packMeIfPossible(bufferedImage);
                long duration28 = System.currentTimeMillis() - start28;
                long memAfter28 = PngIO.getUsedMemoryMB();
                boolean success28 = tmp != null;
                Log.info(() -> "QuantifyPacked28: " + (success28 ? "SUCCESS" : "FAILED") + " in " + duration28 + " ms, memory " + memBefore28 + " -> " + memAfter28 + " MB (delta: " + (memAfter28 - memBefore28) + " MB)");
            }
            if (tmp != null) {
                image = PortableImageFactory.build(tmp);
            }
        }
        PngIOMetadata.writeWithMetadata(image.getBufferedImage(), os, metadata, dpi, null, 7);
    }

    public static long getUsedMemoryMB() {
        Runtime rt = Runtime.getRuntime();
        return (rt.totalMemory() - rt.freeMemory()) / 0x100000L;
    }
}

