/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.png.quant;

import java.awt.image.BufferedImage;
import java.awt.image.IndexColorModel;
import java.awt.image.WritableRaster;
import java.util.Arrays;
import net.sourceforge.plantuml.png.PngIO;
import net.sourceforge.plantuml.png.quant.Cube555;
import net.sourceforge.plantuml.utils.Log;

public final class Quantify555 {
    private static final int CUBE_COUNT_RGB555 = 32768;
    private static final int TRANSPARENT_CUBE = 32768;
    private static final int TOTAL_CUBE_SLOTS = 32769;
    private static final int MIN_CUBES_THRESHOLD = 32;

    public static BufferedImage packMeIfPossible(BufferedImage src) {
        int w = src.getWidth();
        int h = src.getHeight();
        int pixelCount = w * h;
        Log.info(() -> "Quantify555: starting, image " + w + "x" + h + " (" + pixelCount + " pixels), memory: " + PngIO.getUsedMemoryMB() + " MB");
        try {
            long startExtract = System.currentTimeMillis();
            long memBeforeExtract = PngIO.getUsedMemoryMB();
            int[] pixels = src.getRGB(0, 0, w, h, null, 0, w);
            long extractDuration = System.currentTimeMillis() - startExtract;
            long memAfterExtract = PngIO.getUsedMemoryMB();
            Log.info(() -> "Quantify555: pixel extraction in " + extractDuration + " ms, memory: " + memBeforeExtract + " -> " + memAfterExtract + " MB (delta: " + (memAfterExtract - memBeforeExtract) + " MB)");
            int nbCubes = 0;
            long startCubes = System.currentTimeMillis();
            long memBeforeCubes = PngIO.getUsedMemoryMB();
            Cube555[] cubes = new Cube555[32769];
            for (int argb : pixels) {
                int cubeIndex = Quantify555.getCubeIndex(argb);
                Cube555 cube = cubes[cubeIndex];
                if (cube == null) {
                    if (nbCubes++ > 255) {
                        int finalNbCubes = nbCubes;
                        Log.info(() -> "Quantify555: abort, too many colors (" + finalNbCubes + " cubes)");
                        return null;
                    }
                    cubes[cubeIndex] = cube = new Cube555(cubeIndex);
                }
                int sub = cubeIndex == 32768 ? 0 : Quantify555.subColorIndex512(argb);
                cube.increment(sub);
            }
            long cubesDuration = System.currentTimeMillis() - startCubes;
            long memAfterCubes = PngIO.getUsedMemoryMB();
            int finalNbCubes = nbCubes;
            Log.info(() -> "Quantify555: cube analysis in " + cubesDuration + " ms, found " + finalNbCubes + " cubes, memory: " + memBeforeCubes + " -> " + memAfterCubes + " MB (delta: " + (memAfterCubes - memBeforeCubes) + " MB)");
            if (nbCubes < 32) {
                Log.info(() -> "Quantify555: abort, not enough distinct colors (" + finalNbCubes + " < 32)");
                return null;
            }
            long startBuild = System.currentTimeMillis();
            long memBeforeBuild = PngIO.getUsedMemoryMB();
            BufferedImage result = Quantify555.buildIndexedImageFromCubes(src, cubes);
            long buildDuration = System.currentTimeMillis() - startBuild;
            long memAfterBuild = PngIO.getUsedMemoryMB();
            Log.info(() -> "Quantify555: indexed image built in " + buildDuration + " ms, memory: " + memBeforeBuild + " -> " + memAfterBuild + " MB (delta: " + (memAfterBuild - memBeforeBuild) + " MB)");
            return result;
        }
        catch (Throwable t) {
            Log.info(() -> "Quantify555: exception caught: " + t.getClass().getSimpleName() + " - " + t.getMessage());
            return null;
        }
    }

    public static boolean isTransparent(int argb) {
        return (argb >>> 24 & 0xFF) < 127;
    }

    private static BufferedImage buildIndexedImageFromCubes(BufferedImage src, Cube555[] cubes) {
        int w = src.getWidth();
        int h = src.getHeight();
        int[] cubeToPal = new int[32769];
        Arrays.fill(cubeToPal, -1);
        int[] palARGB = new int[256];
        int palSize = 0;
        for (Cube555 c : cubes) {
            if (c == null) continue;
            int sub = c.best();
            int argb = Quantify555.representativeARGB(c.rgb555, sub);
            cubeToPal[c.rgb555] = palSize;
            palARGB[palSize++] = argb;
        }
        if (palSize == 0) {
            throw new IllegalStateException();
        }
        IndexColorModel icm = Quantify555.buildICM(palARGB, palSize);
        BufferedImage dst = new BufferedImage(w, h, 13, icm);
        WritableRaster raster = dst.getRaster();
        int[] line = new int[w];
        for (int y = 0; y < h; ++y) {
            src.getRGB(0, y, w, 1, line, 0, w);
            for (int x = 0; x < w; ++x) {
                int argb = line[x];
                int cubeIndex = Quantify555.getCubeIndex(argb);
                int p = cubeToPal[cubeIndex];
                if (p < 0) {
                    throw new IllegalStateException();
                }
                raster.setSample(x, y, 0, p);
            }
        }
        return dst;
    }

    public static IndexColorModel buildICM(int[] palARGB, int palSize) {
        byte[] r = new byte[palSize];
        byte[] g = new byte[palSize];
        byte[] b = new byte[palSize];
        byte[] a = new byte[palSize];
        for (int i = 0; i < palSize; ++i) {
            int argb = palARGB[i];
            a[i] = (byte)(argb >>> 24 & 0xFF);
            r[i] = (byte)(argb >>> 16 & 0xFF);
            g[i] = (byte)(argb >>> 8 & 0xFF);
            b[i] = (byte)(argb & 0xFF);
        }
        return new IndexColorModel(8, palSize, r, g, b, a);
    }

    private static int representativeARGB(int cubeIndex, int sub512) {
        if (cubeIndex == 32768) {
            return 0;
        }
        int r5 = cubeIndex >>> 10 & 0x1F;
        int g5 = cubeIndex >>> 5 & 0x1F;
        int b5 = cubeIndex & 0x1F;
        int rLow3 = sub512 >>> 6 & 7;
        int gLow3 = sub512 >>> 3 & 7;
        int bLow3 = sub512 & 7;
        int r8 = r5 << 3 | rLow3;
        int g8 = g5 << 3 | gLow3;
        int b8 = b5 << 3 | bLow3;
        return 0xFF000000 | r8 << 16 | g8 << 8 | b8;
    }

    private static int getCubeIndex(int argb) {
        if (Quantify555.isTransparent(argb)) {
            return 32768;
        }
        int r5 = argb >>> 19 & 0x1F;
        int g5 = argb >>> 11 & 0x1F;
        int b5 = argb >>> 3 & 0x1F;
        return r5 << 10 | g5 << 5 | b5;
    }

    private static int subColorIndex512(int argb) {
        int r8 = argb >>> 16 & 0xFF;
        int g8 = argb >>> 8 & 0xFF;
        int b8 = argb & 0xFF;
        int rLow3 = r8 & 7;
        int gLow3 = g8 & 7;
        int bLow3 = b8 & 7;
        return rLow3 << 6 | gLow3 << 3 | bLow3;
    }
}

