/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.png.quant;

import java.awt.image.BufferedImage;
import net.sourceforge.plantuml.png.PngIO;
import net.sourceforge.plantuml.png.quant.QuantUtils;
import net.sourceforge.plantuml.utils.Log;

public final class QuantifyPacked28 {
    public static BufferedImage packMeIfPossible(BufferedImage src) {
        int type = src.getType();
        assert (type == 2 || type == 1 || type == 5 || type == 6);
        int w = src.getWidth();
        int h = src.getHeight();
        int pixelCount = w * h;
        Log.info(() -> "QuantifyPacked28: starting, image " + w + "x" + h + " (" + pixelCount + " pixels), type=" + type + ", memory: " + PngIO.getUsedMemoryMB() + " MB");
        try {
            long startCreate = System.currentTimeMillis();
            long memBeforeCreate = PngIO.getUsedMemoryMB();
            BufferedImage dst = new BufferedImage(w, h, type);
            long createDuration = System.currentTimeMillis() - startCreate;
            long memAfterCreate = PngIO.getUsedMemoryMB();
            Log.info(() -> "QuantifyPacked28: destination image created in " + createDuration + " ms, memory: " + memBeforeCreate + " -> " + memAfterCreate + " MB (delta: " + (memAfterCreate - memBeforeCreate) + " MB)");
            long startExtract = System.currentTimeMillis();
            long memBeforeExtract = PngIO.getUsedMemoryMB();
            int[] pixels = src.getRGB(0, 0, w, h, null, 0, w);
            long extractDuration = System.currentTimeMillis() - startExtract;
            long memAfterExtract = PngIO.getUsedMemoryMB();
            Log.info(() -> "QuantifyPacked28: pixel extraction in " + extractDuration + " ms, memory: " + memBeforeExtract + " -> " + memAfterExtract + " MB (delta: " + (memAfterExtract - memBeforeExtract) + " MB)");
            long startCompress = System.currentTimeMillis();
            long memBeforeCompress = PngIO.getUsedMemoryMB();
            int[] out = new int[pixels.length];
            for (int i = 0; i < pixels.length; ++i) {
                int argb = pixels[i];
                out[i] = QuantUtils.compressPackedARGB(argb);
            }
            long compressDuration = System.currentTimeMillis() - startCompress;
            long memAfterCompress = PngIO.getUsedMemoryMB();
            Log.info(() -> "QuantifyPacked28: pixel compression in " + compressDuration + " ms, memory: " + memBeforeCompress + " -> " + memAfterCompress + " MB (delta: " + (memAfterCompress - memBeforeCompress) + " MB)");
            long startWrite = System.currentTimeMillis();
            long memBeforeWrite = PngIO.getUsedMemoryMB();
            dst.setRGB(0, 0, w, h, out, 0, w);
            long writeDuration = System.currentTimeMillis() - startWrite;
            long memAfterWrite = PngIO.getUsedMemoryMB();
            Log.info(() -> "QuantifyPacked28: pixel write in " + writeDuration + " ms, memory: " + memBeforeWrite + " -> " + memAfterWrite + " MB (delta: " + (memAfterWrite - memBeforeWrite) + " MB)");
            return dst;
        }
        catch (Throwable t) {
            Log.info(() -> "QuantifyPacked28: exception caught: " + t.getClass().getSimpleName() + " - " + t.getMessage());
            return null;
        }
    }
}

