/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.project;

import net.sourceforge.plantuml.decoration.LinkDecor;
import net.sourceforge.plantuml.decoration.LinkType;
import net.sourceforge.plantuml.decoration.WithLinkType;
import net.sourceforge.plantuml.klimt.color.HColor;
import net.sourceforge.plantuml.klimt.color.HColorSet;
import net.sourceforge.plantuml.klimt.shape.UDrawable;
import net.sourceforge.plantuml.project.GanttArrow;
import net.sourceforge.plantuml.project.core.Task;
import net.sourceforge.plantuml.project.core.TaskAttribute;
import net.sourceforge.plantuml.project.core.TaskInstant;
import net.sourceforge.plantuml.project.data.TaskDrawRegistryData;
import net.sourceforge.plantuml.project.time.TimePoint;
import net.sourceforge.plantuml.project.timescale.TimeScale;
import net.sourceforge.plantuml.style.PName;
import net.sourceforge.plantuml.style.SName;
import net.sourceforge.plantuml.style.Style;
import net.sourceforge.plantuml.style.StyleBuilder;
import net.sourceforge.plantuml.style.StyleSignatureBasic;

public class GanttConstraint
extends WithLinkType {
    private final TaskInstant source;
    private final TaskInstant dest;
    private final StyleBuilder styleBuilder;
    private final HColorSet colorSet;

    public GanttConstraint(HColorSet colorSet, StyleBuilder styleBuilder, TaskInstant source, TaskInstant dest, HColor forcedColor) {
        this.styleBuilder = styleBuilder;
        this.colorSet = colorSet;
        this.source = source;
        this.dest = dest;
        this.type = new LinkType(LinkDecor.NONE, LinkDecor.NONE);
        this.setSpecificColor(forcedColor);
    }

    public GanttConstraint(HColorSet colorSet, StyleBuilder styleBuilder, TaskInstant source, TaskInstant dest) {
        this(colorSet, styleBuilder, source, dest, null);
    }

    public boolean isOn(Task task) {
        return this.source.getMoment() == task || this.dest.getMoment() == task;
    }

    public boolean isThereRightArrow(Task task) {
        if (this.dest.getMoment() == task && this.dest.getAttribute() == TaskAttribute.END) {
            return true;
        }
        return this.source.getMoment() == task && this.dest.getAttribute() == TaskAttribute.END && this.source.getAttribute() == TaskAttribute.END;
    }

    public String toString() {
        return this.source.toString() + " --> " + this.dest.toString();
    }

    public final StyleSignatureBasic getStyleSignature() {
        return StyleSignatureBasic.of(SName.root, SName.element, SName.ganttDiagram, SName.arrow);
    }

    public UDrawable getUDrawable(TimeScale timeScale, TaskDrawRegistryData toTaskDraw) {
        Style style = this.getStyleSignature().getMergedStyle(this.styleBuilder).eventuallyOverride(PName.LineColor, this.getSpecificColor());
        style = style.eventuallyOverride(this.getType().getStroke3(style.getStroke()));
        return new GanttArrow(this.colorSet, style, timeScale, this.source, this.dest, toTaskDraw, this.styleBuilder);
    }

    public boolean isHidden(TimePoint min, TimePoint max) {
        if (this.isHidden(this.source.getInstantPrecise(), min, max)) {
            return true;
        }
        return this.isHidden(this.dest.getInstantPrecise(), min, max);
    }

    private boolean isHidden(TimePoint now, TimePoint min, TimePoint max) {
        if (now.compareTo(min) < 0) {
            return true;
        }
        return now.compareTo(max) > 0;
    }

    @Override
    public void goNorank() {
    }
}

