/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.project;

import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import net.sourceforge.plantuml.project.DayStatus;
import net.sourceforge.plantuml.project.ngm.math.Combiner;
import net.sourceforge.plantuml.project.ngm.math.Fraction;
import net.sourceforge.plantuml.project.ngm.math.PiecewiseConstant;
import net.sourceforge.plantuml.project.ngm.math.PiecewiseConstantSpecificDays;
import net.sourceforge.plantuml.project.ngm.math.PiecewiseConstantTimeWindow;
import net.sourceforge.plantuml.project.ngm.math.PiecewiseConstantWeekday;

public class OpenClose {
    private final Map<DayOfWeek, DayStatus> weekdayStatus = new EnumMap<DayOfWeek, DayStatus>(DayOfWeek.class);
    private final Map<LocalDate, DayStatus> dayStatus = new HashMap<LocalDate, DayStatus>();
    private LocalDate offBefore;
    private LocalDate offAfter;

    public OpenClose mutateMe(OpenClose except) {
        OpenClose result = new OpenClose();
        result.weekdayStatus.putAll(this.weekdayStatus);
        result.dayStatus.putAll(this.dayStatus);
        result.offBefore = this.offBefore;
        result.offAfter = this.offAfter;
        if (except != null) {
            result.weekdayStatus.putAll(except.weekdayStatus);
            result.dayStatus.putAll(except.dayStatus);
        }
        return result;
    }

    public int daysInWeek() {
        int result = 7;
        for (DayStatus status : this.weekdayStatus.values()) {
            if (status != DayStatus.CLOSE) continue;
            --result;
        }
        return result;
    }

    private boolean isThereSomeChangeAfter(LocalDate day) {
        if (this.weekdayStatus.size() > 0) {
            return true;
        }
        for (LocalDate tmp : this.dayStatus.keySet()) {
            if (tmp.compareTo(day) < 0) continue;
            return true;
        }
        return false;
    }

    private boolean isThereSomeChangeBefore(LocalDate day) {
        if (this.weekdayStatus.size() > 0) {
            return true;
        }
        for (LocalDate tmp : this.dayStatus.keySet()) {
            if (tmp.compareTo(day) > 0) continue;
            return true;
        }
        return false;
    }

    public boolean isClosed(LocalDate day) {
        DayStatus status = this.getLocalStatus(day);
        if (status != null) {
            return status == DayStatus.CLOSE;
        }
        return false;
    }

    private DayStatus getLocalStatus(LocalDate day) {
        if (this.offBefore != null && day.compareTo(this.offBefore) < 0) {
            return DayStatus.CLOSE;
        }
        if (this.offAfter != null && day.compareTo(this.offAfter) > 0) {
            return DayStatus.CLOSE;
        }
        DayStatus status1 = this.dayStatus.get(day);
        if (status1 != null) {
            return status1;
        }
        DayOfWeek dayOfWeek = day.getDayOfWeek();
        DayStatus status2 = this.weekdayStatus.get(dayOfWeek);
        if (status2 != null) {
            return status2;
        }
        return null;
    }

    public void close(DayOfWeek day) {
        this.weekdayStatus.put(day, DayStatus.CLOSE);
    }

    public void open(DayOfWeek day) {
        this.weekdayStatus.put(day, DayStatus.OPEN);
    }

    public void close(LocalDate day) {
        this.dayStatus.put(day, DayStatus.CLOSE);
    }

    public void open(LocalDate day) {
        this.dayStatus.put(day, DayStatus.OPEN);
    }

    public int getLoadAtDUMMY(LocalDate day) {
        return this.getLoatAtInternal(day);
    }

    public void setOffBeforeDate(LocalDate day) {
        this.offBefore = day;
    }

    public void setOffAfterDate(LocalDate day) {
        this.offAfter = day;
    }

    private int getLoatAtInternal(LocalDate day) {
        if (this.isClosed(day)) {
            return 0;
        }
        return 100;
    }

    public LocalDate getLastDayIfAny() {
        return this.offAfter;
    }

    public PiecewiseConstant asPiecewiseConstant() {
        PiecewiseConstantWeekday weekPattern = PiecewiseConstantWeekday.of(Fraction.ONE);
        for (DayOfWeek day : this.weekdayStatus.keySet()) {
            if (this.weekdayStatus.get(day) != DayStatus.CLOSE) continue;
            weekPattern = weekPattern.with(day, Fraction.ZERO);
        }
        PiecewiseConstant result = weekPattern;
        if (!this.dayStatus.isEmpty()) {
            PiecewiseConstantSpecificDays specificDaysClosed = PiecewiseConstantSpecificDays.of(Fraction.ONE);
            PiecewiseConstantSpecificDays specificDaysOpen = PiecewiseConstantSpecificDays.of(Fraction.ZERO);
            for (Map.Entry<LocalDate, DayStatus> entry : this.dayStatus.entrySet()) {
                LocalDate date = entry.getKey();
                if (entry.getValue() == DayStatus.CLOSE) {
                    specificDaysClosed = specificDaysClosed.withDay(date, Fraction.ZERO);
                    continue;
                }
                specificDaysOpen = specificDaysOpen.withDay(date, Fraction.ONE);
            }
            result = Combiner.max(specificDaysOpen, Combiner.product(weekPattern, specificDaysClosed));
        }
        if (this.offBefore == null && this.offAfter == null) {
            return result;
        }
        if (this.offBefore == null) {
            return Combiner.product(result, new PiecewiseConstantTimeWindow(LocalDateTime.MIN, this.offAfter.plusDays(1L).atStartOfDay()));
        }
        if (this.offAfter == null) {
            return Combiner.product(result, new PiecewiseConstantTimeWindow(this.offBefore.atStartOfDay(), LocalDateTime.MAX));
        }
        return Combiner.product(result, new PiecewiseConstantTimeWindow(this.offBefore.atStartOfDay(), this.offAfter.plusDays(1L).atStartOfDay()));
    }
}

