/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.project.core;

import java.time.DayOfWeek;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import net.sourceforge.plantuml.klimt.creole.Display;
import net.sourceforge.plantuml.project.GanttDiagram;
import net.sourceforge.plantuml.project.Load;
import net.sourceforge.plantuml.project.core.AbstractTask;
import net.sourceforge.plantuml.project.core.Resource;
import net.sourceforge.plantuml.project.core.Task;
import net.sourceforge.plantuml.project.core.TaskAttribute;
import net.sourceforge.plantuml.project.core.TaskCode;
import net.sourceforge.plantuml.project.lang.CenterBorderColor;
import net.sourceforge.plantuml.project.ngm.NGMAllocation;
import net.sourceforge.plantuml.project.ngm.math.Combiner;
import net.sourceforge.plantuml.project.ngm.math.Fraction;
import net.sourceforge.plantuml.project.ngm.math.PiecewiseConstant;
import net.sourceforge.plantuml.project.ngm.math.PiecewiseConstantSpecificDays;
import net.sourceforge.plantuml.project.ngm.math.PiecewiseConstantUtils;
import net.sourceforge.plantuml.project.ngm.math.PiecewiseConstantWeekday;
import net.sourceforge.plantuml.project.solver.Solver;
import net.sourceforge.plantuml.project.time.TimePoint;
import net.sourceforge.plantuml.stereo.Stereotype;
import net.sourceforge.plantuml.style.StyleBuilder;
import net.sourceforge.plantuml.url.Url;

public class TaskImpl
extends AbstractTask
implements Task {
    private final SortedSet<LocalDate> pausedDay = new TreeSet<LocalDate>();
    private final EnumSet<DayOfWeek> pausedDayOfWeek = EnumSet.noneOf(DayOfWeek.class);
    private final Solver solver;
    private final Map<Resource, Integer> resources = new LinkedHashMap<Resource, Integer>();
    private boolean diamond;
    private final GanttDiagram gantt;
    private int completion;
    private Display note;
    private Stereotype noteStereotype;
    private Url url;
    private CenterBorderColor[] colors;

    @Override
    public void setUrl(Url url) {
        this.url = url;
    }

    public TaskImpl(GanttDiagram gantt, StyleBuilder styleBuilder, TaskCode code, TimePoint startingDay, int completion) {
        super(styleBuilder, code);
        this.gantt = gantt;
        this.completion = completion;
        this.solver = new Solver();
        this.setStart(startingDay);
        this.setLoad(Load.ofDays(1));
    }

    public PiecewiseConstant getDefaultPlan() {
        return this.gantt.getLoadPlanableForTask(this.getCode().getId());
    }

    private PiecewiseConstant localPause() {
        PiecewiseConstantWeekday weekPattern = PiecewiseConstantWeekday.of(Fraction.ONE);
        for (DayOfWeek day : this.pausedDayOfWeek) {
            weekPattern = weekPattern.with(day, Fraction.ZERO);
        }
        PiecewiseConstant result = weekPattern;
        if (!this.pausedDay.isEmpty()) {
            PiecewiseConstantSpecificDays specificDaysClosed = PiecewiseConstantSpecificDays.of(Fraction.ONE);
            for (LocalDate date : this.pausedDay) {
                specificDaysClosed = specificDaysClosed.withDay(date, Fraction.ZERO);
            }
            result = Combiner.product(weekPattern, specificDaysClosed);
        }
        return result;
    }

    public PiecewiseConstant asPiecewiseConstant() {
        if (this.resources.size() > 0) {
            return Combiner.product(this.getDefaultPlan(), this.allRessources());
        }
        return Combiner.product(this.getDefaultPlan(), this.localPause());
    }

    private boolean isPaused(TimePoint instant) {
        if (this.pausedDay.contains(instant.toDay())) {
            return true;
        }
        return this.pausedDayOfWeek(instant);
    }

    private boolean pausedDayOfWeek(TimePoint instant) {
        for (DayOfWeek dayOfWeek : this.pausedDayOfWeek) {
            if (instant.toDayOfWeek() != dayOfWeek) continue;
            return true;
        }
        return false;
    }

    public int loadForResource(Resource res, TimePoint instant) {
        if (this.resources.keySet().contains(res) && instant.compareTo(this.getStart()) >= 0 && instant.compareTo(this.getEndMinusOneDayTOBEREMOVED()) <= 0) {
            if (this.isPaused(instant)) {
                return 0;
            }
            if (res.isClosedAt(instant.toDay())) {
                return 0;
            }
            return this.resources.get(res);
        }
        return 0;
    }

    @Override
    public void addPause(LocalDate pause) {
        this.pausedDay.add(pause);
    }

    @Override
    public void addPause(DayOfWeek pause) {
        this.pausedDayOfWeek.add(pause);
    }

    public PiecewiseConstant allRessources() {
        ArrayList<PiecewiseConstant> contributions = new ArrayList<PiecewiseConstant>();
        for (Map.Entry<Resource, Integer> ent : this.resources.entrySet()) {
            Resource res = ent.getKey();
            PiecewiseConstant availability = res.asPiecewiseConstant();
            PiecewiseConstantSpecificDays percentageFraction = PiecewiseConstantSpecificDays.of(new Fraction(ent.getValue().intValue(), 100L));
            PiecewiseConstant contribution = Combiner.product(availability, percentageFraction);
            contributions.add(contribution);
        }
        return Combiner.product(this.localPause(), Combiner.sum(contributions.toArray(new PiecewiseConstant[0])));
    }

    public String getPrettyDisplay() {
        if (this.resources.size() > 0) {
            StringBuilder result = new StringBuilder(this.getCode().getDisplay());
            result.append(" ");
            Iterator<Map.Entry<Resource, Integer>> it = this.resources.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<Resource, Integer> ent = it.next();
                result.append("{");
                result.append(ent.getKey().getName());
                int percentage = ent.getValue();
                if (percentage != 100) {
                    result.append(":" + percentage + "%");
                }
                result.append("}");
                if (!it.hasNext()) continue;
                result.append(" ");
            }
            return result.toString();
        }
        return this.getCode().getDisplay();
    }

    public String toString() {
        return this.getCode().toString();
    }

    public String debug() {
        return String.valueOf(this.getStart()) + " ---> " + String.valueOf(this.getEnd()) + "   [" + String.valueOf(this.getLoad()) + "]";
    }

    @Override
    public TimePoint getStart() {
        NGMAllocation allocation = NGMAllocation.of(this.asPiecewiseConstant());
        TimePoint result = (TimePoint)this.solver.getData(allocation, TaskAttribute.START);
        if (!this.diamond) {
            PiecewiseConstant cal = this.asPiecewiseConstant();
            while (PiecewiseConstantUtils.isZeroOnDay(cal, result.toDay())) {
                result = result.increment();
            }
        }
        return result;
    }

    @Override
    public TimePoint getEnd() {
        NGMAllocation allocation = NGMAllocation.of(this.asPiecewiseConstant());
        TimePoint result = (TimePoint)this.solver.getData(allocation, TaskAttribute.END);
        return result;
    }

    @Override
    public Load getLoad() {
        NGMAllocation allocation = NGMAllocation.of(this.asPiecewiseConstant());
        return (Load)this.solver.getData(allocation, TaskAttribute.LOAD);
    }

    @Override
    public void setLoad(Load load) {
        this.solver.setData(TaskAttribute.LOAD, load);
    }

    @Override
    public void setStart(TimePoint start) {
        if (!start.toString().endsWith("T00:00")) {
            throw new IllegalArgumentException(start.toString());
        }
        this.solver.setData(TaskAttribute.START, start);
    }

    @Override
    public void setEnd(TimePoint end) {
        if (!end.toString().endsWith("T00:00")) {
            throw new IllegalArgumentException(end.toString());
        }
        this.solver.setData(TaskAttribute.END, end);
    }

    @Override
    public void setColors(CenterBorderColor ... colors) {
        this.colors = colors;
    }

    @Override
    public void addResource(Resource resource, int percentage) {
        this.resources.put(resource, percentage);
    }

    @Override
    public void setDiamond(boolean diamond) {
        this.diamond = diamond;
    }

    @Override
    public boolean isDiamond() {
        return this.diamond;
    }

    @Override
    public void setCompletion(int completion) {
        this.completion = completion;
    }

    public final Url getUrl() {
        return this.url;
    }

    public final CenterBorderColor getColors() {
        if (this.colors == null) {
            return null;
        }
        if (this.colors.length == 1) {
            return this.colors[0];
        }
        return this.colors[0].unlinearTo(this.colors[1], this.completion);
    }

    public final int getCompletion() {
        return this.completion;
    }

    public final Collection<LocalDate> getAllPaused() {
        TreeSet<LocalDate> result = new TreeSet<LocalDate>(this.pausedDay);
        for (DayOfWeek dayOfWeek : this.pausedDayOfWeek) {
            this.addAll(result, dayOfWeek);
        }
        return Collections.unmodifiableCollection(result);
    }

    private void addAll(SortedSet<LocalDate> result, DayOfWeek dayOfWeek) {
        TimePoint start = this.getStart();
        TimePoint end = this.getEndMinusOneDayTOBEREMOVED();
        TimePoint current = start;
        while (current.compareTo(end) <= 0) {
            if (current.toDayOfWeek() == dayOfWeek) {
                result.add(current.toDay());
            }
            current = current.increment();
        }
    }

    @Override
    public void setNote(Display note, Stereotype stereotype) {
        this.note = note;
        this.noteStereotype = stereotype;
    }

    public Display getNote() {
        return this.note;
    }

    public Stereotype getNoteStereotype() {
        return this.noteStereotype;
    }

    @Override
    public boolean isAssignedTo(Resource res) {
        return this.resources.containsKey(res);
    }
}

