/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.project.data;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.sourceforge.plantuml.project.GanttConstraint;
import net.sourceforge.plantuml.project.core.Resource;
import net.sourceforge.plantuml.project.core.Task;
import net.sourceforge.plantuml.project.core.TaskCode;
import net.sourceforge.plantuml.project.core.TaskImpl;
import net.sourceforge.plantuml.project.core.TaskSeparator;
import net.sourceforge.plantuml.project.time.TimePoint;

public class GanttModelData {
    private final List<GanttConstraint> constraints = new ArrayList<GanttConstraint>();
    private final Map<TaskCode, Task> tasks = new LinkedHashMap<TaskCode, Task>();
    private final Map<String, Resource> resources = new LinkedHashMap<String, Resource>();

    public Collection<Task> getTasks() {
        return Collections.unmodifiableCollection(this.tasks.values());
    }

    public Collection<Resource> getResources() {
        return Collections.unmodifiableCollection(this.resources.values());
    }

    public Collection<GanttConstraint> getConstraints() {
        return Collections.unmodifiableCollection(this.constraints);
    }

    public void addConstraint(GanttConstraint constraint) {
        this.constraints.add(constraint);
    }

    public void putTask(TaskCode code, Task task) {
        this.tasks.put(code, task);
    }

    public Task getTask(TaskCode code) {
        return this.tasks.get(code);
    }

    public void putResource(String name, Resource resource) {
        this.resources.put(name, resource);
    }

    public Resource getResource(String name) {
        return this.resources.get(name);
    }

    public int getLoadForResource(Resource res, TimePoint i) {
        int result = 0;
        for (Task task : this.getTasks()) {
            if (task instanceof TaskSeparator) continue;
            TaskImpl task2 = (TaskImpl)task;
            result += task2.loadForResource(res, i);
        }
        return result;
    }

    public Collection<GanttConstraint> getConstraintsForTask(Task task) {
        ArrayList<GanttConstraint> result = new ArrayList<GanttConstraint>();
        for (GanttConstraint constraint : this.getConstraints()) {
            if (!constraint.isOn(task)) continue;
            result.add(constraint);
        }
        return Collections.unmodifiableCollection(result);
    }
}

