/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.project.data;

import java.time.LocalDate;
import net.sourceforge.plantuml.project.core.Task;
import net.sourceforge.plantuml.project.core.TaskGroup;
import net.sourceforge.plantuml.project.core.TaskSeparator;
import net.sourceforge.plantuml.project.data.DayCalendarData;
import net.sourceforge.plantuml.project.data.GanttModelData;
import net.sourceforge.plantuml.project.draw.header.TimeHeader;
import net.sourceforge.plantuml.project.time.TimePoint;

public class TimeBoundsData {
    private LocalDate minDay = TimePoint.epoch();
    private LocalDate maxDay;
    private LocalDate printStart;
    private LocalDate printEnd;

    public LocalDate getMinDay() {
        return this.minDay;
    }

    public LocalDate getMaxDay() {
        return this.maxDay;
    }

    public LocalDate getPrintStart() {
        return this.printStart;
    }

    public LocalDate getPrintEnd() {
        return this.printEnd;
    }

    public void setMinDay(LocalDate minDay) {
        this.minDay = minDay;
    }

    public void setMaxDay(LocalDate maxDay) {
        this.maxDay = maxDay;
    }

    public void setPrintStart(LocalDate printStart) {
        this.printStart = printStart;
    }

    public void setPrintEnd(LocalDate printEnd) {
        this.printEnd = printEnd;
    }

    public TimePoint getStartForDrawing(Task tmp) {
        TimePoint result = this.getPrintStart() == null ? tmp.getStart() : TimePoint.max(TimePoint.ofStartOfDay(this.getMinDay()), tmp.getStart());
        return result;
    }

    public TimePoint getEndForDrawing(Task tmp) {
        TimePoint result = this.getPrintStart() == null ? tmp.getEnd() : TimePoint.min(TimePoint.ofStartOfDay(this.getMaxDay().plusDays(1L)), tmp.getEnd());
        return result;
    }

    public boolean isHidden(Task task) {
        if (this.getPrintStart() == null || task instanceof TaskSeparator) {
            return false;
        }
        if (task.getEndMinusOneDayTOBEREMOVED().compareTo(TimePoint.ofStartOfDay(this.getMinDay())) < 0) {
            return true;
        }
        return task.getStart().compareTo(TimePoint.ofEndOfDayMinusOneSecond(this.getMaxDay())) > 0;
    }

    public double getBarsColumnWidth(TimeHeader timeHeader) {
        double xmin = timeHeader.getTimeScale().getPosition(TimePoint.ofStartOfDay(this.getMinDay()));
        double xmax = timeHeader.getTimeScale().getPosition(TimePoint.ofEndOfDayMinusOneSecond(this.getMaxDay()));
        return xmax - xmin;
    }

    public void initMinMax(GanttModelData modelData, DayCalendarData dayCalendar) {
        if (modelData.getTasks().isEmpty()) {
            this.setMaxDay(this.getMinDay());
        } else {
            this.setMaxDay(null);
            for (Task task : modelData.getTasks()) {
                if (task instanceof TaskSeparator || task instanceof TaskGroup) continue;
                TimePoint tmp = task.getEnd().minusOneSecond();
                if (this.getMaxDay() != null && this.getMaxDay().compareTo(tmp.toDay()) >= 0) continue;
                this.setMaxDay(tmp.toDay());
            }
        }
        for (TimePoint d : dayCalendar.getColorDays()) {
            if (d.toDay().compareTo(this.getMaxDay()) <= 0) continue;
            this.setMaxDay(d.toDay());
        }
        for (TimePoint d : dayCalendar.getNameDays().keySet()) {
            if (d.toDay().compareTo(this.getMaxDay()) <= 0) continue;
            this.setMaxDay(d.toDay());
        }
    }
}

