/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.project.draw;

import net.sourceforge.plantuml.klimt.UTranslate;
import net.sourceforge.plantuml.klimt.color.HColor;
import net.sourceforge.plantuml.klimt.color.HColors;
import net.sourceforge.plantuml.klimt.creole.Display;
import net.sourceforge.plantuml.klimt.drawing.UGraphic;
import net.sourceforge.plantuml.klimt.font.FontConfiguration;
import net.sourceforge.plantuml.klimt.font.StringBounder;
import net.sourceforge.plantuml.klimt.font.UFont;
import net.sourceforge.plantuml.klimt.font.UFontFactory;
import net.sourceforge.plantuml.klimt.geom.HorizontalAlignment;
import net.sourceforge.plantuml.klimt.shape.TextBlock;
import net.sourceforge.plantuml.klimt.shape.ULine;
import net.sourceforge.plantuml.klimt.sprite.SpriteContainerEmpty;
import net.sourceforge.plantuml.project.core.Resource;
import net.sourceforge.plantuml.project.data.GanttModelData;
import net.sourceforge.plantuml.project.data.TimelineStyleData;
import net.sourceforge.plantuml.project.draw.ResourceDraw;
import net.sourceforge.plantuml.project.time.TimePoint;
import net.sourceforge.plantuml.project.timescale.TimeScale;

public class ResourceDrawNumbers
implements ResourceDraw {
    private final Resource res;
    private final TimeScale timeScale;
    private final double y;
    private final TimePoint min;
    private final TimePoint maxTimePointPrintedEndOfDay;
    private final GanttModelData ganttModelData;
    private final TimelineStyleData timelineStyleData;

    public ResourceDrawNumbers(GanttModelData ganttModelData, TimelineStyleData timelineStyleData, Resource res, TimeScale timeScale, double y, TimePoint min, TimePoint maxTimePointPrintedEndOfDay) {
        this.res = res;
        this.timeScale = timeScale;
        this.y = y;
        this.min = min;
        this.maxTimePointPrintedEndOfDay = maxTimePointPrintedEndOfDay;
        this.ganttModelData = ganttModelData;
        this.timelineStyleData = timelineStyleData;
    }

    @Override
    public void drawU(UGraphic ug) {
        TextBlock title = Display.getWithNewlines(this.timelineStyleData.getPragma(), this.res.getName()).create(this.getFontConfiguration(13), HorizontalAlignment.LEFT, new SpriteContainerEmpty());
        title.drawU(ug);
        ULine line = ULine.hline(this.timeScale.getPosition(this.maxTimePointPrintedEndOfDay) - this.timeScale.getPosition(this.min));
        ug.apply(HColors.BLACK).apply(UTranslate.dy(title.calculateDimension(ug.getStringBounder()).getHeight())).draw(line);
        double startingPosition = -1.0;
        int totalLoad = 0;
        boolean isRed = false;
        TimePoint i = this.min;
        while (i.compareTo(this.maxTimePointPrintedEndOfDay) <= 0) {
            boolean isBreaking = this.timeScale.isBreaking(i);
            int load = this.ganttModelData.getLoadForResource(this.res, i);
            if (load > 100) {
                isRed = true;
            }
            totalLoad += load;
            if (isBreaking) {
                if (totalLoad > 0) {
                    TextBlock value = this.getTextBlock(totalLoad, isRed);
                    if (startingPosition == -1.0) {
                        startingPosition = this.timeScale.getPosition(i);
                    }
                    double endingPosition = this.timeScale.getPosition(i) + this.timeScale.getWidth(i);
                    double start = (startingPosition + endingPosition) / 2.0 - value.calculateDimension(ug.getStringBounder()).getWidth() / 2.0;
                    value.drawU(ug.apply(new UTranslate(start, 16.0)));
                }
                startingPosition = -1.0;
                totalLoad = 0;
                isRed = false;
            } else if (startingPosition == -1.0) {
                startingPosition = this.timeScale.getPosition(i);
            }
            i = i.increment();
        }
    }

    private TextBlock getTextBlock(int totalLoad, boolean isRed) {
        Display display = Display.getWithNewlines(this.timelineStyleData.getSkinParam().getPragma(), "" + totalLoad);
        FontConfiguration fontConfiguration = this.getFontConfiguration(isRed);
        return display.create(fontConfiguration, HorizontalAlignment.LEFT, new SpriteContainerEmpty());
    }

    private FontConfiguration getFontConfiguration(boolean isRed) {
        return this.getFontConfiguration(9, isRed ? HColors.RED : HColors.BLACK);
    }

    private FontConfiguration getFontConfiguration(int size) {
        return this.getFontConfiguration(size, HColors.BLACK);
    }

    private FontConfiguration getFontConfiguration(int size, HColor color) {
        UFont font = UFontFactory.serif(size);
        return FontConfiguration.create(font, color, color, null);
    }

    @Override
    public double getHeight(StringBounder stringBounder) {
        return 32.0;
    }

    @Override
    public final double getY() {
        return this.y;
    }
}

