/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.project.draw.header;

import java.time.DayOfWeek;
import java.time.LocalDate;
import net.sourceforge.plantuml.klimt.UTranslate;
import net.sourceforge.plantuml.klimt.color.HColor;
import net.sourceforge.plantuml.klimt.color.HColors;
import net.sourceforge.plantuml.klimt.creole.Display;
import net.sourceforge.plantuml.klimt.drawing.UGraphic;
import net.sourceforge.plantuml.klimt.font.FontConfiguration;
import net.sourceforge.plantuml.klimt.font.StringBounder;
import net.sourceforge.plantuml.klimt.font.UFont;
import net.sourceforge.plantuml.klimt.geom.HorizontalAlignment;
import net.sourceforge.plantuml.klimt.shape.TextBlock;
import net.sourceforge.plantuml.klimt.shape.ULine;
import net.sourceforge.plantuml.klimt.shape.URectangle;
import net.sourceforge.plantuml.klimt.sprite.SpriteContainerEmpty;
import net.sourceforge.plantuml.project.data.DayCalendarData;
import net.sourceforge.plantuml.project.data.TimeBoundsData;
import net.sourceforge.plantuml.project.data.TimeScaleConfigData;
import net.sourceforge.plantuml.project.data.TimelineStyleData;
import net.sourceforge.plantuml.project.data.WeekConfigData;
import net.sourceforge.plantuml.project.time.TimePoint;
import net.sourceforge.plantuml.project.timescale.TimeScale;
import net.sourceforge.plantuml.skin.Pragma;
import net.sourceforge.plantuml.style.SName;

public abstract class TimeHeader {
    private final TimeScale timeScale;
    protected final DayCalendarData dayCalendar;
    protected final TimeBoundsData timeBounds;
    protected final TimeScaleConfigData scaleConfig;
    protected final TimelineStyleData timelineStyle;
    protected final WeekConfigData weekConfigData;

    public TimeHeader(TimeScale timeScale, WeekConfigData weekConfigData, DayCalendarData dayCalendar, TimeBoundsData timeBounds, TimeScaleConfigData scaleConfig, TimelineStyleData timelineStyle) {
        this.weekConfigData = weekConfigData;
        this.dayCalendar = dayCalendar;
        this.timeBounds = timeBounds;
        this.scaleConfig = scaleConfig;
        this.timelineStyle = timelineStyle;
        this.timeScale = timeScale;
    }

    public HColor getColor(TimePoint wink) {
        return this.dayCalendar.getDayColor(wink);
    }

    public HColor getColor(DayOfWeek dayOfWeek) {
        return this.dayCalendar.getDayOfWeekColor(dayOfWeek);
    }

    protected final boolean isBold(LocalDate wink) {
        return this.dayCalendar.hasSeparatorBefore(wink);
    }

    protected final LocalDate getMinDay() {
        return this.timeBounds.getMinDay();
    }

    protected final LocalDate getMaxDay() {
        return this.timeBounds.getMaxDay();
    }

    protected final HColor closedBackgroundColor() {
        return this.timelineStyle.getClosedBackgroundColor();
    }

    protected final HColor closedFontColor() {
        return this.timelineStyle.getClosedFontColor();
    }

    protected final HColor openFontColor() {
        return this.timelineStyle.getOpenFontColor();
    }

    protected final HColor getLineColor() {
        return this.timelineStyle.getLineColor();
    }

    public abstract double getTimeHeaderHeight(StringBounder var1);

    public abstract double getTimeFooterHeight(StringBounder var1);

    public abstract double getFullHeaderHeight(StringBounder var1);

    public abstract void drawTimeHeader(UGraphic var1, double var2);

    public abstract void drawTimeFooter(UGraphic var1);

    public final TimeScale getTimeScale() {
        return this.timeScale;
    }

    protected final void drawHline(UGraphic ug, double y) {
        double xmin = this.getTimeScale().getPosition(TimePoint.ofStartOfDay(this.timeBounds.getMinDay()));
        double xmax = this.getTimeScale().getPosition(TimePoint.ofEndOfDayMinusOneSecond(this.timeBounds.getMaxDay()));
        ULine hline = ULine.hline(xmax - xmin);
        ug.apply(this.getLineColor()).apply(UTranslate.dy(y)).draw(hline);
    }

    protected final void drawVline(UGraphic ug, double x, double y1, double y2) {
        ULine vbar = ULine.vline(y2 - y1);
        ug.apply(new UTranslate(x, y1)).draw(vbar);
    }

    protected final FontConfiguration getFontConfiguration(UFont font, boolean bold, HColor color) {
        if (bold) {
            font = font.bold();
        }
        return FontConfiguration.create(font, color, color, null);
    }

    protected final TextBlock getTextBlock(SName param, String text, boolean bold, HColor color) {
        UFont font = this.timelineStyle.getFont(param);
        FontConfiguration fontConfiguration = this.getFontConfiguration(font, bold, color);
        return Display.getWithNewlines(this.getPragma(), text).create(fontConfiguration, HorizontalAlignment.LEFT, new SpriteContainerEmpty());
    }

    protected final void printCentered(UGraphic ug, TextBlock text, double start, double end) {
        double width = text.calculateDimension(ug.getStringBounder()).getWidth();
        double available = end - start;
        double diff = Math.max(0.0, available - width);
        text.drawU(ug.apply(UTranslate.dx(start + diff / 2.0)));
    }

    protected final void printCentered(UGraphic ug, boolean hideIfTooBig, double start, double end, TextBlock ... texts) {
        double available = end - start;
        for (int i = texts.length - 1; i >= 0; --i) {
            TextBlock text = texts[i];
            double width = text.calculateDimension(ug.getStringBounder()).getWidth();
            if ((i != 0 || hideIfTooBig) && !(width <= available)) continue;
            double diff = Math.max(0.0, available - width);
            text.drawU(ug.apply(UTranslate.dx(start + diff / 2.0)));
            return;
        }
    }

    protected final void drawRectangle(UGraphic ug, double height, double x1, double x2) {
        if (height == 0.0) {
            return;
        }
        ug = ug.apply(HColors.none());
        ug = ug.apply(new UTranslate(x1, this.getFullHeaderHeight(ug.getStringBounder())));
        if (x2 > x1) {
            ug.draw(URectangle.build(x2 - x1, height));
        }
    }

    protected void printVerticalSeparators(UGraphic ug, double totalHeightWithoutFooter) {
        ug = this.timelineStyle.applyVerticalSeparatorStyle(ug);
        LocalDate day = this.getMinDay();
        while (day.compareTo(this.getMaxDay()) <= 0) {
            if (this.isBold(day)) {
                this.drawVline(ug, this.getTimeScale().getPosition(TimePoint.ofStartOfDay(day)), this.getFullHeaderHeight(ug.getStringBounder()), totalHeightWithoutFooter);
            }
            day = day.plusDays(1L);
        }
    }

    protected Pragma getPragma() {
        return Pragma.createEmpty();
    }

    class Pending {
        final double x1;
        double x2;
        final HColor color;

        Pending(HColor color, double x1, double x2) {
            this.x1 = x1;
            this.x2 = x2;
            this.color = color;
        }

        public void draw(UGraphic ug, double height) {
            TimeHeader.this.drawRectangle(ug.apply(this.color.bg()), height, this.x1, this.x2);
        }
    }
}

