/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.project.lang;

import java.time.LocalDate;
import java.util.Arrays;
import java.util.Collection;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.klimt.color.HColor;
import net.sourceforge.plantuml.project.Failable;
import net.sourceforge.plantuml.project.GanttDiagram;
import net.sourceforge.plantuml.project.lang.CenterBorderColor;
import net.sourceforge.plantuml.project.lang.ComplementClose;
import net.sourceforge.plantuml.project.lang.ComplementInColors2;
import net.sourceforge.plantuml.project.lang.ComplementOpen;
import net.sourceforge.plantuml.project.lang.SentenceSimple;
import net.sourceforge.plantuml.project.lang.Subject;
import net.sourceforge.plantuml.project.lang.TimeResolution;
import net.sourceforge.plantuml.project.lang.Verbs;
import net.sourceforge.plantuml.regex.IRegex;
import net.sourceforge.plantuml.regex.RegexConcat;
import net.sourceforge.plantuml.regex.RegexLeaf;
import net.sourceforge.plantuml.regex.RegexOr;
import net.sourceforge.plantuml.regex.RegexResult;

public class SubjectDayAsDate
implements Subject<GanttDiagram> {
    public static final Subject<GanttDiagram> ME = new SubjectDayAsDate();

    private SubjectDayAsDate() {
    }

    @Override
    public Failable<LocalDate> getMe(GanttDiagram project, RegexResult arg) {
        if (arg.get("BDAY", 0) != null) {
            return Failable.ok(this.resultB(arg));
        }
        if (arg.get("ECOUNT", 0) != null) {
            return Failable.ok(this.resultE(project, arg));
        }
        throw new IllegalStateException();
    }

    private LocalDate resultB(RegexResult arg) {
        int day = Integer.parseInt(arg.get("BDAY", 0));
        int month = Integer.parseInt(arg.get("BMONTH", 0));
        int year = Integer.parseInt(arg.get("BYEAR", 0));
        return LocalDate.of(year, month, day);
    }

    private LocalDate resultE(GanttDiagram system, RegexResult arg) {
        String type = arg.get("ETYPE", 0).toUpperCase();
        String operation = arg.get("EOPERATION", 0);
        int day = Integer.parseInt(arg.get("ECOUNT", 0));
        if ("-".equals(operation)) {
            day = -day;
        }
        if ("D".equals(type)) {
            return system.getMinDay().plusDays(day);
        }
        if ("T".equals(type)) {
            return system.getToday().plusDays(day);
        }
        if ("E".equals(type)) {
            return system.getMaxDay().plusDays(day);
        }
        throw new IllegalStateException();
    }

    @Override
    public Collection<? extends SentenceSimple<GanttDiagram>> getSentences() {
        return Arrays.asList(new Close(), new Open(), new InColor());
    }

    @Override
    public IRegex toRegex() {
        return new RegexOr(this.toRegexB(), this.toRegexE());
    }

    private IRegex toRegexB() {
        return TimeResolution.toRegexB_YYYY_MM_DD("BYEAR", "BMONTH", "BDAY");
    }

    private IRegex toRegexE() {
        return new RegexConcat(new RegexLeaf(1, "ETYPE", "([dDtTeE])"), new RegexLeaf(1, "EOPERATION", "([-+])"), new RegexLeaf(1, "ECOUNT", "([\\d]+)"));
    }

    class Close
    extends SentenceSimple<GanttDiagram> {
        public Close() {
            super(SubjectDayAsDate.this, Verbs.isOrAre, new ComplementClose());
        }

        @Override
        public CommandExecutionResult execute(GanttDiagram project, Object subject, Object complement) {
            project.closeDayAsDate((LocalDate)subject, (String)complement);
            return CommandExecutionResult.ok();
        }
    }

    class Open
    extends SentenceSimple<GanttDiagram> {
        public Open() {
            super(SubjectDayAsDate.this, Verbs.isOrAre, new ComplementOpen());
        }

        @Override
        public CommandExecutionResult execute(GanttDiagram project, Object subject, Object complement) {
            project.openDayAsDate((LocalDate)subject, (String)complement);
            return CommandExecutionResult.ok();
        }
    }

    class InColor
    extends SentenceSimple<GanttDiagram> {
        public InColor() {
            super(SubjectDayAsDate.this, Verbs.isOrAre, new ComplementInColors2());
        }

        @Override
        public CommandExecutionResult execute(GanttDiagram project, Object subject, Object complement) {
            HColor color = ((CenterBorderColor)complement).getCenter();
            project.colorDay((LocalDate)subject, color);
            return CommandExecutionResult.ok();
        }
    }
}

