/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.project.ngm.math;

import java.util.Objects;
import java.util.function.BiFunction;

public final class Fraction
implements Comparable<Fraction> {
    public static final BiFunction<Fraction, Fraction, Fraction> PRODUCT = Fraction::multiply;
    public static final BiFunction<Fraction, Fraction, Fraction> SUM = Fraction::add;
    public static final BiFunction<Fraction, Fraction, Fraction> MIN = (a, b) -> a.compareTo((Fraction)b) <= 0 ? a : b;
    public static final BiFunction<Fraction, Fraction, Fraction> MAX = (a, b) -> a.compareTo((Fraction)b) >= 0 ? a : b;
    public static final Fraction ZERO = new Fraction(0L, 1L);
    public static final Fraction ONE = new Fraction(1L, 1L);
    private final long num;
    private final long den;

    public Fraction(long numerator, long denominator) {
        if (denominator == 0L) {
            throw new IllegalArgumentException("Denominator cannot be zero.");
        }
        if (denominator < 0L) {
            numerator = -numerator;
            denominator = -denominator;
        }
        long g = Fraction.gcd(Math.abs(numerator), denominator);
        this.num = numerator / g;
        this.den = denominator / g;
    }

    public static Fraction of(long value) {
        return new Fraction(value, 1L);
    }

    public long getNumerator() {
        return this.num;
    }

    public long getDenominator() {
        return this.den;
    }

    public Fraction reciprocal() {
        return new Fraction(this.den, this.num);
    }

    public Fraction negate() {
        return new Fraction(-this.num, this.den);
    }

    public Fraction add(Fraction other) {
        long n = this.num * other.den + other.num * this.den;
        long d = this.den * other.den;
        return new Fraction(n, d);
    }

    public Fraction subtract(Fraction other) {
        long n = this.num * other.den - other.num * this.den;
        long d = this.den * other.den;
        return new Fraction(n, d);
    }

    public Fraction multiply(Fraction other) {
        long n = this.num * other.num;
        long d = this.den * other.den;
        return new Fraction(n, d);
    }

    public Fraction divide(Fraction other) {
        return this.multiply(other.reciprocal());
    }

    public long wholePart() {
        return this.num / this.den;
    }

    public String toString() {
        if (this.den == 1L) {
            return Long.toString(this.num);
        }
        return this.num + "/" + this.den;
    }

    @Override
    public int compareTo(Fraction other) {
        Objects.requireNonNull(other, "other fraction must not be null");
        long lhs = this.num * other.den;
        long rhs = other.num * this.den;
        return Long.compare(lhs, rhs);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Fraction)) {
            return false;
        }
        Fraction other = (Fraction)obj;
        return this.num == other.num && this.den == other.den;
    }

    public int hashCode() {
        int result = Long.hashCode(this.num);
        result = 31 * result + Long.hashCode(this.den);
        return result;
    }

    private static long gcd(long a, long b) {
        while (b != 0L) {
            long t = b;
            b = a % b;
            a = t;
        }
        return a;
    }

    public boolean isZero() {
        return this.num == 0L;
    }
}

