/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.project.timescale;

import java.time.LocalDate;
import net.sourceforge.plantuml.project.core.PrintScale;
import net.sourceforge.plantuml.project.time.TimePoint;
import net.sourceforge.plantuml.project.timescale.TimeScale;
import net.sourceforge.plantuml.project.timescale.TimeScaleWink;

public final class TimeScaleDaily
implements TimeScale {
    private final TimeScaleWink basic;
    private final double delta;

    public TimeScaleDaily(double size, TimePoint startingDay, double scale, LocalDate zeroDay) {
        this.basic = new TimeScaleWink(size, scale, PrintScale.DAILY);
        this.delta = zeroDay == null ? this.basic.getPosition(startingDay) : this.basic.getPosition(TimePoint.ofStartOfDay(zeroDay));
    }

    @Override
    public double getPosition(TimePoint instant) {
        return this.basic.getPosition(instant) - this.delta;
    }

    @Override
    public double getWidth(TimePoint instant) {
        return this.basic.getWidth(instant);
    }

    @Override
    public boolean isBreaking(TimePoint instant) {
        return true;
    }
}

