/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.security;

import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import javax.imageio.stream.ImageOutputStream;
import net.sourceforge.plantuml.klimt.awt.PortableImage;
import net.sourceforge.plantuml.klimt.awt.PortableImageFactory;
import net.sourceforge.plantuml.security.SFile;
import net.sourceforge.plantuml.teavm.TeaVM;

public class SImageIO {
    public static PortableImage read(InputStream is) throws IOException {
        if (TeaVM.isTeaVM()) {
            return null;
        }
        return PortableImageFactory.build(ImageIO.read(is));
    }

    public static PortableImage read(byte[] bytes) throws IOException {
        if (TeaVM.isTeaVM()) {
            return null;
        }
        return PortableImageFactory.build(ImageIO.read(new ByteArrayInputStream(bytes)));
    }

    public static ImageOutputStream createImageOutputStream(OutputStream os) throws IOException {
        return ImageIO.createImageOutputStream(os);
    }

    public static void write(PortableImage image, String format, OutputStream os) throws IOException {
        ImageIO.write((RenderedImage)image.getBufferedImage(), format, os);
    }

    public static void write(PortableImage image, String format, SFile file) throws IOException {
        ImageIO.write((RenderedImage)image.getBufferedImage(), format, file.conv());
    }

    public static PortableImage read(File file) throws IOException {
        return PortableImageFactory.build(ImageIO.read(file));
    }

    public static PortableImage read(SFile file) throws IOException {
        return PortableImageFactory.build(ImageIO.read(file.conv()));
    }

    public static ImageInputStream createImageInputStream(SFile file) throws IOException {
        return ImageIO.createImageInputStream(file.conv());
    }

    public static ImageInputStream createImageInputStream(Object obj) throws IOException {
        if (obj instanceof SFile) {
            obj = ((SFile)obj).conv();
        }
        return ImageIO.createImageInputStream(obj);
    }

    public static ImageInputStream createImageInputStream(InputStream is) throws IOException {
        return ImageIO.createImageInputStream(is);
    }

    public static Iterator<ImageReader> getImageReaders(ImageInputStream iis) {
        return ImageIO.getImageReaders(iis);
    }
}

