/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.security;

import net.sourceforge.plantuml.security.SecurityUtils;
import net.sourceforge.plantuml.teavm.TeaVM;

public enum SecurityProfile {
    SANDBOX,
    ALLOWLIST,
    INTERNET,
    LEGACY,
    UNSECURE;


    static SecurityProfile init() {
        if (TeaVM.isTeaVM()) {
            return UNSECURE;
        }
        String env = SecurityUtils.getenv("PLANTUML_SECURITY_PROFILE");
        if ("SANDBOX".equalsIgnoreCase(env)) {
            return SANDBOX;
        }
        if ("ALLOWLIST".equalsIgnoreCase(env)) {
            return ALLOWLIST;
        }
        if ("INTERNET".equalsIgnoreCase(env)) {
            return INTERNET;
        }
        if ("UNSECURE".equalsIgnoreCase(env)) {
            return UNSECURE;
        }
        return LEGACY;
    }

    public String longDescription() {
        switch (this) {
            case SANDBOX: {
                return "This is completely safe: no access to local files or to distant URL.";
            }
            case ALLOWLIST: {
                return "Some local resource may be accessible.";
            }
            case INTERNET: {
                return "<i>Mode designed for server connected to Internet.";
            }
            case LEGACY: {
                return "<b>Warning: this mode will be removed in future version";
            }
            case UNSECURE: {
                return "<b>Make sure that this server is not accessible from Internet";
            }
        }
        return "<i>This is completely safe: no access on local files or on distant URL.";
    }

    public long getTimeout() {
        switch (this) {
            case SANDBOX: {
                return 1000L;
            }
            case ALLOWLIST: {
                return 300000L;
            }
            case INTERNET: {
                return 10000L;
            }
            case LEGACY: {
                return 60000L;
            }
            case UNSECURE: {
                return 300000L;
            }
        }
        throw new AssertionError();
    }

    public boolean canWeReadThisEnvironmentVariable(String name) {
        if (name == null) {
            return false;
        }
        String lname = name.toLowerCase();
        if (lname.startsWith("plantuml.security")) {
            return false;
        }
        if (lname.startsWith("plantuml")) {
            return true;
        }
        if (lname.equals("path.separator") || lname.equals("line.separator")) {
            return true;
        }
        return this == UNSECURE;
    }
}

