/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.statediagram.command;

import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.abel.Entity;
import net.sourceforge.plantuml.abel.LeafType;
import net.sourceforge.plantuml.abel.Link;
import net.sourceforge.plantuml.abel.LinkArg;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.ParserPass;
import net.sourceforge.plantuml.command.SingleLineCommand2;
import net.sourceforge.plantuml.decoration.LinkDecor;
import net.sourceforge.plantuml.decoration.LinkType;
import net.sourceforge.plantuml.klimt.color.ColorType;
import net.sourceforge.plantuml.klimt.color.NoSuchColorException;
import net.sourceforge.plantuml.klimt.creole.Display;
import net.sourceforge.plantuml.plasma.Quark;
import net.sourceforge.plantuml.regex.IRegex;
import net.sourceforge.plantuml.regex.RegexLeaf;
import net.sourceforge.plantuml.regex.RegexResult;
import net.sourceforge.plantuml.statediagram.StateDiagram;
import net.sourceforge.plantuml.stereo.Stereotype;
import net.sourceforge.plantuml.utils.Direction;
import net.sourceforge.plantuml.utils.LineLocation;

abstract class CommandLinkStateCommon
extends SingleLineCommand2<StateDiagram> {
    CommandLinkStateCommon(IRegex pattern) {
        super(pattern);
    }

    @Override
    public boolean isEligibleFor(ParserPass pass) {
        return pass == ParserPass.TWO;
    }

    protected static RegexLeaf getStatePattern(String name) {
        return new RegexLeaf(3, name, "([%pLN_.:]+|[%pLN_.:]+\\[H\\*?\\]|\\[\\*\\]|\\[H\\*?\\]|(?:==+)(?:[%pLN_.:]+)(?:==+))[%s]*(\\<\\<.*\\>\\>)?[%s]*(#\\w+)?");
    }

    @Override
    protected CommandExecutionResult executeArg(StateDiagram diagram, LineLocation location, RegexResult arg, ParserPass currentPass) throws NoSuchColorException {
        String s;
        String ent1 = arg.get("ENT1", 0);
        String ent2 = arg.get("ENT2", 0);
        Entity cl1 = this.getEntityStart(location, diagram, ent1);
        if (cl1 == null) {
            return CommandExecutionResult.error("The state " + ent1 + " cannot be used here.");
        }
        Entity cl2 = this.getEntityEnd(location, diagram, ent2);
        if (cl2 == null) {
            return CommandExecutionResult.error("The state " + ent2 + " cannot be used here.");
        }
        if (arg.get("ENT1", 1) != null) {
            cl1.setStereotype(Stereotype.build(arg.get("ENT1", 1)));
        }
        if (arg.get("ENT1", 2) != null) {
            s = arg.get("ENT1", 2);
            cl1.setSpecificColorTOBEREMOVED(ColorType.BACK, diagram.getSkinParam().getIHtmlColorSet().getColor(s));
        }
        if (arg.get("ENT2", 1) != null) {
            cl2.setStereotype(Stereotype.build(arg.get("ENT2", 1)));
        }
        if (arg.get("ENT2", 2) != null) {
            s = arg.get("ENT2", 2);
            cl2.setSpecificColorTOBEREMOVED(ColorType.BACK, diagram.getSkinParam().getIHtmlColorSet().getColor(s));
        }
        Object queue = arg.get("ARROW_BODY1", 0) + arg.get("ARROW_BODY2", 0);
        Direction dir = this.getDirection(arg);
        if (dir == Direction.LEFT || dir == Direction.RIGHT) {
            queue = "-";
        }
        int lenght = ((String)queue).length();
        boolean crossStart = arg.get("ARROW_CROSS_START", 0) != null;
        boolean circleEnd = arg.get("ARROW_CIRCLE_END", 0) != null;
        LinkType linkType = new LinkType(circleEnd ? LinkDecor.ARROW_AND_CIRCLE : LinkDecor.ARROW, crossStart ? LinkDecor.CIRCLE_CROSS : LinkDecor.NONE);
        Display label = Display.getWithNewlines(diagram.getPragma(), arg.get("LABEL", 0));
        boolean useNodeStyle = this.shouldUseNodeStyle(diagram, arg);
        if (useNodeStyle && label != null && !Display.isNull(label) && !label.toString().trim().isEmpty()) {
            return this.createTransitionWithIntermediateNode(diagram, location, cl1, cl2, label, linkType, lenght, dir, arg);
        }
        LinkArg linkArg = LinkArg.build(label, lenght, diagram.getSkinParam().classAttributeIconSize() > 0);
        Link link = new Link(location, diagram, diagram.getSkinParam().getCurrentStyleBuilder(), cl1, cl2, linkType, linkArg);
        if (dir == Direction.LEFT || dir == Direction.UP) {
            link = link.getInv();
        }
        link.applyStyle(arg.getLazzy("ARROW_STYLE", 0));
        diagram.addLink(link);
        return CommandExecutionResult.ok();
    }

    private Direction getDirection(RegexResult arg) {
        String arrowDirection = arg.get("ARROW_DIRECTION", 0);
        if (arrowDirection != null) {
            return StringUtils.getQueueDirection(arrowDirection);
        }
        return this.getDefaultDirection();
    }

    protected Direction getDefaultDirection() {
        return null;
    }

    private Entity getEntityStart(LineLocation location, StateDiagram diagram, String code) {
        if (code.startsWith("[*]")) {
            return diagram.getStart(location);
        }
        return this.getEntity(location, diagram, code);
    }

    private Entity getEntityEnd(LineLocation location, StateDiagram diagram, String code) {
        if (code.startsWith("[*]")) {
            return diagram.getEnd(location);
        }
        return this.getEntity(location, diagram, code);
    }

    private Entity getEntity(LineLocation location, StateDiagram diagram, String code) {
        if (code.equalsIgnoreCase("[H]")) {
            return diagram.getHistorical(location);
        }
        if (code.endsWith("[H]")) {
            return diagram.getHistorical(location, code.substring(0, code.length() - 3));
        }
        if (code.equalsIgnoreCase("[H*]")) {
            return diagram.getDeepHistory(location);
        }
        if (code.endsWith("[H*]")) {
            return diagram.getDeepHistory(location, code.substring(0, code.length() - 4));
        }
        if (code.startsWith("=") && code.endsWith("=")) {
            String codeString1 = this.removeEquals(code);
            Quark<Entity> quark = diagram.quarkInContext(true, diagram.cleanId(codeString1));
            if (quark.getData() != null) {
                return quark.getData();
            }
            return diagram.reallyCreateLeaf(location, quark, Display.getWithNewlines(quark), LeafType.SYNCHRO_BAR, null);
        }
        if (diagram.getCurrentGroup().getName().equals(code)) {
            return diagram.getCurrentGroup();
        }
        Quark<Entity> quark = diagram.quarkInContext(true, diagram.cleanId(code));
        if (!diagram.checkConcurrentStateOk(quark)) {
            return null;
        }
        if (quark.getData() != null) {
            return quark.getData();
        }
        if (quark.getParent().getData() == null) {
            return null;
        }
        return diagram.reallyCreateLeaf(location, quark, Display.getWithNewlines(diagram.getPragma(), quark.getName()), LeafType.STATE, null);
    }

    private String removeEquals(String code) {
        while (code.startsWith("=")) {
            code = code.substring(1);
        }
        while (code.endsWith("=")) {
            code = code.substring(0, code.length() - 1);
        }
        return code;
    }

    private boolean shouldUseNodeStyle(StateDiagram diagram, RegexResult arg) {
        String arrowStyle = arg.getLazzy("ARROW_STYLE", 0);
        if (arrowStyle != null && arrowStyle.toLowerCase().contains("node")) {
            return true;
        }
        String globalSetting = diagram.getSkinParam().getValue("statediagramedgelabelstyle");
        return globalSetting != null && globalSetting.equalsIgnoreCase("node");
    }

    private CommandExecutionResult createTransitionWithIntermediateNode(StateDiagram diagram, LineLocation location, Entity source, Entity target, Display label, LinkType linkType, int length, Direction dir, RegexResult arg) throws NoSuchColorException {
        String filteredStyle;
        String arrowStyle;
        String transitionNodeId = this.generateTransitionNodeId(source, target, label);
        Quark<Entity> transitionQuark = diagram.quarkInContext(true, diagram.cleanId(transitionNodeId));
        Entity transitionNode = diagram.reallyCreateLeaf(location, transitionQuark, label, LeafType.STATE_TRANSITION_LABEL, null);
        transitionNode.setStereotype(Stereotype.build("<<transition>>"));
        LinkType firstLinkType = new LinkType(LinkDecor.NONE, LinkDecor.NONE);
        LinkArg firstLinkArg = LinkArg.build(Display.NULL, 2, diagram.getSkinParam().classAttributeIconSize() > 0);
        Link firstLink = new Link(location, diagram, diagram.getSkinParam().getCurrentStyleBuilder(), source, transitionNode, firstLinkType, firstLinkArg);
        firstLink.setWeight(10.0);
        LinkArg secondLinkArg = LinkArg.build(Display.NULL, 2, diagram.getSkinParam().classAttributeIconSize() > 0);
        Link secondLink = new Link(location, diagram, diagram.getSkinParam().getCurrentStyleBuilder(), transitionNode, target, linkType, secondLinkArg);
        secondLink.setWeight(10.0);
        if (dir == Direction.LEFT || dir == Direction.UP) {
            firstLink = firstLink.getInv();
            secondLink = secondLink.getInv();
        }
        if ((arrowStyle = arg.getLazzy("ARROW_STYLE", 0)) != null && !(filteredStyle = arrowStyle.replaceAll("(?i),?node,?", "").replaceAll(",,", ",").replaceAll("^,|,$", "")).isEmpty()) {
            firstLink.applyStyle(filteredStyle);
            secondLink.applyStyle(filteredStyle);
        }
        diagram.addLink(firstLink);
        diagram.addLink(secondLink);
        return CommandExecutionResult.ok();
    }

    private String generateTransitionNodeId(Entity source, Entity target, Display label) {
        String sourceId = source.getName();
        String targetId = target.getName();
        String labelText = label.toString().replaceAll("[^a-zA-Z0-9_]", "_");
        return "transition_" + sourceId + "_" + targetId + "_" + labelText + "_" + System.currentTimeMillis();
    }
}

