/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.style;

import java.util.Collection;
import java.util.EnumMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.sourceforge.plantuml.style.AutomaticCounter;
import net.sourceforge.plantuml.style.MergeStrategy;
import net.sourceforge.plantuml.style.PName;
import net.sourceforge.plantuml.style.Style;
import net.sourceforge.plantuml.style.StyleSignatureBasic;
import net.sourceforge.plantuml.style.StyleStorage;
import net.sourceforge.plantuml.style.Value;
import net.sourceforge.plantuml.utils.Log;

public class StyleBuilder
implements AutomaticCounter {
    private final StyleStorage storage = new StyleStorage();
    private final Set<StyleSignatureBasic> printedForLog;
    private int counter;
    private final Map<StyleSignatureBasic, Style> mergedStyleCache = new ConcurrentHashMap<StyleSignatureBasic, Style>();

    public void printMe() {
        this.storage.printMe();
    }

    private StyleBuilder(Set<StyleSignatureBasic> printedForLog) {
        this.printedForLog = new LinkedHashSet<StyleSignatureBasic>();
    }

    public StyleBuilder() {
        this(new LinkedHashSet<StyleSignatureBasic>());
    }

    public StyleBuilder cloneMe() {
        StyleBuilder result = new StyleBuilder();
        result.storage.putAll(this.storage);
        result.counter = this.counter;
        return result;
    }

    public Style createStyleStereotype(String name) {
        if (name.contains("*")) {
            throw new IllegalArgumentException();
        }
        StyleSignatureBasic signature = StyleSignatureBasic.createStereotype(name = name.toLowerCase());
        Style result = this.storage.get(signature);
        if (result == null) {
            return new Style(signature, new EnumMap<PName, Value>(PName.class));
        }
        return result;
    }

    public StyleBuilder muteStyle(Collection<Style> modifiedStyles) {
        StyleBuilder result = new StyleBuilder(this.printedForLog);
        result.counter = this.counter;
        result.storage.putAll(this.storage);
        for (Style modifiedStyle : modifiedStyles) {
            StyleSignatureBasic signature = modifiedStyle.getSignature();
            Style orig = result.storage.get(signature);
            if (orig == null) {
                result.storage.put(modifiedStyle);
                continue;
            }
            Style tmp = orig.mergeWith(modifiedStyle, MergeStrategy.OVERWRITE_EXISTING_VALUE);
            result.storage.put(tmp);
        }
        return result;
    }

    public void loadInternal(StyleSignatureBasic signature, Style newStyle) {
        if (signature.isStarred()) {
            throw new IllegalArgumentException();
        }
        Style orig = this.storage.get(signature);
        if (orig == null) {
            this.storage.put(newStyle);
        } else {
            Style tmp = orig.mergeWith(newStyle, MergeStrategy.OVERWRITE_EXISTING_VALUE);
            this.storage.put(tmp);
        }
    }

    @Override
    public int getNextInt() {
        return ++this.counter;
    }

    public Style getMergedStyle(StyleSignatureBasic signature) {
        return this.mergedStyleCache.computeIfAbsent(signature, sig -> this.computeMergedStyle((StyleSignatureBasic)sig));
    }

    private Style computeMergedStyle(StyleSignatureBasic signature) {
        boolean added = this.printedForLog.add(signature);
        if (added) {
            Log.info(() -> "Using style " + String.valueOf(signature));
        }
        return this.storage.computeMergedStyle(signature);
    }

    public Style getMergedStyleSpecial(StyleSignatureBasic signature, int deltaPriority) {
        boolean added = this.printedForLog.add(signature);
        if (added) {
            Log.info(() -> "Using style " + String.valueOf(signature));
        }
        Style mergedStyle = null;
        for (Style style : this.storage.getStyles()) {
            StyleSignatureBasic key = style.getSignature();
            if (!key.matchAll(signature)) continue;
            Style tmp = style;
            if (key.isStarred()) {
                tmp = tmp.deltaPriority(deltaPriority);
            }
            if (mergedStyle == null) {
                mergedStyle = tmp;
                continue;
            }
            mergedStyle = mergedStyle.mergeWith(tmp, MergeStrategy.OVERWRITE_EXISTING_VALUE);
        }
        return mergedStyle;
    }
}

