/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.svek;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class LineOfSegments {
    private final List<Segment> all = new ArrayList<Segment>();

    public void addSegment(double x1, double x2) {
        this.all.add(new Segment(this.all.size(), x1, x2));
    }

    public double getMean() {
        double sum = 0.0;
        for (Segment seg : this.all) {
            sum += seg.middle;
        }
        return sum / (double)this.all.size();
    }

    void solveOverlapsInternal() {
        if (this.all.size() < 2) {
            return;
        }
        Collections.sort(this.all);
        for (int i = 0; i < this.all.size(); ++i) {
            if (this.oneLoop()) continue;
            return;
        }
    }

    private boolean oneLoop() {
        for (int i = this.all.size() - 2; i >= 0; --i) {
            Segment seg2;
            Segment seg1 = this.all.get(i);
            double overlap = seg1.overlap(seg2 = this.all.get(i + 1));
            if (!(overlap > 0.0)) continue;
            for (int k = i + 1; k < this.all.size(); ++k) {
                this.all.get(k).push(overlap);
            }
            return true;
        }
        return false;
    }

    public double[] solveOverlaps() {
        double mean1 = this.getMean();
        this.solveOverlapsInternal();
        double mean2 = this.getMean();
        double diff = mean1 - mean2;
        if (diff != 0.0) {
            for (Segment seg : this.all) {
                seg.push(diff);
            }
        }
        double[] result = new double[this.all.size()];
        for (Segment seg : this.all) {
            result[seg.idx] = seg.middle - seg.halfSize;
        }
        return result;
    }

    private static class Segment
    implements Comparable<Segment> {
        private final int idx;
        private double middle;
        private final double halfSize;

        private Segment(int idx, double x1, double x2) {
            this.idx = idx;
            this.middle = (x1 + x2) / 2.0;
            this.halfSize = (x2 - x1) / 2.0;
        }

        @Override
        public int compareTo(Segment other) {
            return Double.compare(this.middle, other.middle);
        }

        private double overlap(Segment other) {
            double distance = other.middle - this.middle;
            if (distance < 0.0) {
                throw new IllegalArgumentException();
            }
            double diff = distance - this.halfSize - other.halfSize;
            if (diff > 0.0) {
                return 0.0;
            }
            return -diff;
        }

        private void push(double delta) {
            this.middle += delta;
        }
    }
}

