/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.svek.extremity;

import net.sourceforge.plantuml.klimt.UTranslate;
import net.sourceforge.plantuml.klimt.awt.XAffineTransform;
import net.sourceforge.plantuml.klimt.drawing.UGraphic;
import net.sourceforge.plantuml.klimt.geom.XPoint2D;
import net.sourceforge.plantuml.klimt.shape.ULine;
import net.sourceforge.plantuml.svek.extremity.Extremity;

class ExtremityDoubleLine
extends Extremity {
    private final XPoint2D contact;
    private final double angle;
    private final double lineHeight = 4.0;

    @Override
    public XPoint2D somePoint() {
        return this.contact;
    }

    public ExtremityDoubleLine(XPoint2D p1, double angle) {
        this.contact = new XPoint2D(p1.getX(), p1.getY());
        this.angle = this.manageround(angle + 1.5707963267948966);
    }

    @Override
    public void drawU(UGraphic ug) {
        int xWing = 4;
        XAffineTransform rotate = XAffineTransform.getRotateInstance(this.angle);
        XPoint2D firstLineTop = new XPoint2D(-4.0, -4.0);
        XPoint2D firstLineBottom = new XPoint2D(-4.0, 4.0);
        XPoint2D secondLineTop = new XPoint2D(-7.0, -4.0);
        XPoint2D secondLineBottom = new XPoint2D(-7.0, 4.0);
        XPoint2D middle = new XPoint2D(0.0, 0.0);
        XPoint2D base = new XPoint2D(-8.0, 0.0);
        middle = middle.transform(rotate);
        base = base.transform(rotate);
        firstLineTop = firstLineTop.transform(rotate);
        firstLineBottom = firstLineBottom.transform(rotate);
        secondLineTop = secondLineTop.transform(rotate);
        secondLineBottom = secondLineBottom.transform(rotate);
        ExtremityDoubleLine.drawLine(ug, this.contact.getX(), this.contact.getY(), firstLineTop, firstLineBottom);
        ExtremityDoubleLine.drawLine(ug, this.contact.getX(), this.contact.getY(), secondLineTop, secondLineBottom);
        ExtremityDoubleLine.drawLine(ug, this.contact.getX(), this.contact.getY(), base, middle);
    }

    @Override
    public double getDecorationLength() {
        return 8.0;
    }

    private static void drawLine(UGraphic ug, double x, double y, XPoint2D p1, XPoint2D p2) {
        double dx = p2.getX() - p1.getX();
        double dy = p2.getY() - p1.getY();
        ug.apply(new UTranslate(x + p1.getX(), y + p1.getY())).draw(new ULine(dx, dy));
    }
}

