/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.svek.image;

import net.sourceforge.plantuml.abel.Entity;
import net.sourceforge.plantuml.klimt.UGroup;
import net.sourceforge.plantuml.klimt.UGroupType;
import net.sourceforge.plantuml.klimt.UStroke;
import net.sourceforge.plantuml.klimt.UTranslate;
import net.sourceforge.plantuml.klimt.creole.CreoleMode;
import net.sourceforge.plantuml.klimt.creole.Display;
import net.sourceforge.plantuml.klimt.drawing.UGraphic;
import net.sourceforge.plantuml.klimt.font.FontConfiguration;
import net.sourceforge.plantuml.klimt.font.StringBounder;
import net.sourceforge.plantuml.klimt.geom.HorizontalAlignment;
import net.sourceforge.plantuml.klimt.geom.XDimension2D;
import net.sourceforge.plantuml.klimt.shape.TextBlock;
import net.sourceforge.plantuml.klimt.shape.UEllipse;
import net.sourceforge.plantuml.klimt.shape.ULine;
import net.sourceforge.plantuml.stereo.Stereotype;
import net.sourceforge.plantuml.svek.image.EntityImageStateCommon;

public class EntityImageState
extends EntityImageStateCommon {
    private final TextBlock fields;
    private final HorizontalAlignment horizontalAlignmentFields;
    private static final int MIN_WIDTH = 50;
    private static final int MIN_HEIGHT = 50;
    private final boolean withSymbol;
    private static final double smallRadius = 3.0;
    private static final double smallLine = 3.0;
    private static final double smallMarginX = 7.0;
    private static final double smallMarginY = 4.0;

    public EntityImageState(Entity entity) {
        super(entity);
        Stereotype stereotype = entity.getStereotype();
        this.withSymbol = stereotype != null && stereotype.isWithOOSymbol();
        Display list = Display.create(entity.getBodier().getRawBody());
        FontConfiguration fieldsFontConfiguration = this.getStyleStateHeader().getFontConfiguration(this.getSkinParam().getIHtmlColorSet());
        this.horizontalAlignmentFields = this.getStyleStateHeader().getHorizontalAlignment();
        this.fields = list.create8(fieldsFontConfiguration, this.horizontalAlignmentFields, this.getSkinParam(), CreoleMode.FULL, this.getStyleState().wrapWidth());
    }

    @Override
    public XDimension2D calculateDimension(StringBounder stringBounder) {
        XDimension2D dim = this.title.calculateDimension(stringBounder).mergeTB(this.fields.calculateDimension(stringBounder));
        double heightSymbol = 0.0;
        if (this.withSymbol) {
            heightSymbol += 10.0;
        }
        XDimension2D result = dim.delta(20.0 + heightSymbol);
        return result.atLeast(50.0, 50.0);
    }

    @Override
    public final void drawU(UGraphic ug) {
        UGroup group = UGroup.singletonMap(UGroupType.ID, this.getEntity().getQuark().toStringPoint());
        group.put(UGroupType.CLASS, "entity");
        group.put(UGroupType.ID, "entity_" + this.getEntity().getName());
        group.put(UGroupType.DATA_ENTITY, this.getEntity().getName());
        group.put(UGroupType.DATA_UID, this.getEntity().getUid());
        group.put(UGroupType.DATA_QUALIFIED_NAME, this.getEntity().getQuark().getQualifiedName());
        ug.startGroup(group);
        if (this.url != null) {
            ug.startUrl(this.url);
        }
        StringBounder stringBounder = ug.getStringBounder();
        XDimension2D dimTotal = this.calculateDimension(stringBounder);
        XDimension2D dimDesc = this.title.calculateDimension(stringBounder);
        UStroke stroke = this.getStyleState().getStroke(this.lineConfig.getColors());
        ug = this.applyColor(ug);
        ug = ug.apply(stroke);
        ug.draw(this.getShape(dimTotal));
        double yLine = 5.0 + dimDesc.getHeight() + 5.0;
        ug.apply(UTranslate.dy(yLine)).draw(ULine.hline(dimTotal.getWidth()));
        if (this.withSymbol) {
            double xSymbol = dimTotal.getWidth();
            double ySymbol = dimTotal.getHeight();
            EntityImageState.drawSymbol(ug, xSymbol, ySymbol);
        }
        double xDesc = (dimTotal.getWidth() - dimDesc.getWidth()) / 2.0;
        double yDesc = 5.0;
        this.title.drawU(ug.apply(new UTranslate(xDesc, 5.0)));
        double xFields = 5.0;
        double yFields = yLine + 5.0;
        this.horizontalAlignmentFields.draw(ug, this.fields, 5.0, yFields, dimTotal.getWidth());
        if (this.url != null) {
            ug.closeUrl();
        }
        ug.closeGroup();
    }

    public static void drawSymbol(UGraphic ug, double xSymbol, double ySymbol) {
        UEllipse small = UEllipse.build(6.0, 6.0);
        ug.apply(new UTranslate(xSymbol -= 22.0, ySymbol -= 10.0)).draw(small);
        ug.apply(new UTranslate(xSymbol + 3.0 + 6.0, ySymbol)).draw(small);
        ug.apply(new UTranslate(xSymbol + 6.0, ySymbol + 3.0)).draw(ULine.hline(3.0));
    }
}

