/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.teavm;

import net.sourceforge.plantuml.klimt.ClipContainer;
import net.sourceforge.plantuml.klimt.UParam;
import net.sourceforge.plantuml.klimt.color.ColorMapper;
import net.sourceforge.plantuml.klimt.drawing.UDriver;
import net.sourceforge.plantuml.klimt.shape.UEllipse;
import net.sourceforge.plantuml.teavm.DriverRectangleTeaVM;
import net.sourceforge.plantuml.teavm.SvgGraphicsTeaVM;

public class DriverEllipseTeaVM
implements UDriver<UEllipse, SvgGraphicsTeaVM> {
    private final ClipContainer clipContainer;

    public DriverEllipseTeaVM(ClipContainer clipContainer) {
        this.clipContainer = clipContainer;
    }

    @Override
    public void draw(UEllipse ellipse, double x, double y, ColorMapper mapper, UParam param, SvgGraphicsTeaVM svg) {
        DriverRectangleTeaVM.applyFillColor(svg, mapper, param);
        DriverRectangleTeaVM.applyStrokeColor(svg, mapper, param);
        svg.setStrokeWidth(param.getStroke().getThickness());
        double width = ellipse.getWidth();
        double height = ellipse.getHeight();
        double cx = x + width / 2.0;
        double cy = y + height / 2.0;
        double rx = width / 2.0;
        double ry = height / 2.0;
        if (Math.abs(rx - ry) < 0.01) {
            svg.drawCircle(cx, cy, rx);
        } else {
            svg.drawEllipse(cx, cy, rx, ry);
        }
    }
}

