/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.teavm;

import net.sourceforge.plantuml.klimt.ClipContainer;
import net.sourceforge.plantuml.klimt.UParam;
import net.sourceforge.plantuml.klimt.color.ColorMapper;
import net.sourceforge.plantuml.klimt.color.HColor;
import net.sourceforge.plantuml.klimt.drawing.UDriver;
import net.sourceforge.plantuml.klimt.shape.URectangle;
import net.sourceforge.plantuml.teavm.SvgGraphicsTeaVM;

public class DriverRectangleTeaVM
implements UDriver<URectangle, SvgGraphicsTeaVM> {
    private final ClipContainer clipContainer;

    public DriverRectangleTeaVM(ClipContainer clipContainer) {
        this.clipContainer = clipContainer;
    }

    @Override
    public void draw(URectangle rect, double x, double y, ColorMapper mapper, UParam param, SvgGraphicsTeaVM svg) {
        double rx = rect.getRx();
        double ry = rect.getRy();
        double width = rect.getWidth();
        double height = rect.getHeight();
        DriverRectangleTeaVM.applyFillColor(svg, mapper, param);
        DriverRectangleTeaVM.applyStrokeColor(svg, mapper, param);
        svg.setStrokeWidth(param.getStroke().getThickness());
        svg.drawRectangle(x, y, width, height, rx / 2.0, ry / 2.0);
    }

    public static void applyFillColor(SvgGraphicsTeaVM svg, ColorMapper mapper, UParam param) {
        HColor background = param.getBackcolor();
        if (background == null) {
            svg.setFillColor("none");
        } else {
            svg.setFillColor(background.toSvg(mapper));
        }
    }

    public static void applyStrokeColor(SvgGraphicsTeaVM svg, ColorMapper mapper, UParam param) {
        HColor color = param.getColor();
        if (color == null) {
            svg.setStrokeColor("none");
        } else {
            svg.setStrokeColor(color.toSvg(mapper));
        }
    }
}

