/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.teavm;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import net.sourceforge.plantuml.DefinitionsContainer;
import net.sourceforge.plantuml.activitydiagram.ActivityDiagramFactory;
import net.sourceforge.plantuml.activitydiagram3.ActivityDiagramFactory3;
import net.sourceforge.plantuml.api.PSystemFactory;
import net.sourceforge.plantuml.chart.ChartDiagramFactory;
import net.sourceforge.plantuml.classdiagram.ClassDiagramFactory;
import net.sourceforge.plantuml.core.Diagram;
import net.sourceforge.plantuml.core.DiagramType;
import net.sourceforge.plantuml.core.UmlSource;
import net.sourceforge.plantuml.descdiagram.DescriptionDiagramFactory;
import net.sourceforge.plantuml.ebnf.PSystemEbnfFactory;
import net.sourceforge.plantuml.error.PSystemError;
import net.sourceforge.plantuml.error.PSystemErrorUtils;
import net.sourceforge.plantuml.error.PSystemUnsupported;
import net.sourceforge.plantuml.jaws.Jaws;
import net.sourceforge.plantuml.jsondiagram.JsonDiagramFactory;
import net.sourceforge.plantuml.klimt.creole.legacy.PSystemCreoleFactory;
import net.sourceforge.plantuml.mindmap.MindMapDiagramFactory;
import net.sourceforge.plantuml.nio.PathSystem;
import net.sourceforge.plantuml.nwdiag.NwDiagramFactory;
import net.sourceforge.plantuml.packetdiag.PacketDiagramFactory;
import net.sourceforge.plantuml.preproc.Defines;
import net.sourceforge.plantuml.preproc.PreprocessingArtifact;
import net.sourceforge.plantuml.regexdiagram.PSystemRegexFactory;
import net.sourceforge.plantuml.sequencediagram.SequenceDiagramFactory;
import net.sourceforge.plantuml.statediagram.StateDiagramFactory;
import net.sourceforge.plantuml.sudoku.PSystemSudokuFactory;
import net.sourceforge.plantuml.teavm.browser.BrowserLog;
import net.sourceforge.plantuml.text.StringLocated;
import net.sourceforge.plantuml.tim.TimLoader;
import net.sourceforge.plantuml.timingdiagram.TimingDiagramFactory;
import net.sourceforge.plantuml.utils.LineLocationImpl;
import net.sourceforge.plantuml.version.PSystemVersionFactory;
import net.sourceforge.plantuml.wbs.WBSDiagramFactory;
import net.sourceforge.plantuml.yaml.YamlDiagramFactory;

public class PSystemBuilder2 {
    private final List<PSystemFactory> factories = new ArrayList<PSystemFactory>();
    private PSystemFactory lastFactory;

    public PSystemBuilder2() {
        this.factories.add(new SequenceDiagramFactory());
        this.factories.add(new ClassDiagramFactory());
        this.factories.add(new ActivityDiagramFactory());
        this.factories.add(new DescriptionDiagramFactory());
        this.factories.add(new StateDiagramFactory());
        this.factories.add(new ActivityDiagramFactory3());
        this.factories.add(new PSystemVersionFactory());
        this.factories.add(new MindMapDiagramFactory());
        this.factories.add(new WBSDiagramFactory());
        this.factories.add(new NwDiagramFactory());
        this.factories.add(new PSystemSudokuFactory());
        this.factories.add(new PSystemCreoleFactory());
        this.factories.add(new TimingDiagramFactory());
        this.factories.add(new ChartDiagramFactory());
        this.factories.add(new PacketDiagramFactory());
        this.factories.add(new JsonDiagramFactory());
        this.factories.add(new YamlDiagramFactory());
        this.factories.add(new PSystemEbnfFactory());
        this.factories.add(new PSystemRegexFactory());
    }

    public Diagram createDiagram(String[] split) {
        Diagram sys;
        BrowserLog.consoleLog(PSystemBuilder2.class, "createDiagram start");
        ArrayList<StringLocated> rawSource = new ArrayList<StringLocated>();
        for (String s : this.clean(split)) {
            rawSource.add(new StringLocated(s, new LineLocationImpl("textarea", null)));
        }
        PathSystem pathSystem = PathSystem.fetch();
        Defines defines = Defines.createEmpty();
        Charset charset = StandardCharsets.UTF_8;
        DefinitionsContainer definitions = null;
        BrowserLog.consoleLog(PSystemBuilder2.class, "wip3");
        TimLoader timLoader = new TimLoader(pathSystem, defines, charset, definitions, (StringLocated)rawSource.get(0));
        BrowserLog.consoleLog(PSystemBuilder2.class, "wip4");
        timLoader.load(rawSource);
        BrowserLog.consoleLog(PSystemBuilder2.class, "createDiagram ok");
        List<StringLocated> tmp = timLoader.getResultList();
        tmp = Jaws.expands0(tmp);
        tmp = Jaws.expandsJawsForPreprocessor(tmp);
        UmlSource source = UmlSource.create(tmp, false);
        DiagramType diagramType = source.getDiagramType();
        PreprocessingArtifact preprocessing = new PreprocessingArtifact();
        ArrayList<PSystemError> errors = new ArrayList<PSystemError>();
        if (this.lastFactory != null && diagramType == this.lastFactory.getDiagramType() && this.isOk(sys = this.lastFactory.createSystem(null, source, null, preprocessing))) {
            return sys;
        }
        for (PSystemFactory f : this.factories) {
            if (diagramType != f.getDiagramType() || f == this.lastFactory) continue;
            BrowserLog.consoleLog(PSystemBuilder2.class, "trying " + String.valueOf(f.getClass()));
            Diagram sys2 = f.createSystem(null, source, null, preprocessing);
            if (this.isOk(sys2)) {
                BrowserLog.consoleLog(PSystemBuilder2.class, "ok!");
                this.lastFactory = f;
                return sys2;
            }
            errors.add((PSystemError)sys2);
        }
        if (errors.size() == 0) {
            return new PSystemUnsupported(source, preprocessing);
        }
        return PSystemErrorUtils.merge(errors);
    }

    private boolean isOk(Diagram ps) {
        return ps != null && !(ps instanceof PSystemError);
    }

    private List<String> clean(String[] tab) {
        ArrayList<String> lines = new ArrayList<String>();
        for (String s : tab) {
            lines.add(s);
        }
        while (lines.size() > 2 && ((String)lines.get(lines.size() - 1)).trim().isEmpty()) {
            lines.remove(lines.size() - 1);
        }
        return lines;
    }
}

