/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.tim;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sourceforge.plantuml.text.StringLocated;
import net.sourceforge.plantuml.text.TLineType;
import net.sourceforge.plantuml.tim.EaterException;
import net.sourceforge.plantuml.tim.TContext;
import net.sourceforge.plantuml.tim.TFunction;
import net.sourceforge.plantuml.tim.TFunctionArgument;
import net.sourceforge.plantuml.tim.TFunctionSignature;
import net.sourceforge.plantuml.tim.TFunctionType;
import net.sourceforge.plantuml.tim.TMemory;
import net.sourceforge.plantuml.tim.expression.TValue;
import net.sourceforge.plantuml.utils.LineLocation;

public class TFunctionImpl
implements TFunction {
    private final TFunctionSignature signature;
    private final List<TFunctionArgument> args;
    private final List<StringLocated> body = new ArrayList<StringLocated>();
    private final boolean unquoted;
    private TFunctionType functionType;
    private String legacyDefinition;
    private boolean containsReturn;

    public TFunctionImpl(String functionName, List<TFunctionArgument> args, boolean unquoted, TFunctionType functionType) {
        HashSet<String> names = new HashSet<String>();
        for (TFunctionArgument tmp : args) {
            names.add(tmp.getName());
        }
        this.signature = new TFunctionSignature(functionName, args.size(), names);
        this.args = args;
        this.unquoted = unquoted;
        this.functionType = functionType;
    }

    @Override
    public boolean canCover(int nbArg, Set<String> namedArguments) {
        for (String n : namedArguments) {
            if (this.signature.getNamedArguments().contains(n)) continue;
            return false;
        }
        if (nbArg > this.args.size()) {
            return false;
        }
        assert (nbArg <= this.args.size());
        int neededArgument = 0;
        for (TFunctionArgument arg : this.args) {
            if (namedArguments.contains(arg.getName()) || arg.getOptionalDefaultValue() != null) continue;
            ++neededArgument;
        }
        if (nbArg < neededArgument) {
            return false;
        }
        assert (nbArg >= neededArgument);
        return true;
    }

    private TMemory getNewMemory(TMemory memory, List<TValue> values, Map<String, TValue> namedArguments) {
        HashMap<String, TValue> result = new HashMap<String, TValue>();
        int ivalue = 0;
        for (TFunctionArgument arg : this.args) {
            TValue value;
            if (namedArguments.containsKey(arg.getName())) {
                value = namedArguments.get(arg.getName());
            } else if (ivalue < values.size()) {
                value = values.get(ivalue);
                ++ivalue;
            } else {
                value = arg.getOptionalDefaultValue();
            }
            if (value == null) {
                throw new IllegalStateException();
            }
            result.put(arg.getName(), value);
        }
        return memory.forkFromGlobal(result);
    }

    public String toString() {
        return "FUNCTION " + String.valueOf(this.signature) + " " + String.valueOf(this.args);
    }

    public void addBody(StringLocated s) throws EaterException {
        this.body.add(s);
        if (s.getType() == TLineType.RETURN) {
            this.containsReturn = true;
            if (this.functionType == TFunctionType.PROCEDURE) {
                throw new EaterException("A procedure cannot have !return directive. Declare it as a function instead ?", s);
            }
        }
    }

    @Override
    public void executeProcedureInternal(TContext context, TMemory memory, StringLocated location, List<TValue> args, Map<String, TValue> named) throws EaterException {
        if (this.functionType != TFunctionType.PROCEDURE && this.functionType != TFunctionType.LEGACY_DEFINELONG) {
            throw new IllegalStateException();
        }
        TMemory copy = this.getNewMemory(memory, args, named);
        context.executeLines(copy, this.body, TFunctionType.PROCEDURE, false);
    }

    @Override
    public TValue executeReturnFunction(TContext context, TMemory memory, StringLocated location, List<TValue> args, Map<String, TValue> named) throws EaterException {
        if (this.functionType == TFunctionType.LEGACY_DEFINE) {
            return this.executeReturnLegacyDefine(location.getLocation(), context, memory, args);
        }
        if (this.functionType != TFunctionType.RETURN_FUNCTION) {
            throw new EaterException("Illegal call here. Is there a return directive in your function?", location);
        }
        TMemory copy = this.getNewMemory(memory, args, named);
        TValue result = context.executeLines(copy, this.body, TFunctionType.RETURN_FUNCTION, true);
        if (result == null) {
            throw new EaterException("No return directive found in your function", location);
        }
        return result;
    }

    private TValue executeReturnLegacyDefine(LineLocation location, TContext context, TMemory memory, List<TValue> args) throws EaterException {
        if (this.legacyDefinition == null) {
            throw new IllegalStateException();
        }
        TMemory copy = this.getNewMemory(memory, args, Collections.emptyMap());
        String tmp = context.applyFunctionsAndVariables(copy, new StringLocated(this.legacyDefinition, location));
        if (tmp == null) {
            return TValue.fromString("");
        }
        return TValue.fromString(tmp);
    }

    @Override
    public final TFunctionType getFunctionType() {
        return this.functionType;
    }

    @Override
    public final TFunctionSignature getSignature() {
        return this.signature;
    }

    public void setLegacyDefinition(String legacyDefinition) {
        this.legacyDefinition = legacyDefinition;
    }

    @Override
    public boolean isUnquoted() {
        return this.unquoted;
    }

    public boolean hasBody() {
        return this.body.size() > 0;
    }

    public void finalizeEnddefinelong() {
        if (this.functionType != TFunctionType.LEGACY_DEFINELONG) {
            throw new UnsupportedOperationException();
        }
        if (this.body.size() == 1) {
            this.functionType = TFunctionType.LEGACY_DEFINE;
            this.legacyDefinition = this.body.get(0).getString();
        }
    }

    public final boolean doesContainReturn() {
        return this.containsReturn;
    }
}

