/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.utils;

import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import net.sourceforge.plantuml.teavm.TeaVM;

public class I18n {
    public static String getLocalizedValue(String language, String key, String defaultValue) {
        if (TeaVM.isTeaVM()) {
            return defaultValue;
        }
        if (key == null) {
            throw new IllegalArgumentException("Key must not be null.");
        }
        if (defaultValue == null) {
            throw new IllegalArgumentException("defaultValue must not be null.");
        }
        if (language == null) {
            language = Locale.getDefault().getLanguage();
        }
        Locale locale = Locale.forLanguageTag(language);
        try {
            ResourceBundle bundle = ResourceBundle.getBundle("i18n", locale);
            return bundle.getString(key);
        }
        catch (MissingResourceException e) {
            return defaultValue;
        }
    }
}

