/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.wire;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.klimt.UTranslate;
import net.sourceforge.plantuml.klimt.color.HColor;
import net.sourceforge.plantuml.klimt.color.HColors;
import net.sourceforge.plantuml.klimt.creole.Display;
import net.sourceforge.plantuml.klimt.drawing.UGraphic;
import net.sourceforge.plantuml.klimt.font.FontConfiguration;
import net.sourceforge.plantuml.klimt.font.StringBounder;
import net.sourceforge.plantuml.klimt.font.UFont;
import net.sourceforge.plantuml.klimt.font.UFontFactory;
import net.sourceforge.plantuml.klimt.geom.HorizontalAlignment;
import net.sourceforge.plantuml.klimt.geom.XDimension2D;
import net.sourceforge.plantuml.klimt.shape.TextBlock;
import net.sourceforge.plantuml.klimt.shape.URectangle;
import net.sourceforge.plantuml.klimt.sprite.SpriteContainerEmpty;
import net.sourceforge.plantuml.style.ISkinParam;
import net.sourceforge.plantuml.wire.WLinkType;
import net.sourceforge.plantuml.wire.WPrint;

public class WBlock {
    private static final int STARTING_Y = 10;
    private final String name;
    private final double forcedWidth;
    private final double forcedHeight;
    private final HColor color;
    private final List<WBlock> children = new ArrayList<WBlock>();
    private final UTranslate position;
    private WBlock parent;
    private UTranslate cursor = new UTranslate(10.0, 10.0);
    private WBlock addedToCursor = null;
    private UTranslate futureOutHorizontal;
    private UTranslate futureOutVertical;
    private final List<WPrint> prints = new ArrayList<WPrint>();

    public UTranslate getAbsolutePosition(String supx, String supy) {
        if (this.parent == null) {
            return this.position;
        }
        UTranslate p = this.parent.getAbsolutePosition("0", "0");
        double x = this.position.getDx() + p.getDx() + this.parseWidth(supx);
        double y = this.position.getDy() + p.getDy() + this.parseHeight(supy);
        return new UTranslate(x, y);
    }

    private double parseWidth(String value) {
        if (value.endsWith("%")) {
            double p = Double.parseDouble(value.substring(0, value.length() - 1)) / 100.0;
            return this.getMaxDimension().getWidth() * p;
        }
        if (value.contains("%")) {
            StringTokenizer st = new StringTokenizer(value, "%");
            String v1 = st.nextToken();
            String v2 = st.nextToken();
            double p = Double.parseDouble(v1) / 100.0;
            return this.getMaxDimension().getWidth() * p + Double.parseDouble(v2);
        }
        return Double.parseDouble(value);
    }

    private double parseHeight(String value) {
        if (value.endsWith("%")) {
            double p = Double.parseDouble(value.substring(0, value.length() - 1)) / 100.0;
            return this.getMaxDimension().getHeight() * p;
        }
        if (value.contains("%")) {
            StringTokenizer st = new StringTokenizer(value, "%");
            String v1 = st.nextToken();
            String v2 = st.nextToken();
            double p = Double.parseDouble(v1) / 100.0;
            return this.getMaxDimension().getHeight() * p + Double.parseDouble(v2);
        }
        return Double.parseDouble(value);
    }

    public String toString() {
        return this.name + " " + String.valueOf(this.position);
    }

    public WBlock(String name, UTranslate position, double width, double height, HColor color) {
        this.name = name;
        this.forcedWidth = width;
        this.forcedHeight = height;
        this.color = color;
        this.position = position;
    }

    private WBlock getChildByName(String name) {
        for (WBlock child : this.children) {
            if (!name.equals(child.getName())) continue;
            return child;
        }
        return null;
    }

    public WBlock getBlock(String name) {
        int x = name.indexOf(46);
        if (x == -1) {
            return this.getChildByName(name);
        }
        WBlock first = this.getChildByName(name.substring(0, x));
        if (first == null) {
            return null;
        }
        return first.getBlock(name.substring(x + 1));
    }

    private String getName() {
        return this.name;
    }

    public CommandExecutionResult newColumn(int level) {
        if (level == 0) {
            XDimension2D max = this.getNaturalDimension();
            this.cursor = new UTranslate(max.getWidth() + 10.0, 10.0);
            this.addedToCursor = null;
            return CommandExecutionResult.ok();
        }
        return this.getLastChild().newColumn(level - 1);
    }

    public CommandExecutionResult wgoto(int level, double x, double y) {
        if (level == 0) {
            this.cursor = new UTranslate(x, y);
            this.addedToCursor = null;
            return CommandExecutionResult.ok();
        }
        return this.getLastChild().wgoto(level - 1, x, y);
    }

    public CommandExecutionResult wmove(int level, double x, double y) {
        if (level == 0) {
            this.cursor = this.cursor.compose(new UTranslate(x, y));
            return CommandExecutionResult.ok();
        }
        return this.getLastChild().wmove(level - 1, x, y);
    }

    public CommandExecutionResult print(StringBounder stringBounder, ISkinParam skinParam, int level, String text) {
        if (level == 0) {
            WPrint print = new WPrint(skinParam, this.getNextPosition(), null, Display.getWithNewlines(skinParam.getPragma(), text));
            this.prints.add(print);
            this.cursor = this.cursor.compose(UTranslate.dy(print.getHeight(stringBounder)));
            return CommandExecutionResult.ok();
        }
        return this.getLastChild().print(stringBounder, skinParam, level - 1, text);
    }

    public CommandExecutionResult addBlock(int level, String name, double width, double height, HColor color) {
        if (name.contains(".")) {
            throw new IllegalArgumentException();
        }
        if (this.getChildByName(name) != null) {
            return CommandExecutionResult.error("Component exists already");
        }
        if (level == 0) {
            this.cursor = this.cursor.compose(UTranslate.dy(10.0));
            WBlock newBlock = new WBlock(name, this.getNextPosition(), width, height, color);
            this.cursor = this.cursor.compose(UTranslate.dy(10.0));
            this.addedToCursor = newBlock;
            this.children.add(newBlock);
            newBlock.parent = this;
            return CommandExecutionResult.ok();
        }
        WBlock last = this.getLastChild();
        return last.addBlock(level - 1, name, width, height, color);
    }

    private UTranslate getNextPosition() {
        if (this.addedToCursor != null) {
            XDimension2D dim = this.addedToCursor.getMaxDimension();
            this.cursor = this.cursor.compose(UTranslate.dy(dim.getHeight()));
        }
        this.addedToCursor = null;
        return this.cursor;
    }

    private WBlock getLastChild() {
        if (this.children.size() == 0) {
            return null;
        }
        return this.children.get(this.children.size() - 1);
    }

    public void drawMe(UGraphic ug) {
        this.drawBox(ug);
        UFont font = UFontFactory.sansSerif(12);
        FontConfiguration fc = FontConfiguration.create(font, this.getBlack(), this.getBlack(), null);
        Display display = Display.create(this.name.replace('_', ' '));
        TextBlock text = display.create(fc, HorizontalAlignment.LEFT, new SpriteContainerEmpty());
        text.drawU(ug.apply(UTranslate.dx(5.0)));
    }

    private HColor getBlack() {
        return HColors.BLACK.withDark(HColors.WHITE);
    }

    private void drawBox(UGraphic ug) {
        ug = ug.apply(this.getBlack());
        if (this.name.length() > 0) {
            URectangle rect = URectangle.build(this.getMaxDimension());
            UGraphic ugRect = ug;
            if (this.color != null) {
                ugRect = ugRect.apply(this.color.bg());
            }
            ugRect.draw(rect);
        }
        for (WBlock child : this.children) {
            child.drawMe(ug.apply(child.position));
        }
        for (WPrint print : this.prints) {
            print.drawMe(ug.apply(print.getPosition()));
        }
    }

    private XDimension2D getMaxDimension() {
        if (this.children.size() > 0) {
            if (this.forcedWidth != 0.0) {
                return new XDimension2D(this.forcedWidth, this.forcedHeight);
            }
            return this.getNaturalDimension();
        }
        double x = this.forcedWidth == 0.0 ? 100.0 : this.forcedWidth;
        double y = this.forcedHeight == 0.0 ? 100.0 : this.forcedHeight;
        return new XDimension2D(x, y);
    }

    private XDimension2D getNaturalDimension() {
        double x = 0.0;
        double y = 0.0;
        for (WBlock child : this.children) {
            XDimension2D dim = child.getMaxDimension();
            x = Math.max(x, child.position.getDx() + dim.getWidth() + 10.0);
            y = Math.max(y, child.position.getDy() + dim.getHeight() + 10.0);
        }
        return new XDimension2D(x, y);
    }

    public UTranslate getNextOutHorizontal(String x, String y, WLinkType type) {
        UTranslate result = x != null && y != null ? this.getAbsolutePosition(x, y) : (this.futureOutHorizontal == null ? this.getAbsolutePosition("100%", "5") : this.futureOutHorizontal);
        this.futureOutHorizontal = result.compose(UTranslate.dy(type.spaceForNext()));
        return result;
    }

    public UTranslate getNextOutVertical(String x, String y, WLinkType type) {
        UTranslate result = x != null && y != null ? this.getAbsolutePosition(x, y) : (this.futureOutVertical == null ? this.getAbsolutePosition("5", "100%") : this.futureOutVertical);
        this.futureOutVertical = result.compose(UTranslate.dx(type.spaceForNext()));
        return result;
    }
}

