/*
 * Decompiled with CFR 0.152.
 */
package dotty.tools.dotc.classpath;

import dotty.tools.dotc.classpath.BinaryFileEntry;
import dotty.tools.dotc.classpath.ClassFileEntry$;
import dotty.tools.dotc.classpath.ClassPathEntries;
import dotty.tools.dotc.classpath.ClassPathEntries$;
import dotty.tools.dotc.classpath.NoSourcePaths;
import dotty.tools.dotc.classpath.PackageEntry;
import dotty.tools.dotc.classpath.PackageEntryImpl$;
import dotty.tools.dotc.classpath.PackageName;
import dotty.tools.dotc.classpath.PackageNameUtils$;
import dotty.tools.dotc.classpath.SourceFileEntry;
import dotty.tools.io.AbstractFile;
import dotty.tools.io.ClassPath;
import dotty.tools.io.ClassPath$;
import dotty.tools.io.ClassRepresentation;
import dotty.tools.io.PlainFile;
import dotty.tools.io.PlainFile$;
import java.io.Serializable;
import java.net.URL;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.IterableOnce;
import scala.collection.Iterator;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Growable;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashMap$;
import scala.collection.mutable.ListBuffer;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.Scala3RunTime$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;

public final class CtSymClassPath
implements ClassPath,
NoSourcePaths {
    private final String releaseCode;
    private final Map<String, Seq<Path>> packageIndex;

    public CtSymClassPath(Path ctSym, int release) {
        FileSystem fileSystem = FileSystems.newFileSystem(ctSym, null);
        Path root2 = fileSystem.getRootDirectories().iterator().next();
        List roots = CollectionConverters$.MODULE$.IteratorHasAsScala(Files.newDirectoryStream(root2).iterator()).asScala().toList();
        this.releaseCode = this.codeFor(release);
        List rootsForRelease = roots.filter((Function1 & Serializable)root -> this.fileNameMatchesRelease(root.getFileName().toString()));
        HashMap index = (HashMap)HashMap$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
        rootsForRelease.foreach((Function1)(JProcedure1 & Serializable)root -> CollectionConverters$.MODULE$.IteratorHasAsScala(Files.walk(root, new FileVisitOption[0]).iterator()).asScala().filter((Function1 & Serializable)_$3 -> Files.isDirectory(_$3, new LinkOption[0])).foreach((Function1)(JProcedure1 & Serializable)p -> {
            if (p.getNameCount() > root.getNameCount() + 1) {
                String packageDotted = p.subpath(1 + root.getNameCount(), p.getNameCount()).toString().replace('/', '.');
                ((Growable)index.getOrElseUpdate((Object)packageDotted, CtSymClassPath::$init$$$anonfun$3$$anonfun$2$$anonfun$1)).$plus$eq(p);
                return;
            }
        }));
        this.packageIndex = index;
    }

    @Override
    public final boolean hasPackage(String pkg) {
        return ClassPath.hasPackage$(this, pkg);
    }

    @Override
    public final scala.collection.immutable.Seq<PackageEntry> packages(String inPackage) {
        return ClassPath.packages$(this, inPackage);
    }

    @Override
    public final scala.collection.immutable.Seq<BinaryFileEntry> classes(String inPackage) {
        return ClassPath.classes$(this, inPackage);
    }

    @Override
    public final scala.collection.immutable.Seq<SourceFileEntry> sources(String inPackage) {
        return ClassPath.sources$(this, inPackage);
    }

    @Override
    public final ClassPathEntries list(String inPackage) {
        return ClassPath.list$(this, inPackage);
    }

    @Override
    public String asClassPathString() {
        return ClassPath.asClassPathString$(this);
    }

    @Override
    public String asClasspathString() {
        return ClassPath.asClasspathString$(this);
    }

    @Override
    public String asSourcePathString() {
        return NoSourcePaths.asSourcePathString$(this);
    }

    @Override
    public scala.collection.immutable.Seq<SourceFileEntry> sources(PackageName inPackage) {
        return NoSourcePaths.sources$(this, inPackage);
    }

    private String codeFor(int major) {
        if (major < 10) {
            return BoxesRunTime.boxToInteger((int)major).toString();
        }
        return BoxesRunTime.boxToCharacter((char)((char)(65 + (major - 10)))).toString();
    }

    private boolean fileNameMatchesRelease(String fileName) {
        return !fileName.contains("-") && fileName.contains(this.releaseCode);
    }

    @Override
    public boolean hasPackage(PackageName pkg) {
        return this.packageIndex.contains((Object)pkg.dottedString());
    }

    @Override
    public scala.collection.immutable.Seq<PackageEntry> packages(PackageName inPackage) {
        return this.packageIndex.keysIterator().filter((Function1 & Serializable)pack -> PackageNameUtils$.MODULE$.packageContains(inPackage.dottedString(), (String)pack)).map((Function1 & Serializable)_$4 -> PackageEntryImpl$.MODULE$.apply((String)_$4)).toVector();
    }

    @Override
    public scala.collection.immutable.Seq<BinaryFileEntry> classes(PackageName inPackage) {
        Nil$ nil$;
        if (inPackage.isRoot()) {
            nil$ = package$.MODULE$.Nil();
        } else {
            Iterator sigFiles = ((IterableOnce)this.packageIndex.getOrElse((Object)inPackage.dottedString(), CtSymClassPath::$anonfun$3)).iterator().flatMap((Function1 & Serializable)p -> CollectionConverters$.MODULE$.IteratorHasAsScala(Files.list(p).iterator()).asScala().filter((Function1 & Serializable)_$5 -> _$5.getFileName().toString().endsWith(".sig")));
            nil$ = sigFiles.map((Function1 & Serializable)f -> ClassFileEntry$.MODULE$.apply(PlainFile$.MODULE$.toPlainFile((Path)f))).toVector();
        }
        return (scala.collection.immutable.Seq)nil$;
    }

    @Override
    public ClassPathEntries list(PackageName inPackage) {
        if (inPackage.isRoot()) {
            return ClassPathEntries$.MODULE$.apply((Seq<PackageEntry>)this.packages(inPackage), (Seq<ClassRepresentation>)package$.MODULE$.Nil());
        }
        return ClassPathEntries$.MODULE$.apply((Seq<PackageEntry>)this.packages(inPackage), (Seq<ClassRepresentation>)this.classes(inPackage));
    }

    @Override
    public scala.collection.immutable.Seq<URL> asURLs() {
        return package$.MODULE$.Nil();
    }

    @Override
    public scala.collection.immutable.Seq<String> asClassPathStrings() {
        return package$.MODULE$.Nil();
    }

    @Override
    public Option<AbstractFile> findClassFile(String className) {
        Tuple2 tuple2;
        Tuple2 $1$;
        Tuple2 tuple22;
        if (!className.contains(".")) {
            return None$.MODULE$;
        }
        int lastDotIndex = className.lastIndexOf(46);
        if (lastDotIndex == -1) {
            tuple22 = Tuple2$.MODULE$.apply((Object)ClassPath$.MODULE$.RootPackage(), (Object)className);
        } else {
            String x$proxy3 = className.substring(0, lastDotIndex);
            if (x$proxy3 == null) {
                throw Scala3RunTime$.MODULE$.nnFail();
            }
            String x$proxy4 = className.substring(lastDotIndex + 1);
            if (x$proxy4 == null) {
                throw Scala3RunTime$.MODULE$.nnFail();
            }
            tuple22 = Tuple2$.MODULE$.apply((Object)x$proxy3, (Object)x$proxy4);
        }
        Tuple2 tuple23 = $1$ = (tuple2 = tuple22);
        String inPackage = (String)tuple23._1();
        String classSimpleName = (String)tuple23._2();
        return ((IterableOnce)this.packageIndex.getOrElse((Object)inPackage, CtSymClassPath::findClassFile$$anonfun$3)).iterator().flatMap((Function1 & Serializable)p -> {
            Path path = p.resolve(classSimpleName + ".sig");
            if (Files.exists(path, new LinkOption[0])) {
                PlainFile plainFile = PlainFile$.MODULE$.toPlainFile(path);
                return package$.MODULE$.Nil().$colon$colon((Object)plainFile);
            }
            return package$.MODULE$.Nil();
        }).take(1).toList().headOption();
    }

    private static final ListBuffer $init$$$anonfun$3$$anonfun$2$$anonfun$1() {
        return new ListBuffer();
    }

    private static final Seq $anonfun$3() {
        return package$.MODULE$.Nil();
    }

    private static final Seq findClassFile$$anonfun$3() {
        return package$.MODULE$.Nil();
    }
}

