/*
 * Decompiled with CFR 0.152.
 */
package dotty.tools.dotc.transform;

import dotty.tools.dotc.config.Feature$;
import dotty.tools.dotc.core.Annotations;
import dotty.tools.dotc.core.Contexts;
import dotty.tools.dotc.core.Decorators$;
import dotty.tools.dotc.core.Flags$;
import dotty.tools.dotc.core.Symbols;
import dotty.tools.dotc.core.Symbols$;
import dotty.tools.dotc.printing.Formatting$ShownDef$Show$;
import dotty.tools.dotc.printing.Formatting$ShownDef$Shown$;
import dotty.tools.dotc.report$;
import dotty.tools.dotc.reporting.NoExplanation;
import dotty.tools.dotc.util.SrcPos;
import java.io.Serializable;
import scala.Function1;
import scala.Option;
import scala.Some;
import scala.StringContext$;
import scala.collection.immutable.Seq;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;

public final class CrossVersionChecks$
implements Serializable {
    private static final String name;
    private static final String description;
    public static final CrossVersionChecks$ MODULE$;

    private CrossVersionChecks$() {
    }

    static {
        MODULE$ = new CrossVersionChecks$();
        name = "crossVersionChecks";
        description = "check issues related to deprecated and experimental";
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(CrossVersionChecks$.class);
    }

    public String name() {
        return name;
    }

    public String description() {
        return description;
    }

    public void checkRef(Symbols.Symbol sym, SrcPos pos, Contexts.Context x$3) {
        this.checkDeprecatedRef(sym, pos, x$3);
        this.checkExperimentalRef(sym, pos, x$3);
        this.checkPreviewFeatureRef(sym, pos, x$3);
    }

    public void checkExperimentalRef(Symbols.Symbol sym, SrcPos pos, Contexts.Context x$3) {
        if (Symbols$.MODULE$.isExperimental(sym, x$3) && !Symbols$.MODULE$.isInExperimentalScope(x$3.owner(), x$3)) {
            Feature$.MODULE$.checkExperimentalDef(sym, pos, x$3);
            return;
        }
    }

    public void checkPreviewFeatureRef(Symbols.Symbol sym, SrcPos pos, Contexts.Context x$3) {
        if (Symbols$.MODULE$.isPreview(sym, x$3) && !Symbols$.MODULE$.isInPreviewScope(x$3.owner(), x$3)) {
            Feature$.MODULE$.checkPreviewDef(sym, pos, x$3);
            return;
        }
    }

    public void checkDeprecatedRef(Symbols.Symbol sym, SrcPos pos, Contexts.Context x$3) {
        Option<Annotations.Annotation> option = Symbols$.MODULE$.toDenot(sym, x$3).getAnnotation(Symbols$.MODULE$.defn(x$3).DeprecatedAnnot(), x$3);
        if (option instanceof Some) {
            Some some = (Some)option;
            Annotations.Annotation annot2 = (Annotations.Annotation)some.value();
            if (!this.dotty$tools$dotc$transform$CrossVersionChecks$$$skipWarning(sym, x$3)) {
                this.warn$1(x$3, pos, sym, annot2);
                return;
            }
            return;
        }
        if (Symbols$.MODULE$.toDenot(sym, x$3).isAllOf(Flags$.MODULE$.SyntheticMethod(), x$3)) {
            Symbols.Symbol companion = Symbols$.MODULE$.toDenot(Symbols$.MODULE$.toDenot(sym, x$3).owner(), x$3).companionClass(x$3);
            if (Symbols$.MODULE$.toDenot(companion, x$3).is(Flags$.MODULE$.CaseClass(), x$3)) {
                Symbols$.MODULE$.toDenot(companion, x$3).getAnnotation(Symbols$.MODULE$.defn(x$3).DeprecatedAnnot(), x$3).withFilter((Function1 & Serializable)annot -> !MODULE$.dotty$tools$dotc$transform$CrossVersionChecks$$$skipWarning(sym, x$3)).foreach((Function1)(JProcedure1 & Serializable)annot -> this.warn$1(x$3, pos, companion, (Annotations.Annotation)annot));
                return;
            }
            return;
        }
    }

    public boolean dotty$tools$dotc$transform$CrossVersionChecks$$$skipWarning(Symbols.Symbol sym, Contexts.Context x$2) {
        return this.siteIsSyntheticCaseClassMember$1(x$2, sym) || this.siteIsEnclosedByDeprecatedElement$1(x$2, sym);
    }

    private static final String $anonfun$8() {
        return "";
    }

    private static final String $anonfun$11() {
        return "";
    }

    private final void warn$1(Contexts.Context x$3$1, SrcPos pos$2, Symbols.Symbol annotee, Annotations.Annotation annot) {
        String message = (String)annot.argumentConstantString(0, x$3$1).filter((Function1 & Serializable)_$2 -> !_$2.isEmpty()).map((Function1 & Serializable)_$3 -> ": " + _$3).getOrElse(CrossVersionChecks$::$anonfun$8);
        String since = (String)annot.argumentConstantString(1, x$3$1).filter((Function1 & Serializable)_$4 -> !_$4.isEmpty()).map((Function1 & Serializable)_$5 -> " since " + _$5).getOrElse(CrossVersionChecks$::$anonfun$11);
        NoExplanation composed = Decorators$.MODULE$.em(StringContext$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"", " is deprecated", "", ""})), (Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{Formatting$ShownDef$Shown$.MODULE$.given_Conversion_A_Shown(Formatting$ShownDef$Show$.MODULE$.given_Show_String()).apply((Object)annotee.showLocated(x$3$1)), Formatting$ShownDef$Shown$.MODULE$.given_Conversion_A_Shown(Formatting$ShownDef$Show$.MODULE$.given_Show_String()).apply((Object)since), Formatting$ShownDef$Shown$.MODULE$.given_Conversion_A_Shown(Formatting$ShownDef$Show$.MODULE$.given_Show_String()).apply((Object)message)}), x$3$1);
        report$.MODULE$.deprecationWarning(composed, pos$2, annotee.showFullName(x$3$1), x$3$1);
    }

    private final boolean isEnumOwner$1(Symbols.Symbol sym$3, Symbols.Symbol owner, Contexts.Context x$2) {
        if (Symbols$.MODULE$.isEnumClass(owner, x$2)) {
            return Symbols$.MODULE$.toDenot(owner, x$2).companionClass(x$2) == Symbols$.MODULE$.toDenot(sym$3, x$2).owner();
        }
        if (Symbols$.MODULE$.toDenot(owner, x$2).is(Flags$.MODULE$.ModuleClass(), x$2) && Symbols$.MODULE$.isEnumClass(Symbols$.MODULE$.toDenot(owner, x$2).companionClass(x$2), x$2)) {
            return owner == Symbols$.MODULE$.toDenot(sym$3, x$2).owner();
        }
        return false;
    }

    private final boolean isDeprecatedOrEnum$1(Symbols.Symbol sym$9, Symbols.Symbol owner, Contexts.Context x$2) {
        return Symbols$.MODULE$.isDeprecated(owner, x$2) || this.isEnumOwner$1(sym$9, owner, x$2);
    }

    private final boolean siteIsEnclosedByDeprecatedElement$1(Contexts.Context x$2$12, Symbols.Symbol sym$4) {
        return Symbols$.MODULE$.toDenot(x$2$12.owner(), x$2$12).ownersIterator(x$2$12).exists((Function1)(Symbols$.MODULE$.isEnumCase(sym$4, x$2$12) ? (Function1 & Serializable)owner -> this.isDeprecatedOrEnum$1(sym$4, (Symbols.Symbol)owner, x$2$12) : (Function1 & Serializable)_$6 -> Symbols$.MODULE$.isDeprecated((Symbols.Symbol)_$6, x$2$12)));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean checkSym$1(Symbols.Symbol sym$8, Contexts.Context x$2$17, Symbols.Symbol k) {
        Symbols.Symbol symbol = sym$8;
        Symbols.Symbol symbol2 = k;
        if (symbol == null) {
            if (symbol2 == null) return true;
        } else if (symbol.equals(symbol2)) return true;
        Symbols.Symbol symbol3 = Symbols$.MODULE$.toDenot(sym$8, x$2$17).owner();
        Symbols.Symbol symbol4 = k;
        if (symbol3 != null) {
            if (!symbol3.equals(symbol4)) return false;
            return true;
        }
        if (symbol4 == null) return true;
        return false;
    }

    private final boolean symIsCaseOrMember$1(Symbols.Symbol owner$1, Contexts.Context x$2$16, Symbols.Symbol sym$7) {
        Symbols.Symbol enclosing = Symbols$.MODULE$.toDenot(owner$1, x$2$16).enclosingClass(x$2$16);
        Symbols.Symbol companion = Symbols$.MODULE$.toDenot(enclosing, x$2$16).companionClass(x$2$16);
        return !(!Symbols$.MODULE$.toDenot(enclosing, x$2$16).is(Flags$.MODULE$.CaseClass(), x$2$16) && !Symbols$.MODULE$.toDenot(companion, x$2$16).is(Flags$.MODULE$.CaseClass(), x$2$16) || !this.checkSym$1(sym$7, x$2$16, enclosing) && !this.checkSym$1(sym$7, x$2$16, companion));
    }

    private final boolean siteIsSyntheticCaseClassMember$1(Contexts.Context x$2$15, Symbols.Symbol sym$6) {
        Symbols.Symbol owner = x$2$15.owner();
        return Symbols$.MODULE$.toDenot(owner, x$2$15).is(Flags$.MODULE$.Synthetic(), x$2$15) && this.symIsCaseOrMember$1(owner, x$2$15, sym$6);
    }
}

