#!/data/data/com.termux/files/usr/bin/sh

# Copyright 1994 David Carlisle
# This file may be redistributed and/or modified under the terms of the
# LaTeX Project Public License distributed from CTAN archives in directory
# macros/latex/base/lppl.txt; either version 1 of the License, or (at
# your option) any later version.

test -f /bin/sh5 && test -z "$RUNNING_SH5" \
  && { UNAMES=`uname -s`; test "x$UNAMES" = xULTRIX; } 2>/dev/null \
  && { RUNNING_SH5=true; export RUNNING_SH5; exec /bin/sh5 $0 ${1+"$@"}; }
unset RUNNING_SH5

test -f /bin/bsh && test -z "$RUNNING_BSH" \
  && { UNAMES=`uname -s`; test "x$UNAMES" = xAIX; } 2>/dev/null \
  && { RUNNING_BSH=true; export RUNNING_BSH; exec /bin/bsh $0 ${1+"$@"}; }
unset RUNNING_BSH

# hack around a bug in zsh:
test -n "${ZSH_VERSION+set}" && alias -g '${1+"$@"}'='"$@"'

# we want to be able to use options to latex:
while :; do
  case $1 in
    -*)
      latexoptions="$latexoptions \"$1\""
      shift;;
    *)
      break;;
  esac
done

echo
echo "*************************************"
echo "* Using LaTeX, with pslatex package *"
echo "*************************************"
echo

# messing around with \PSLATEXTMP is for AUCTeX which calls
# documents via latex \nonstopmode \input{file}

latex $latexoptions \
    "\AtBeginDocument{\RequirePackage{pslatex}}"\
    "\def\PSLATEXTMP{\futurelet\PSLATEXTMP\PSLATEXTMPB}"\
    "\def\PSLATEXTMPB{\ifx\PSLATEXTMP\nonstopmode\else\input\fi}"\
    "\PSLATEXTMP" ${1+"$@"}
