/**
 * Copyright (C) 2011-2020 Aratelia Limited - Juan A. Rubio and contributors and
 * contributors
 *
 * This file is part of Tizonia
 *
 * Tizonia is free software: you can redistribute it and/or modify it under the
 * terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation, either version 3 of the License, or (at your option)
 * any later version.
 *
 * Tizonia is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for
 * more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with Tizonia.  If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * @file   tizgmusic.hpp
 * @author Juan A. Rubio <juan.rubio@aratelia.com>
 *
 * @brief  Tizonia - Simple Google Play Music client library
 *
 *
 */

#ifndef TIZGMUSIC_HPP
#define TIZGMUSIC_HPP

#include <boost/python.hpp>

#include <string>

class tizgmusic
{
public:
  /**
   * Various playback modes that control the playback queue.
   */
  enum playback_mode
  {
    PlaybackModeNormal,
    PlaybackModeShuffle,
    PlaybackModeMax
  };

public:
  tizgmusic (const std::string &user, const std::string &pass,
             const std::string &device_id);
  ~tizgmusic ();

  int init ();
  int start ();
  void stop ();
  void deinit ();

  int play_library ();
  int play_tracks (const std::string &tracks, const bool a_unlimited_search);
  int play_album (const std::string &album, const bool a_unlimited_search);
  int play_artist (const std::string &artist, const bool a_unlimited_search);
  int play_playlist (const std::string &playlist,
                     const bool a_unlimited_search);
  int play_free_station (const std::string &station);
  int play_station (const std::string &station);
  int play_genre (const std::string &genre);
  int play_situation (const std::string &situation,
                      const std::string &additional_keywords);
  int play_podcast (const std::string &podcast);
  int play_promoted_tracks ();

  void clear_queue ();
  void print_queue ();

  const char *get_current_track_index ();
  const char *get_current_queue_length ();
  int get_current_queue_length_as_int ();
  const char *get_current_queue_progress ();
  void set_playback_mode (const playback_mode mode);

  const char *get_url (const int a_position);
  const char *get_next_url ();
  const char *get_prev_url ();
  const char *get_current_track_artist ();
  const char *get_current_track_title ();
  const char *get_current_track_album ();
  const char *get_current_track_duration ();
  const char *get_current_track_track_number ();
  const char *get_current_track_tracks_in_album ();
  const char *get_current_track_year ();
  const char *get_current_track_genre ();
  const char *get_current_track_album_art ();

private:
  void get_current_track ();
  void get_current_track_queue_index_and_length (int &index, int &length);

private:
  std::string user_;
  std::string pass_;
  std::string device_id_;
  std::string current_url_;
  std::string current_track_index_;
  std::string current_queue_length_;
  int current_queue_length_as_int_;
  std::string current_artist_;
  std::string current_title_;
  std::string current_album_;
  std::string current_duration_;
  std::string current_track_num_;
  std::string current_track_tracks_total_;
  std::string current_track_year_;
  std::string current_track_genre_;
  std::string current_track_album_art_;
  std::string current_queue_progress_;
  boost::python::object py_main_;
  boost::python::object py_global_;
  boost::python::object py_gm_proxy_;
};

#endif  // TIZGMUSIC_HPP
