#!/data/data/com.termux/files/usr/bin/sh
# Example for use of GNU gettext.
# This file is in the public domain.
#
# Script for regenerating all autogenerated files.

if test -r ../Makefile.am || test -r ../Makefile; then
  if test -r ../Makefile.am; then
    # Inside the gettext source directory.
    GETTEXT_TOPSRCDIR=../../..
  else
    # Inside a gettext build directory.
    GETTEXT_TOOLS_SRCDIR=`sed -n -e 's,^top_srcdir *= *\(.*\)$,\1,p' ../Makefile`
    # Adjust a relative top_srcdir.
    case $GETTEXT_TOOLS_SRCDIR in
      /*) ;;
      *) GETTEXT_TOOLS_SRCDIR=../$GETTEXT_TOOLS_SRCDIR ;;
    esac
    GETTEXT_TOPSRCDIR=$GETTEXT_TOOLS_SRCDIR/../..
  fi
  { echo "m2includedir = "`cd $GETTEXT_TOPSRCDIR/gettext-runtime/intl-modula2 && pwd`;
    echo "m2libdir = "`cd $GETTEXT_TOPSRCDIR/gettext-runtime/intl-modula2/.libs && pwd`;
  } > m2dirs.mk
else
  # Installed under ${prefix}/share/doc/gettext/examples.
  . ../installpaths
  { echo "m2includedir = ${includedir}/m2";
    echo "m2libdir = ${libdir}";
  } > m2dirs.mk
fi

autopoint -f # was: gettextize -f -c
rm po/Makefile.in.in
rm po/Makevars.template
rm po/Rules-quot
rm po/boldquot.sed
rm po/en@boldquot.header
rm po/en@quot.header
rm po/insert-header.sed
rm po/quot.sed

cp -p ${EXAMPLESCONFIGDIR-$GETTEXT_TOPSRCDIR/gettext-tools/gnulib-m4}/modula2comp.m4 m4/modula2comp.m4

aclocal -I m4

autoconf

automake -a -c

rm -rf autom4te.cache

cd po
for f in *.po; do
  if test -r "$f"; then
    lang=`echo $f | sed -e 's,\.po$,,'`
    msgfmt -c -o $lang.gmo $lang.po
  fi
done
cd ..
