/*
 * Decompiled with CFR 0.152.
 */
package com.android.dx.rop.type;

import com.android.dx.rop.type.StdTypeList;
import com.android.dx.rop.type.Type;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public final class Prototype
implements Comparable<Prototype> {
    private static final ConcurrentMap<String, Prototype> internTable = new ConcurrentHashMap<String, Prototype>(10000, 0.75f);
    private final String descriptor;
    private final Type returnType;
    private final StdTypeList parameterTypes;
    private StdTypeList parameterFrameTypes;

    public static Prototype intern(String descriptor2) {
        if (descriptor2 == null) {
            throw new NullPointerException("descriptor == null");
        }
        Prototype result = (Prototype)internTable.get(descriptor2);
        if (result != null) {
            return result;
        }
        result = Prototype.fromDescriptor(descriptor2);
        return Prototype.putIntern(result);
    }

    public static Prototype fromDescriptor(String descriptor2) {
        Prototype result = (Prototype)internTable.get(descriptor2);
        if (result != null) {
            return result;
        }
        Type[] params = Prototype.makeParameterArray(descriptor2);
        int paramCount = 0;
        int at4 = 1;
        while (true) {
            int startAt = at4;
            char c15 = descriptor2.charAt(at4);
            if (c15 == ')') break;
            while (c15 == '[') {
                c15 = descriptor2.charAt(++at4);
            }
            if (c15 == 'L') {
                int endAt = descriptor2.indexOf(59, at4);
                if (endAt == -1) {
                    throw new IllegalArgumentException("bad descriptor");
                }
                at4 = endAt + 1;
            } else {
                ++at4;
            }
            params[paramCount] = Type.intern(descriptor2.substring(startAt, at4));
            ++paramCount;
        }
        Type returnType = Type.internReturnType(descriptor2.substring(++at4));
        StdTypeList parameterTypes = new StdTypeList(paramCount);
        for (int i15 = 0; i15 < paramCount; ++i15) {
            parameterTypes.set(i15, params[i15]);
        }
        return new Prototype(descriptor2, returnType, parameterTypes);
    }

    public static void clearInternTable() {
        internTable.clear();
    }

    private static Type[] makeParameterArray(String descriptor2) {
        int length = descriptor2.length();
        if (descriptor2.charAt(0) != '(') {
            throw new IllegalArgumentException("bad descriptor");
        }
        int closeAt = 0;
        int maxParams = 0;
        for (int i15 = 1; i15 < length; ++i15) {
            char c15 = descriptor2.charAt(i15);
            if (c15 == ')') {
                closeAt = i15;
                break;
            }
            if (c15 < 'A' || c15 > 'Z') continue;
            ++maxParams;
        }
        if (closeAt == 0 || closeAt == length - 1) {
            throw new IllegalArgumentException("bad descriptor");
        }
        if (descriptor2.indexOf(41, closeAt + 1) != -1) {
            throw new IllegalArgumentException("bad descriptor");
        }
        return new Type[maxParams];
    }

    public static Prototype intern(String descriptor2, Type definer, boolean isStatic, boolean isInit) {
        Prototype base = Prototype.intern(descriptor2);
        if (isStatic) {
            return base;
        }
        if (isInit) {
            definer = definer.asUninitialized(Integer.MAX_VALUE);
        }
        return base.withFirstParameter(definer);
    }

    public static Prototype internInts(Type returnType, int count) {
        StringBuilder sb5 = new StringBuilder(100);
        sb5.append('(');
        for (int i15 = 0; i15 < count; ++i15) {
            sb5.append('I');
        }
        sb5.append(')');
        sb5.append(returnType.getDescriptor());
        return Prototype.intern(sb5.toString());
    }

    private Prototype(String descriptor2, Type returnType, StdTypeList parameterTypes) {
        if (descriptor2 == null) {
            throw new NullPointerException("descriptor == null");
        }
        if (returnType == null) {
            throw new NullPointerException("returnType == null");
        }
        if (parameterTypes == null) {
            throw new NullPointerException("parameterTypes == null");
        }
        this.descriptor = descriptor2;
        this.returnType = returnType;
        this.parameterTypes = parameterTypes;
        this.parameterFrameTypes = null;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Prototype)) {
            return false;
        }
        return this.descriptor.equals(((Prototype)other).descriptor);
    }

    public int hashCode() {
        return this.descriptor.hashCode();
    }

    @Override
    public int compareTo(Prototype other) {
        if (this == other) {
            return 0;
        }
        int result = this.returnType.compareTo(other.returnType);
        if (result != 0) {
            return result;
        }
        int thisSize = this.parameterTypes.size();
        int otherSize = other.parameterTypes.size();
        int size = Math.min(thisSize, otherSize);
        for (int i15 = 0; i15 < size; ++i15) {
            Type otherType;
            Type thisType = this.parameterTypes.get(i15);
            result = thisType.compareTo(otherType = other.parameterTypes.get(i15));
            if (result == 0) continue;
            return result;
        }
        if (thisSize < otherSize) {
            return -1;
        }
        if (thisSize > otherSize) {
            return 1;
        }
        return 0;
    }

    public String toString() {
        return this.descriptor;
    }

    public String getDescriptor() {
        return this.descriptor;
    }

    public Type getReturnType() {
        return this.returnType;
    }

    public StdTypeList getParameterTypes() {
        return this.parameterTypes;
    }

    public StdTypeList getParameterFrameTypes() {
        if (this.parameterFrameTypes == null) {
            int sz4 = this.parameterTypes.size();
            StdTypeList list2 = new StdTypeList(sz4);
            boolean any = false;
            for (int i15 = 0; i15 < sz4; ++i15) {
                Type one = this.parameterTypes.get(i15);
                if (one.isIntlike()) {
                    any = true;
                    one = Type.INT;
                }
                list2.set(i15, one);
            }
            this.parameterFrameTypes = any ? list2 : this.parameterTypes;
        }
        return this.parameterFrameTypes;
    }

    public Prototype withFirstParameter(Type param) {
        String newDesc = "(" + param.getDescriptor() + this.descriptor.substring(1);
        StdTypeList newParams = this.parameterTypes.withFirst(param);
        newParams.setImmutable();
        Prototype result = new Prototype(newDesc, this.returnType, newParams);
        return Prototype.putIntern(result);
    }

    private static Prototype putIntern(Prototype desc) {
        Prototype result = internTable.putIfAbsent(desc.getDescriptor(), desc);
        return result != null ? result : desc;
    }
}

