/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.commands;

import com.android.bundle.DeviceGroup;
import com.android.bundle.DeviceId;
import com.android.bundle.DeviceProperties;
import com.android.bundle.DeviceTier;
import com.android.bundle.DeviceTierConfig;
import com.android.bundle.Devices;
import com.android.bundle.SystemFeature;
import com.android.bundle.SystemOnChip;
import com.android.tools.build.bundletool.commands.AutoValue_EvaluateDeviceTargetingConfigCommand;
import com.android.tools.build.bundletool.commands.CommandHelp;
import com.android.tools.build.bundletool.commands.CommandUtils;
import com.android.tools.build.bundletool.device.AdbServer;
import com.android.tools.build.bundletool.device.DeviceAnalyzer;
import com.android.tools.build.bundletool.device.DeviceTargetingConfigEvaluator;
import com.android.tools.build.bundletool.flags.Flag;
import com.android.tools.build.bundletool.flags.ParsedFlags;
import com.android.tools.build.bundletool.model.exceptions.InvalidCommandException;
import com.android.tools.build.bundletool.model.utils.DefaultSystemEnvironmentProvider;
import com.android.tools.build.bundletool.model.utils.SystemEnvironmentProvider;
import com.android.tools.build.bundletool.model.utils.files.BufferedIo;
import com.android.tools.build.bundletool.model.utils.files.FilePreconditions;
import com.android.tools.build.bundletool.validation.DeviceTierConfigValidator;
import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.protobuf.Message;
import com.google.protobuf.util.JsonFormat;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintStream;
import java.io.Reader;
import java.nio.file.Path;
import java.util.Optional;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;

@AutoValue
public abstract class EvaluateDeviceTargetingConfigCommand {
    public static final String COMMAND_NAME = "evaluate-device-targeting-config";
    private static final Flag<Path> DEVICE_TARGETING_CONFIGURATION_LOCATION_FLAG = Flag.path("config");
    private static final Flag<Path> DEVICE_PROPERTIES_LOCATION_FLAG = Flag.path("device-properties");
    private static final Flag<Path> ADB_PATH_FLAG = Flag.path("adb");
    private static final Flag<Boolean> CONNECTED_DEVICE_FLAG = Flag.booleanFlag("connected-device");
    private static final Flag<String> DEVICE_ID_FLAG = Flag.string("device-id");
    private static final Flag<String> COUNTRY_CODE_FLAG = Flag.string("country-code");
    private static final SystemEnvironmentProvider DEFAULT_PROVIDER = new DefaultSystemEnvironmentProvider();

    abstract Optional<AdbServer> getAdbServer();

    abstract Path getDeviceTargetingConfigurationPath();

    abstract Optional<Path> getDevicePropertiesPath();

    abstract Optional<Boolean> getConnectedDeviceMode();

    public abstract Optional<String> getDeviceId();

    public abstract Optional<String> getCountryCode();

    abstract Optional<Path> getAdbPath();

    static Builder builder() {
        return new AutoValue_EvaluateDeviceTargetingConfigCommand.Builder();
    }

    private static void validateFlags(ParsedFlags flags) {
        boolean hasConnectedDevice = CONNECTED_DEVICE_FLAG.getValue(flags).orElse(false);
        boolean hasDeviceProperties = DEVICE_PROPERTIES_LOCATION_FLAG.getValue(flags).isPresent();
        boolean hasAdbPath = ADB_PATH_FLAG.getValue(flags).isPresent();
        boolean hasDeviceId = DEVICE_ID_FLAG.getValue(flags).isPresent();
        if (hasDeviceProperties && hasConnectedDevice) {
            throw InvalidCommandException.builder().withInternalMessage("Conflicting options: '--%s' and '--%s' cannot be present together.", CONNECTED_DEVICE_FLAG.getName(), DEVICE_PROPERTIES_LOCATION_FLAG.getName()).build();
        }
        if (!hasConnectedDevice && !hasDeviceProperties) {
            throw InvalidCommandException.builder().withInternalMessage("Missing required flag: Either '--%s' or '--%s' must be specified.", CONNECTED_DEVICE_FLAG.getName(), DEVICE_PROPERTIES_LOCATION_FLAG.getName()).build();
        }
        if (hasAdbPath && !hasConnectedDevice) {
            throw InvalidCommandException.builder().withInternalMessage("Adb path can only be used with '--%s'", CONNECTED_DEVICE_FLAG.getName()).build();
        }
        if (hasDeviceId && !hasConnectedDevice) {
            throw InvalidCommandException.builder().withInternalMessage("Device id can only be used with '--%s'", CONNECTED_DEVICE_FLAG.getName()).build();
        }
    }

    public static EvaluateDeviceTargetingConfigCommand fromFlags(ParsedFlags flags, AdbServer adbServer) {
        EvaluateDeviceTargetingConfigCommand.validateFlags(flags);
        Builder evaluateDeviceTargetingConfigCommandBuilder = EvaluateDeviceTargetingConfigCommand.builder().setDeviceTargetingConfigurationPath(DEVICE_TARGETING_CONFIGURATION_LOCATION_FLAG.getRequiredValue(flags));
        DEVICE_PROPERTIES_LOCATION_FLAG.getValue(flags).ifPresent(evaluateDeviceTargetingConfigCommandBuilder::setDevicePropertiesPath);
        if (CONNECTED_DEVICE_FLAG.getValue(flags).isPresent()) {
            Path adbPath = CommandUtils.getAdbPath(flags, ADB_PATH_FLAG, DEFAULT_PROVIDER);
            evaluateDeviceTargetingConfigCommandBuilder.setAdbPath(adbPath).setAdbServer(adbServer).setConnectedDeviceMode(true).setDeviceId(DEVICE_ID_FLAG.getValue(flags));
        }
        COUNTRY_CODE_FLAG.getValue(flags).ifPresent(evaluateDeviceTargetingConfigCommandBuilder::setCountryCode);
        return evaluateDeviceTargetingConfigCommandBuilder.build();
    }

    public void execute(PrintStream out) throws IOException, TimeoutException {
        try (BufferedReader configReader = BufferedIo.reader(this.getDeviceTargetingConfigurationPath());){
            DeviceTierConfig.Builder configBuilder = DeviceTierConfig.newBuilder();
            JsonFormat.parser().merge((Reader)configReader, (Message.Builder)configBuilder);
            DeviceTierConfig config = configBuilder.build();
            DeviceTierConfigValidator.validateDeviceTierConfig(config);
            if (this.getCountryCode().isPresent()) {
                DeviceTierConfigValidator.validateCountryCode(this.getCountryCode().get());
            }
            DeviceProperties.Builder devicePropertiesBuilder = DeviceProperties.newBuilder();
            if (this.getDevicePropertiesPath().isPresent()) {
                try (BufferedReader devicePropertiesReader = BufferedIo.reader(this.getDevicePropertiesPath().get());){
                    JsonFormat.parser().merge((Reader)devicePropertiesReader, (Message.Builder)devicePropertiesBuilder);
                }
            } else {
                devicePropertiesBuilder = this.getDevicePropertiesFromConnectedDevice();
            }
            DeviceProperties deviceProperties = devicePropertiesBuilder.build();
            this.printTier(DeviceTargetingConfigEvaluator.getSelectedDeviceTier(config, deviceProperties), out);
            this.printGroups(DeviceTargetingConfigEvaluator.getMatchingDeviceGroups(config.getDeviceGroupsList(), deviceProperties), out);
            if (this.getCountryCode().isPresent()) {
                this.printCountrySet(DeviceTargetingConfigEvaluator.getMatchingCountrySet(config, this.getCountryCode().get()), out);
            }
        }
    }

    private DeviceProperties.Builder getDevicePropertiesFromConnectedDevice() throws TimeoutException {
        Path pathToAdb = this.getAdbPath().get();
        FilePreconditions.checkFileExistsAndExecutable(pathToAdb);
        AdbServer adb = this.getAdbServer().get();
        adb.init(pathToAdb);
        Devices.DeviceSpec deviceSpec = new DeviceAnalyzer(adb).getDeviceSpec(this.getDeviceId());
        return DeviceProperties.newBuilder().setDeviceId(DeviceId.newBuilder().setBuildBrand(deviceSpec.getBuildBrand()).setBuildDevice(deviceSpec.getBuildDevice())).addAllSystemFeatures(deviceSpec.getDeviceFeaturesList().stream().map(feature -> SystemFeature.newBuilder().setName((String)feature).build()).collect(ImmutableList.toImmutableList())).setRam(deviceSpec.getRamBytes()).setSystemOnChip(SystemOnChip.newBuilder().setManufacturer(deviceSpec.getSocManufacturer()).setModel(deviceSpec.getSocModel()));
    }

    private void printTier(Optional<DeviceTier> selectedTier, PrintStream out) {
        if (selectedTier.isPresent()) {
            out.println("Tier: " + selectedTier.get().getLevel());
        } else {
            out.println("Tier: 0 (default)");
        }
    }

    private void printGroups(ImmutableSet<DeviceGroup> deviceGroups, PrintStream out) {
        if (deviceGroups.isEmpty()) {
            out.println("Groups:");
        } else {
            out.println("Groups: '" + deviceGroups.stream().map(DeviceGroup::getName).collect(Collectors.joining("', '")) + "'");
        }
    }

    private void printCountrySet(String countrySet, PrintStream out) {
        out.println("Country Set: '" + countrySet + "'");
    }

    public static CommandHelp help() {
        return CommandHelp.builder().setCommandName(COMMAND_NAME).setCommandDescription(CommandHelp.CommandDescription.builder().setShortDescription("Evaluates which groups and tier a specific device would fall into, in a provided device targeting config or a connected device.").build()).addFlag(CommandHelp.FlagDescription.builder().setFlagName(DEVICE_TARGETING_CONFIGURATION_LOCATION_FLAG.getName()).setExampleValue("path/to/targeting/config.json").setDescription("Path to device targeting configuration JSON file.").build()).addFlag(CommandHelp.FlagDescription.builder().setFlagName(DEVICE_PROPERTIES_LOCATION_FLAG.getName()).setExampleValue("path/to/device_properties.json").setDescription("Path to a JSON representation of a specific device.  Cannot coexist with '%s'", CONNECTED_DEVICE_FLAG.getName()).build()).addFlag(CommandHelp.FlagDescription.builder().setFlagName(CONNECTED_DEVICE_FLAG.getName()).setDescription("If set, group and tier evaluation will be done for the connected device. Cannot coexist with '%s'.", DEVICE_PROPERTIES_LOCATION_FLAG.getName()).build()).addFlag(CommandHelp.FlagDescription.builder().setFlagName(ADB_PATH_FLAG.getName()).setExampleValue("path/to/adb").setOptional(true).setDescription("Path to the adb utility. If absent, an attempt will be made to locate it if the %s or %s environment variable is set. Used only if %s flag is set.", "ANDROID_HOME", "PATH", CONNECTED_DEVICE_FLAG).build()).addFlag(CommandHelp.FlagDescription.builder().setFlagName(DEVICE_ID_FLAG.getName()).setExampleValue("device-serial-name").setOptional(true).setDescription("Device serial name. If absent, this uses the %s environment variable. Either this flag or the environment variable is required when more than one device or emulator is connected. Used only if %s flag is set.", "ANDROID_SERIAL", CONNECTED_DEVICE_FLAG).build()).addFlag(CommandHelp.FlagDescription.builder().setFlagName(COUNTRY_CODE_FLAG.getName()).setExampleValue("VN").setOptional(true).setDescription("An ISO 3166 alpha-2 format country code for the country of user account on the device. This will be used to derive corresponding country set from device targeting configuration.").build()).build();
    }

    @AutoValue.Builder
    static abstract class Builder {
        Builder() {
        }

        abstract Builder setDeviceTargetingConfigurationPath(Path var1);

        abstract Builder setDevicePropertiesPath(Path var1);

        abstract Builder setConnectedDeviceMode(boolean var1);

        abstract Builder setAdbServer(AdbServer var1);

        abstract Builder setDeviceId(Optional<String> var1);

        abstract Builder setCountryCode(String var1);

        abstract EvaluateDeviceTargetingConfigCommand build();

        abstract Builder setAdbPath(Path var1);
    }
}

