/*
 * Decompiled with CFR 0.152.
 */
package com.formdev.flatlaf.ui;

import com.formdev.flatlaf.ui.FlatStylingSupport;
import com.formdev.flatlaf.ui.FlatUIUtils;
import com.formdev.flatlaf.util.Graphics2DProxy;
import com.formdev.flatlaf.util.HiDPIUtils;
import com.formdev.flatlaf.util.LoggingFacade;
import com.formdev.flatlaf.util.UIScale;
import java.awt.Color;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.beans.PropertyChangeListener;
import java.util.Map;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.ListSelectionModel;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicComboBoxRenderer;
import javax.swing.plaf.basic.BasicListUI;

public class FlatListUI
extends BasicListUI
implements FlatStylingSupport.StyleableUI {
    @FlatStylingSupport.Styleable
    protected Color selectionBackground;
    @FlatStylingSupport.Styleable
    protected Color selectionForeground;
    @FlatStylingSupport.Styleable
    protected Color selectionInactiveBackground;
    @FlatStylingSupport.Styleable
    protected Color selectionInactiveForeground;
    @FlatStylingSupport.Styleable
    protected Color alternateRowColor;
    @FlatStylingSupport.Styleable
    protected Insets selectionInsets;
    @FlatStylingSupport.Styleable
    protected int selectionArc;
    @FlatStylingSupport.Styleable
    protected Insets cellMargins;
    @FlatStylingSupport.Styleable
    protected Color cellFocusColor;
    @FlatStylingSupport.Styleable
    protected Boolean showCellFocusIndicator;
    private Map<String, Object> oldStyleValues;

    public static ComponentUI createUI(JComponent c15) {
        return new FlatListUI();
    }

    @Override
    public void installUI(JComponent c15) {
        if (FlatUIUtils.needsLightAWTPeer(c15)) {
            FlatUIUtils.runWithLightAWTPeerUIDefaults(() -> this.installUIImpl(c15));
        } else {
            this.installUIImpl(c15);
        }
    }

    private void installUIImpl(JComponent c15) {
        super.installUI(c15);
        this.installStyle();
    }

    @Override
    protected void installDefaults() {
        super.installDefaults();
        this.selectionBackground = UIManager.getColor("List.selectionBackground");
        this.selectionForeground = UIManager.getColor("List.selectionForeground");
        this.selectionInactiveBackground = UIManager.getColor("List.selectionInactiveBackground");
        this.selectionInactiveForeground = UIManager.getColor("List.selectionInactiveForeground");
        this.alternateRowColor = UIManager.getColor("List.alternateRowColor");
        this.selectionInsets = UIManager.getInsets("List.selectionInsets");
        this.selectionArc = UIManager.getInt("List.selectionArc");
        this.toggleSelectionColors();
    }

    @Override
    protected void uninstallDefaults() {
        super.uninstallDefaults();
        this.selectionBackground = null;
        this.selectionForeground = null;
        this.selectionInactiveBackground = null;
        this.selectionInactiveForeground = null;
        this.alternateRowColor = null;
        this.oldStyleValues = null;
    }

    @Override
    protected FocusListener createFocusListener() {
        return new BasicListUI.FocusHandler(){

            @Override
            public void focusGained(FocusEvent e15) {
                super.focusGained(e15);
                FlatListUI.this.toggleSelectionColors();
            }

            @Override
            public void focusLost(FocusEvent e15) {
                super.focusLost(e15);
                EventQueue.invokeLater(() -> FlatListUI.this.toggleSelectionColors());
            }
        };
    }

    @Override
    protected PropertyChangeListener createPropertyChangeListener() {
        PropertyChangeListener superListener = super.createPropertyChangeListener();
        return e15 -> {
            superListener.propertyChange(e15);
            switch (e15.getPropertyName()) {
                case "JComponent.focusOwner": {
                    this.toggleSelectionColors();
                    break;
                }
                case "FlatLaf.style": 
                case "FlatLaf.styleClass": {
                    this.installStyle();
                    this.list.revalidate();
                    HiDPIUtils.repaint(this.list);
                }
            }
        };
    }

    @Override
    protected ListSelectionListener createListSelectionListener() {
        ListSelectionListener superListener = super.createListSelectionListener();
        return e15 -> {
            superListener.valueChanged(e15);
            if (this.useUnitedRoundedSelection(true, true) && !this.list.isSelectionEmpty() && this.list.getMaxSelectionIndex() - this.list.getMinSelectionIndex() >= 1) {
                int lastIndex;
                int size = this.list.getModel().getSize();
                int firstIndex = Math.min(Math.max(e15.getFirstIndex(), 0), size - 1);
                Rectangle r15 = this.getCellBounds(this.list, firstIndex, lastIndex = Math.min(Math.max(e15.getLastIndex(), 0), size - 1));
                if (r15 != null) {
                    int arc = (int)Math.ceil(UIScale.scale((float)this.selectionArc / 2.0f));
                    HiDPIUtils.repaint(this.list, r15.x - arc, r15.y - arc, r15.width + arc * 2, r15.height + arc * 2);
                }
            }
        };
    }

    protected void installStyle() {
        try {
            this.applyStyle(FlatStylingSupport.getResolvedStyle(this.list, "List"));
        }
        catch (RuntimeException ex4) {
            LoggingFacade.INSTANCE.logSevere(null, ex4);
        }
    }

    protected void applyStyle(Object style) {
        Color oldSelectionBackground = this.selectionBackground;
        Color oldSelectionForeground = this.selectionForeground;
        Color oldSelectionInactiveBackground = this.selectionInactiveBackground;
        Color oldSelectionInactiveForeground = this.selectionInactiveForeground;
        this.oldStyleValues = FlatStylingSupport.parseAndApply(this.oldStyleValues, style, this::applyStyleProperty);
        if (this.selectionBackground != oldSelectionBackground) {
            Color selBg = this.list.getSelectionBackground();
            if (selBg == oldSelectionBackground) {
                this.list.setSelectionBackground(this.selectionBackground);
            } else if (selBg == oldSelectionInactiveBackground) {
                this.list.setSelectionBackground(this.selectionInactiveBackground);
            }
        }
        if (this.selectionForeground != oldSelectionForeground) {
            Color selFg = this.list.getSelectionForeground();
            if (selFg == oldSelectionForeground) {
                this.list.setSelectionForeground(this.selectionForeground);
            } else if (selFg == oldSelectionInactiveForeground) {
                this.list.setSelectionForeground(this.selectionInactiveForeground);
            }
        }
    }

    protected Object applyStyleProperty(String key, Object value) {
        return FlatStylingSupport.applyToAnnotatedObjectOrComponent(this, this.list, key, value);
    }

    @Override
    public Map<String, Class<?>> getStyleableInfos(JComponent c15) {
        return FlatStylingSupport.getAnnotatedStyleableInfos(this);
    }

    @Override
    public Object getStyleableValue(JComponent c15, String key) {
        return FlatStylingSupport.getAnnotatedStyleableValue(this, key);
    }

    private void toggleSelectionColors() {
        if (this.list == null) {
            return;
        }
        if (FlatUIUtils.isPermanentFocusOwner(this.list)) {
            if (this.list.getSelectionBackground() == this.selectionInactiveBackground) {
                this.list.setSelectionBackground(this.selectionBackground);
            }
            if (this.list.getSelectionForeground() == this.selectionInactiveForeground) {
                this.list.setSelectionForeground(this.selectionForeground);
            }
        } else {
            if (this.list.getSelectionBackground() == this.selectionBackground) {
                this.list.setSelectionBackground(this.selectionInactiveBackground);
            }
            if (this.list.getSelectionForeground() == this.selectionForeground) {
                this.list.setSelectionForeground(this.selectionInactiveForeground);
            }
        }
    }

    protected void paintCell(Graphics g15, int row, Rectangle rowBounds, ListCellRenderer cellRenderer, ListModel dataModel, ListSelectionModel selModel, int leadIndex) {
        int cx4;
        int cw4;
        boolean isSelected = selModel.isSelectedIndex(row);
        boolean isDropRow = this.isDropRow(row);
        if (this.alternateRowColor != null && row % 2 != 0 && !"ComboBox.list".equals(this.list.getName())) {
            g15.setColor(this.alternateRowColor);
            float arc = UIScale.scale((float)this.selectionArc / 2.0f);
            FlatUIUtils.paintSelection((Graphics2D)g15, rowBounds.x, rowBounds.y, rowBounds.width, rowBounds.height, UIScale.scale(this.selectionInsets), arc, arc, arc, arc, 0);
        }
        Component rendererComponent = cellRenderer.getListCellRendererComponent(this.list, dataModel.getElementAt(row), row, isSelected, FlatUIUtils.isPermanentFocusOwner(this.list) && row == leadIndex);
        boolean isFileList = Boolean.TRUE.equals(this.list.getClientProperty("List.isFileList"));
        if (isFileList) {
            cw4 = Math.min(rowBounds.width, rendererComponent.getPreferredSize().width + 4);
            cx4 = this.list.getComponentOrientation().isLeftToRight() ? rowBounds.x : rowBounds.x + (rowBounds.width - cw4);
        } else {
            cx4 = rowBounds.x;
            cw4 = rowBounds.width;
        }
        if ((isSelected || isDropRow) && !isFileList && (rendererComponent instanceof DefaultListCellRenderer || rendererComponent instanceof BasicComboBoxRenderer) && (this.selectionArc > 0 || this.selectionInsets != null && !FlatUIUtils.isInsetsEmpty(this.selectionInsets))) {
            class RoundedSelectionGraphics
            extends Graphics2DProxy {
                private boolean inPaintSelection;
                final /* synthetic */ Rectangle val$rowBounds;
                final /* synthetic */ Component val$rendererComponent;
                final /* synthetic */ boolean val$isDropRow;
                final /* synthetic */ boolean val$isSelected;
                final /* synthetic */ int val$row;

                RoundedSelectionGraphics(Graphics delegate2) {
                    this.val$rowBounds = rectangle;
                    this.val$rendererComponent = component;
                    this.val$isDropRow = bl4;
                    this.val$isSelected = bl5;
                    this.val$row = n15;
                    super((Graphics2D)delegate2);
                }

                @Override
                public Graphics create() {
                    return new RoundedSelectionGraphics(super.create());
                }

                @Override
                public Graphics create(int x15, int y15, int width, int height) {
                    return new RoundedSelectionGraphics(super.create(x15, y15, width, height));
                }

                @Override
                public void fillRect(int x15, int y15, int width, int height) {
                    if (!this.inPaintSelection && x15 == 0 && y15 == 0 && width == this.val$rowBounds.width && height == this.val$rowBounds.height && this.getColor() == this.val$rendererComponent.getBackground()) {
                        this.inPaintSelection = true;
                        if (this.val$isDropRow) {
                            if (this.val$isSelected) {
                                Color oldColor = this.getColor();
                                this.setColor(FlatListUI.this.list.getSelectionBackground());
                                FlatListUI.this.paintCellSelection(this, this.val$row, x15, y15, width, height);
                                this.setColor(oldColor);
                            }
                            float arc = UIScale.scale((float)FlatListUI.this.selectionArc / 2.0f);
                            FlatUIUtils.paintSelection(this, x15, y15, width, height, UIScale.scale(FlatListUI.this.selectionInsets), arc, arc, arc, arc, 0);
                        } else {
                            FlatListUI.this.paintCellSelection(this, this.val$row, x15, y15, width, height);
                        }
                        this.inPaintSelection = false;
                    } else {
                        super.fillRect(x15, y15, width, height);
                    }
                }
            }
            g15 = new RoundedSelectionGraphics(g15);
        }
        this.rendererPane.paintComponent(g15, rendererComponent, this.list, cx4, rowBounds.y, cw4, rowBounds.height, true);
    }

    protected void paintCellSelection(Graphics g15, int row, int x15, int y15, int width, int height) {
        float arcBottomRight;
        float arcBottomLeft = arcBottomRight = UIScale.scale((float)this.selectionArc / 2.0f);
        float arcTopRight = arcBottomRight;
        float arcTopLeft = arcBottomRight;
        if (this.list.getLayoutOrientation() == 0) {
            if (this.useUnitedRoundedSelection(true, false)) {
                if (row > 0 && this.list.isSelectedIndex(row - 1)) {
                    arcTopRight = 0.0f;
                    arcTopLeft = 0.0f;
                }
                if (row < this.list.getModel().getSize() - 1 && this.list.isSelectedIndex(row + 1)) {
                    arcBottomRight = 0.0f;
                    arcBottomLeft = 0.0f;
                }
            }
        } else {
            Rectangle r15 = null;
            if (this.useUnitedRoundedSelection(true, false)) {
                r15 = this.getCellBounds(this.list, row, row);
                int topIndex = this.locationToIndex(this.list, new Point(r15.x, r15.y - 1));
                int bottomIndex = this.locationToIndex(this.list, new Point(r15.x, r15.y + r15.height));
                if (topIndex >= 0 && topIndex != row && this.list.isSelectedIndex(topIndex)) {
                    arcTopRight = 0.0f;
                    arcTopLeft = 0.0f;
                }
                if (bottomIndex >= 0 && bottomIndex != row && this.list.isSelectedIndex(bottomIndex)) {
                    arcBottomRight = 0.0f;
                    arcBottomLeft = 0.0f;
                }
            }
            if (this.useUnitedRoundedSelection(false, true)) {
                if (r15 == null) {
                    r15 = this.getCellBounds(this.list, row, row);
                }
                int leftIndex = this.locationToIndex(this.list, new Point(r15.x - 1, r15.y));
                int rightIndex = this.locationToIndex(this.list, new Point(r15.x + r15.width, r15.y));
                boolean ltr = this.list.getComponentOrientation().isLeftToRight();
                if (!ltr && leftIndex >= 0 && leftIndex != row && leftIndex == this.locationToIndex(this.list, new Point(r15.x - 1, r15.y - 1))) {
                    leftIndex = -1;
                }
                if (ltr && rightIndex >= 0 && rightIndex != row && rightIndex == this.locationToIndex(this.list, new Point(r15.x + r15.width, r15.y - 1))) {
                    rightIndex = -1;
                }
                if (leftIndex >= 0 && leftIndex != row && this.list.isSelectedIndex(leftIndex)) {
                    arcBottomLeft = 0.0f;
                    arcTopLeft = 0.0f;
                }
                if (rightIndex >= 0 && rightIndex != row && this.list.isSelectedIndex(rightIndex)) {
                    arcBottomRight = 0.0f;
                    arcTopRight = 0.0f;
                }
            }
        }
        FlatUIUtils.paintSelection((Graphics2D)g15, x15, y15, width, height, UIScale.scale(this.selectionInsets), arcTopLeft, arcTopRight, arcBottomLeft, arcBottomRight, 0);
    }

    private boolean useUnitedRoundedSelection(boolean vertical, boolean horizontal) {
        return this.selectionArc > 0 && (this.selectionInsets == null || vertical && this.selectionInsets.top == 0 && this.selectionInsets.bottom == 0 || horizontal && this.selectionInsets.left == 0 && this.selectionInsets.right == 0);
    }

    public static void paintCellSelection(JList<?> list2, Graphics g15, int row, int x15, int y15, int width, int height) {
        if (!(list2.getUI() instanceof FlatListUI)) {
            return;
        }
        FlatListUI ui4 = (FlatListUI)list2.getUI();
        ui4.paintCellSelection(g15, row, x15, y15, width, height);
    }

    private boolean isDropRow(int row) {
        JList.DropLocation dropLocation = this.list.getDropLocation();
        return dropLocation != null && !dropLocation.isInsert() && dropLocation.getIndex() == row;
    }
}

