/*
 * Decompiled with CFR 0.152.
 */
package com.formdev.flatlaf.ui;

import com.formdev.flatlaf.FlatClientProperties;
import com.formdev.flatlaf.ui.FlatStylingSupport;
import com.formdev.flatlaf.ui.FlatTextFieldUI;
import com.formdev.flatlaf.ui.FlatUIUtils;
import com.formdev.flatlaf.util.HiDPIUtils;
import com.formdev.flatlaf.util.UIScale;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.beans.PropertyChangeEvent;
import java.util.Map;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPasswordField;
import javax.swing.JToggleButton;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import javax.swing.text.PasswordView;
import javax.swing.text.View;

public class FlatPasswordFieldUI
extends FlatTextFieldUI {
    private static final String KEY_REVEAL_SELECTED = "FlatLaf.internal.FlatPasswordFieldUI.revealSelected";
    private Character echoChar;
    @FlatStylingSupport.Styleable
    protected boolean showCapsLock;
    @FlatStylingSupport.Styleable
    protected boolean showRevealButton;
    protected Icon capsLockIcon;
    protected Icon revealIcon;
    private KeyListener capsLockListener;
    private boolean capsLockIconShared = true;
    private JToggleButton revealButton;
    private boolean uninstallEchoChar;

    public static ComponentUI createUI(JComponent c15) {
        return new FlatPasswordFieldUI();
    }

    @Override
    protected String getPropertyPrefix() {
        return "PasswordField";
    }

    @Override
    public void installUI(JComponent c15) {
        super.installUI(c15);
        this.installRevealButton();
    }

    @Override
    public void uninstallUI(JComponent c15) {
        this.uninstallRevealButton();
        super.uninstallUI(c15);
    }

    @Override
    protected void installDefaults() {
        super.installDefaults();
        String prefix = this.getPropertyPrefix();
        this.echoChar = (Character)UIManager.get(prefix + ".echoChar");
        if (this.echoChar != null) {
            LookAndFeel.installProperty(this.getComponent(), "echoChar", this.echoChar);
        }
        this.showCapsLock = UIManager.getBoolean("PasswordField.showCapsLock");
        this.showRevealButton = UIManager.getBoolean("PasswordField.showRevealButton");
        this.capsLockIcon = UIManager.getIcon("PasswordField.capsLockIcon");
        this.revealIcon = UIManager.getIcon("PasswordField.revealIcon");
        this.capsLockIconShared = true;
    }

    @Override
    protected void uninstallDefaults() {
        super.uninstallDefaults();
        this.capsLockIcon = null;
        this.revealIcon = null;
    }

    @Override
    protected void installListeners() {
        super.installListeners();
        this.capsLockListener = new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e15) {
                this.repaint(e15);
            }

            @Override
            public void keyReleased(KeyEvent e15) {
                this.repaint(e15);
            }

            private void repaint(KeyEvent e15) {
                if (e15.getKeyCode() == 20) {
                    HiDPIUtils.repaint(e15.getComponent());
                    FlatPasswordFieldUI.this.scrollCaretToVisible();
                }
            }
        };
        this.getComponent().addKeyListener(this.capsLockListener);
    }

    @Override
    protected void uninstallListeners() {
        super.uninstallListeners();
        this.getComponent().removeKeyListener(this.capsLockListener);
        this.capsLockListener = null;
    }

    @Override
    protected void installKeyboardActions() {
        Action selectLineAction;
        super.installKeyboardActions();
        ActionMap map = SwingUtilities.getUIActionMap(this.getComponent());
        if (map != null && map.get("select-word") != null && (selectLineAction = map.get("select-line")) != null) {
            map.put("select-word", selectLineAction);
        }
    }

    @Override
    String getStyleType() {
        return "PasswordField";
    }

    @Override
    protected void applyStyle(Object style) {
        boolean oldShowRevealButton = this.showRevealButton;
        super.applyStyle(style);
        if (this.showRevealButton != oldShowRevealButton) {
            this.uninstallRevealButton();
            this.installRevealButton();
        }
    }

    @Override
    protected Object applyStyleProperty(String key, Object value) {
        if (key.startsWith("capsLockIcon") && this.capsLockIcon instanceof FlatStylingSupport.StyleableObject) {
            if (this.capsLockIconShared) {
                this.capsLockIcon = FlatStylingSupport.cloneIcon(this.capsLockIcon);
                this.capsLockIconShared = false;
            }
            return ((FlatStylingSupport.StyleableObject)((Object)this.capsLockIcon)).applyStyleProperty(key, value);
        }
        return super.applyStyleProperty(key, value);
    }

    @Override
    public Map<String, Class<?>> getStyleableInfos(JComponent c15) {
        Map<String, Class<?>> infos = super.getStyleableInfos(c15);
        if (this.capsLockIcon instanceof FlatStylingSupport.StyleableObject) {
            infos.putAll(((FlatStylingSupport.StyleableObject)((Object)this.capsLockIcon)).getStyleableInfos());
        }
        return infos;
    }

    @Override
    public Object getStyleableValue(JComponent c15, String key) {
        if (key.startsWith("capsLockIcon") && this.capsLockIcon instanceof FlatStylingSupport.StyleableObject) {
            return ((FlatStylingSupport.StyleableObject)((Object)this.capsLockIcon)).getStyleableValue(key);
        }
        return super.getStyleableValue(c15, key);
    }

    @Override
    public View create(Element elem) {
        return new PasswordView(elem);
    }

    @Override
    protected void paintIcons(Graphics g15, Rectangle r15) {
        super.paintIcons(g15, r15);
        if (this.isCapsLockVisible()) {
            this.paintCapsLock(g15, r15);
        }
    }

    protected void paintCapsLock(Graphics g15, Rectangle r15) {
        JTextComponent c15 = this.getComponent();
        int x15 = c15.getComponentOrientation().isLeftToRight() ? r15.x + r15.width - this.capsLockIcon.getIconWidth() : r15.x;
        int y15 = r15.y + Math.round((float)(r15.height - this.capsLockIcon.getIconHeight()) / 2.0f);
        this.capsLockIcon.paintIcon(c15, g15, x15, y15);
    }

    @Override
    protected boolean hasTrailingIcon() {
        return super.hasTrailingIcon() || this.isCapsLockVisible();
    }

    @Override
    protected int getTrailingIconWidth() {
        return super.getTrailingIconWidth() + (this.isCapsLockVisible() ? this.capsLockIcon.getIconWidth() + UIScale.scale(this.iconTextGap) : 0);
    }

    protected boolean isCapsLockVisible() {
        if (!this.showCapsLock) {
            return false;
        }
        return FlatUIUtils.isPermanentFocusOwner(this.getComponent()) && Toolkit.getDefaultToolkit().getLockingKeyState(20);
    }

    protected void installRevealButton() {
        if (this.showRevealButton) {
            this.revealButton = this.createRevealButton();
            this.updateRevealButton();
            this.installLayout();
            this.getComponent().add(this.revealButton);
        }
    }

    protected JToggleButton createRevealButton() {
        JPasswordField c15 = (JPasswordField)this.getComponent();
        JToggleButton button = new JToggleButton(this.revealIcon, !c15.echoCharIsSet());
        button.setName("PasswordField.revealButton");
        this.prepareLeadingOrTrailingComponent(button);
        button.putClientProperty("FlatLaf.styleClass", "inTextField revealButton");
        if (FlatClientProperties.clientPropertyBoolean(c15, KEY_REVEAL_SELECTED, false)) {
            button.setSelected(true);
            this.updateEchoChar(true);
        }
        button.addActionListener(e15 -> {
            boolean selected = button.isSelected();
            this.updateEchoChar(selected);
            c15.putClientProperty(KEY_REVEAL_SELECTED, selected);
        });
        return button;
    }

    protected void updateRevealButton() {
        if (this.revealButton == null) {
            return;
        }
        JTextComponent c15 = this.getComponent();
        boolean visible = c15.isEnabled();
        if (visible != this.revealButton.isVisible()) {
            this.revealButton.setVisible(visible);
            c15.revalidate();
            HiDPIUtils.repaint(c15);
            if (!visible) {
                this.revealButton.setSelected(false);
                this.updateEchoChar(false);
                this.getComponent().putClientProperty(KEY_REVEAL_SELECTED, null);
            }
        }
    }

    @Override
    protected void propertyChange(PropertyChangeEvent e15) {
        super.propertyChange(e15);
        switch (e15.getPropertyName()) {
            case "enabled": {
                this.updateRevealButton();
            }
        }
    }

    private void updateEchoChar(boolean selected) {
        JPasswordField c15;
        char newEchoChar = selected ? (char)'\u0000' : (this.echoChar != null ? (char)this.echoChar.charValue() : (char)'*');
        if (newEchoChar == (c15 = (JPasswordField)this.getComponent()).getEchoChar()) {
            return;
        }
        LookAndFeel.installProperty(c15, "echoChar", Character.valueOf(newEchoChar));
        char actualEchoChar = c15.getEchoChar();
        if (actualEchoChar != newEchoChar) {
            if (selected && actualEchoChar != '\u0000') {
                this.echoChar = Character.valueOf(actualEchoChar);
                this.uninstallEchoChar = true;
            }
            c15.setEchoChar(newEchoChar);
        }
    }

    protected void uninstallRevealButton() {
        if (this.revealButton != null) {
            if (this.uninstallEchoChar && this.revealButton.isSelected()) {
                ((JPasswordField)this.getComponent()).setEchoChar(this.echoChar.charValue());
            }
            this.getComponent().remove(this.revealButton);
            this.revealButton = null;
        }
    }

    @Override
    protected JComponent[] getTrailingComponents() {
        return new JComponent[]{this.trailingComponent, this.revealButton, this.clearButton};
    }
}

