/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.jsvg.parser.impl;

import com.github.weisj.jsvg.geometry.size.Length;
import com.github.weisj.jsvg.geometry.size.Unit;
import com.github.weisj.jsvg.parser.impl.SeparatorMode;
import com.github.weisj.jsvg.util.ParserBase;
import java.util.ArrayList;
import java.util.regex.Pattern;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ParserUtil {
    private static final Pattern WHITESPACE_PATTERN = Pattern.compile("\\s");

    private ParserUtil() {
    }

    @NotNull
    private static String removeWhiteSpace(@NotNull String value) {
        return WHITESPACE_PATTERN.matcher(value).replaceAll("");
    }

    @Nullable
    public static String parseUrl(@Nullable String value) {
        if (value == null) {
            return null;
        }
        if (!value.startsWith("url(") || !value.endsWith(")")) {
            return ParserUtil.removeWhiteSpace(value);
        }
        return ParserUtil.removeWhiteSpace(value.substring(4, value.length() - 1));
    }

    public static int parseInt(@Nullable String value, int fallback) {
        if (value == null) {
            return fallback;
        }
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e15) {
            return fallback;
        }
    }

    public static float parseFloat(@Nullable String value, float fallback) {
        if (value == null) {
            return fallback;
        }
        try {
            return Float.parseFloat(value);
        }
        catch (NumberFormatException e15) {
            return fallback;
        }
    }

    @Contract(value="_,!null -> !null")
    @Nullable
    public static Length parseNumber(@Nullable String value, @Nullable Length fallback) {
        if (value == null) {
            return fallback;
        }
        try {
            return Unit.RAW.valueOf(Float.parseFloat(value));
        }
        catch (NumberFormatException e15) {
            return fallback;
        }
    }

    public static float @NotNull [] parseFloatList(@Nullable String value) {
        String[] values2 = ParserUtil.parseStringList(value, SeparatorMode.COMMA_AND_WHITESPACE, new String[0]);
        float[] ret = new float[values2.length];
        for (int i15 = 0; i15 < ret.length; ++i15) {
            ret[i15] = ParserUtil.parseFloat(values2[i15], 0.0f);
        }
        return ret;
    }

    public static double @NotNull [] parseDoubleList(@Nullable String value) {
        if (value == null || value.isEmpty()) {
            return new double[0];
        }
        ArrayList<Double> list2 = new ArrayList<Double>();
        ParserBase base = new ParserBase(value, 0);
        while (base.hasNext()) {
            list2.add(base.nextDouble());
            base.consumeWhiteSpaceOrSeparator();
        }
        return list2.stream().mapToDouble(Double::doubleValue).toArray();
    }

    @NotNull
    public static @NotNull String @NotNull [] parseStringList(@Nullable String value, SeparatorMode separatorMode) {
        return ParserUtil.parseStringList(value, separatorMode, new String[0]);
    }

    @Contract(value="_,_,!null -> !null")
    public static @NotNull String @Nullable [] parseStringList(@Nullable String value, SeparatorMode separatorMode, @NotNull String @Nullable [] fallback) {
        int i15;
        if (value == null || value.isEmpty()) {
            return fallback;
        }
        ArrayList<String> list2 = new ArrayList<String>();
        int max = value.length();
        int start = 0;
        boolean inWhiteSpace = false;
        for (i15 = 0; i15 < max; ++i15) {
            char c15 = value.charAt(i15);
            if (Character.isWhitespace(c15)) {
                if (!inWhiteSpace && separatorMode.allowWhitespace() && i15 - start > 0) {
                    list2.add(value.substring(start, i15));
                    start = i15 + 1;
                }
                inWhiteSpace = true;
                continue;
            }
            inWhiteSpace = false;
            if (separatorMode.separator() == '\u0000' || c15 != separatorMode.separator()) continue;
            list2.add(value.substring(start, i15));
            start = i15 + 1;
        }
        if (i15 - start > 0) {
            list2.add(value.substring(start, i15));
        }
        return list2.toArray(new String[0]);
    }
}

